/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.view.ActionProvider;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import com.cisco.jabber.guest.AudioRouteManager;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.R;
import com.cisco.jabber.guest.util.Log;
import java.util.List;

class AudioOutputActionProvider
extends ActionProvider
implements DialogInterface.OnClickListener,
View.OnClickListener {
    private final Context mContext;
    private ImageView mActionView = null;
    private AudioRouteManager mRouteMgr = null;
    private List<AudioRouteManager.AudioRoute> mAvailableAudioRoutes = null;

    public AudioOutputActionProvider(Context context) {
        super(context);
        this.mContext = context;
        this.mRouteMgr = JabberGuestCall.getAudioRouteManager();
    }

    @Deprecated
    public View onCreateActionView() {
        return null;
    }

    public View onCreateActionView(MenuItem item) {
        this.mActionView = new ImageView(this.mContext);
        if (this.mRouteMgr != null) {
            this.updateAudioIcon(this.mRouteMgr.getActiveAudioRouteType());
        }
        this.mActionView.setOnClickListener((View.OnClickListener)this);
        return this.mActionView;
    }

    public void onClick(DialogInterface dialogInterface, int id) {
        dialogInterface.dismiss();
        if (this.mAvailableAudioRoutes != null && this.mAvailableAudioRoutes.size() > 0) {
            try {
                AudioRouteManager.AudioRoute route = this.mAvailableAudioRoutes.get(id);
                Log.d("JabberGuestSDK", "Audio route selected: " + route.getName());
                if (this.mRouteMgr != null && route.getAudioRouteType() != null) {
                    this.mRouteMgr.updateAudioRoute(route.getAudioRouteType());
                }
            }
            catch (IndexOutOfBoundsException e) {
                Log.d("JabberGuestSDK", "Audio route not set. Index out of bounds: " + id);
            }
        } else {
            Log.e("JabberGuestSDK", "List of available audio routes is null or empty.");
        }
        this.mAvailableAudioRoutes = null;
    }

    public void onClick(View view) {
        AlertDialog.Builder builder = this.buildDialog();
        if (builder != null) {
            builder.create().show();
        }
    }

    void updateAudioIcon(JabberGuestCall.AudioRouteType route) {
        if (route != null && this.mActionView != null) {
            Drawable icon = this.mContext.getResources().getDrawable(route.drawable);
            this.mActionView.setImageDrawable(icon);
        }
    }

    private AlertDialog.Builder buildDialog() {
        if (this.mRouteMgr == null) {
            return null;
        }
        this.mAvailableAudioRoutes = this.mRouteMgr.getAvailableAudioRoutes();
        if (this.mAvailableAudioRoutes == null || this.mAvailableAudioRoutes.isEmpty()) {
            return null;
        }
        CharSequence[] routeNames = new String[this.mAvailableAudioRoutes.size()];
        int index = 0;
        int activeRouteIndex = -1;
        for (AudioRouteManager.AudioRoute route : this.mAvailableAudioRoutes) {
            routeNames[index] = route.getName();
            if (route.isActiveRoute()) {
                activeRouteIndex = index;
            }
            ++index;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setSingleChoiceItems(routeNames, activeRouteIndex, (DialogInterface.OnClickListener)this).setNegativeButton(0x1040000, null).setTitle(R.string.jgsdk_available_audio_ouputs);
        return builder;
    }
}

