/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.text.TextUtils;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.R;
import com.cisco.jabber.guest.util.Log;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AudioRouteManager
extends BroadcastReceiver {
    private Context mContext = null;
    private AudioManager mAudioManager = null;
    private JabberGuestCall.AudioRouteType mActiveRouteType = JabberGuestCall.AudioRouteType.speaker;
    private final int BLUETOOTH_PROFILE = 1;
    private BluetoothAdapter mBluetoothAdapter = null;
    private BluetoothHeadset mBluetoothHeadset = null;
    private BluetoothProfile.ServiceListener mProfileListener = new BluetoothProfile.ServiceListener(){

        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (profile == 1 && proxy != null) {
                Log.d("JabberGuestSDK", "onServiceConnected called.");
                AudioRouteManager.this.mBluetoothHeadset = (BluetoothHeadset)proxy;
            }
        }

        public void onServiceDisconnected(int profile) {
            if (profile == 1) {
                Log.d("JabberGuestSDK", " onServiceDisconnected called.");
                AudioRouteManager.this.endBluetoothSco();
                AudioRouteManager.this.mBluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)AudioRouteManager.this.mBluetoothHeadset);
                AudioRouteManager.this.mBluetoothHeadset = null;
            }
        }
    };

    protected AudioRouteManager(Context context) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.setAudioRoute(JabberGuestCall.AudioRouteType.speaker);
        this.init();
    }

    private void init() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.HEADSET_PLUG");
        filter.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        this.mContext.registerReceiver((BroadcastReceiver)this, filter);
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.getProfileProxy(this.mContext, this.mProfileListener, 1);
        }
    }

    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals("android.intent.action.HEADSET_PLUG")) {
            int state = intent.getIntExtra("state", -1);
            switch (state) {
                case 0: {
                    if (this.mActiveRouteType != JabberGuestCall.AudioRouteType.earphone) break;
                    this.setAudioRoute(null);
                    break;
                }
                case 1: {
                    if (this.mActiveRouteType == JabberGuestCall.AudioRouteType.bluetooth) break;
                    this.setAudioRoute(JabberGuestCall.AudioRouteType.earphone);
                    break;
                }
            }
        } else if (intent.getAction().equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
            int currentScoState = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
            switch (currentScoState) {
                case 0: {
                    Log.d("JabberGuestSDK", "AudioManager.SCO_AUDIO_STATE_DISCONNECTED received.");
                    if (this.mActiveRouteType == JabberGuestCall.AudioRouteType.bluetooth) {
                        this.endBluetoothSco();
                        if (this.mAudioManager.isWiredHeadsetOn()) {
                            this.setAudioRoute(JabberGuestCall.AudioRouteType.earphone);
                            break;
                        }
                        this.setAudioRoute(JabberGuestCall.AudioRouteType.speaker);
                        break;
                    }
                    this.setAudioRoute(this.mActiveRouteType);
                    Log.d("JabberGuestSDK", "Bluetooth not active audio route. No change in route being made.");
                    break;
                }
                case 1: {
                    Log.d("JabberGuestSDK", "AudioManager.SCO_AUDIO_STATE_CONNECTED");
                    this.setAudioRoute(JabberGuestCall.AudioRouteType.bluetooth);
                    break;
                }
                case 2: {
                    Log.d("JabberGuestSDK", "AudioManager.SCO_AUDIO_STATE_CONNECTING");
                }
            }
        }
    }

    public JabberGuestCall.AudioRouteType getActiveAudioRouteType() {
        return this.mActiveRouteType;
    }

    public void updateAudioRoute(JabberGuestCall.AudioRouteType route) throws IllegalArgumentException {
        if (route == null) {
            throw new IllegalArgumentException("AudioRouteType parameter may not be NULL.");
        }
        this.setAudioRoute(route);
    }

    private void setAudioRoute(JabberGuestCall.AudioRouteType route) {
        if (route == null || route == JabberGuestCall.AudioRouteType.bluetooth) {
            route = this.isAudioRouteAvailable(JabberGuestCall.AudioRouteType.bluetooth) ? JabberGuestCall.AudioRouteType.bluetooth : (this.mAudioManager.isWiredHeadsetOn() ? JabberGuestCall.AudioRouteType.earphone : JabberGuestCall.AudioRouteType.speaker);
        }
        switch (route) {
            case bluetooth: {
                if (this.mAudioManager.isBluetoothScoOn()) break;
                this.startBluetoothSco();
                break;
            }
            case earphone: 
            case speaker: {
                if (this.mActiveRouteType == JabberGuestCall.AudioRouteType.bluetooth && this.mAudioManager.isBluetoothScoOn()) {
                    this.endBluetoothSco();
                    break;
                }
                this.mAudioManager.setSpeakerphoneOn(route == JabberGuestCall.AudioRouteType.speaker);
            }
        }
        this.mActiveRouteType = route;
        Log.d("JabberGuestSDK", "Audio now routing through: " + (Object)((Object)route));
        JabberGuestCall jc = JabberGuestCall.getInstance();
        if (jc != null) {
            jc.audioRouteUpdated(this.mActiveRouteType);
        }
    }

    public boolean isAudioRouteAvailable(JabberGuestCall.AudioRouteType route) {
        boolean isAvailable = false;
        switch (route) {
            case bluetooth: {
                if (this.mBluetoothAdapter == null || !this.mBluetoothAdapter.isEnabled() || this.mBluetoothHeadset == null) break;
                List availableHeadsets = this.mBluetoothHeadset.getConnectedDevices();
                if (availableHeadsets.size() > 0) {
                    isAvailable = true;
                }
                Log.d("JabberGuestSDK", "Headsets found: " + availableHeadsets.size());
                break;
            }
            default: {
                isAvailable = true;
            }
        }
        return isAvailable;
    }

    private void endBluetoothSco() {
        if (this.mAudioManager != null) {
            Log.d("JabberGuestSDK", "BluetoothSCO turning OFF.");
            this.mAudioManager.stopBluetoothSco();
            this.mAudioManager.setBluetoothScoOn(false);
        }
    }

    private void startBluetoothSco() {
        if (this.mAudioManager != null && this.isAudioRouteAvailable(JabberGuestCall.AudioRouteType.bluetooth)) {
            Log.d("JabberGuestSDK", "BluetoothSCO turning ON.");
            this.mAudioManager.setBluetoothScoOn(true);
            this.mAudioManager.startBluetoothSco();
        }
    }

    public List<AudioRoute> getAvailableAudioRoutes() {
        ArrayList<AudioRoute> availableAudioRoutes = new ArrayList<AudioRoute>();
        for (JabberGuestCall.AudioRouteType r : JabberGuestCall.AudioRouteType.values()) {
            AudioRoute route = null;
            if (!this.isAudioRouteAvailable(r)) continue;
            switch (r) {
                case bluetooth: {
                    List availableHeadsets = this.mBluetoothHeadset.getConnectedDevices();
                    for (BluetoothDevice device : availableHeadsets) {
                        String deviceName = TextUtils.isEmpty((CharSequence)device.getName()) ? this.mContext.getString(JabberGuestCall.AudioRouteType.bluetooth.label) : String.format(this.mContext.getString(R.string.jgsdk_bluetooth_s), device.getName());
                        route = new AudioRoute(JabberGuestCall.AudioRouteType.bluetooth, deviceName);
                    }
                    break;
                }
                case earphone: {
                    route = new AudioRoute(JabberGuestCall.AudioRouteType.earphone, this.mContext.getString(JabberGuestCall.AudioRouteType.earphone.label));
                    break;
                }
                case speaker: {
                    route = new AudioRoute(JabberGuestCall.AudioRouteType.speaker, this.mContext.getString(JabberGuestCall.AudioRouteType.speaker.label));
                    break;
                }
                default: {
                    route = null;
                }
            }
            if (route == null) continue;
            if (route.getAudioRouteType() == this.mActiveRouteType) {
                route.mIsActiveRoute = true;
            }
            availableAudioRoutes.add(route);
        }
        return availableAudioRoutes;
    }

    class AudioRoute {
        private boolean mIsActiveRoute = false;
        private JabberGuestCall.AudioRouteType mType = null;
        private String mName = null;

        private AudioRoute(JabberGuestCall.AudioRouteType route, String name) {
            this.mType = route;
            this.mName = name;
        }

        public JabberGuestCall.AudioRouteType getAudioRouteType() {
            return this.mType;
        }

        public String getName() {
            return this.mName;
        }

        public boolean isActiveRoute() {
            return this.mIsActiveRoute;
        }
    }
}

