/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.Chronometer;
import android.widget.TextView;
import com.cisco.jabber.guest.R;
import com.cisco.jabber.guest.util.Log;

abstract class BaseActivity
extends Activity {
    protected TextView mTitle;
    private Chronometer mSubtitle;
    protected AlertDialog mErrorDialog = null;

    BaseActivity() {
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.styleActionBar();
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this);
        String current_level_str = sp.getString("LOGLEVEL", "Warning");
        int current_level = Log.convertLogLevelString(current_level_str);
        Log.setLogLevel(current_level);
        String current_jcf_level_str = sp.getString("JCF_LOGLEVEL", "Warning");
        int current_jcf_level = Log.convertLogLevelString(current_jcf_level_str);
        Log.setJcfLogLevel(current_jcf_level);
        String current_cpve_level_str = sp.getString("CPVE_LOGLEVEL", "Warning");
        int current_cpve_level = Log.convertLogLevelString(current_cpve_level_str);
        Log.setCpveLogLevel(current_cpve_level);
    }

    protected void onPause() {
        super.onPause();
        if (this.mErrorDialog != null && this.mErrorDialog.isShowing()) {
            this.mErrorDialog.dismiss();
        }
        this.mErrorDialog = null;
    }

    protected int getActionBarCustomView() {
        return R.layout.jgsdk_actionbar_custom_view;
    }

    private void styleActionBar() {
        ActionBar ab = this.getActionBar();
        if (!ab.isShowing()) {
            ab.show();
        }
        ab.setCustomView(this.getActionBarCustomView());
        View v = ab.getCustomView();
        this.mTitle = (TextView)v.findViewById(16908308);
        this.mTitle.setText(this.getTitle());
        this.mSubtitle = (Chronometer)v.findViewById(16908309);
        this.setSubtitle(null);
    }

    public void setTitle(int id) {
        super.setTitle(id);
        this.mTitle.setText(this.getTitle());
    }

    public void setTitle(CharSequence s) {
        super.setTitle(s);
        this.mTitle.setText(this.getTitle());
    }

    public void setSubtitle(CharSequence s) {
        this.mSubtitle.setVisibility(TextUtils.isEmpty((CharSequence)s) ? 8 : 0);
        this.mSubtitle.stop();
        this.mSubtitle.setText(s);
    }

    public void setTitleColor(int textColor) {
        super.setTitleColor(textColor);
        this.mTitle.setTextColor(textColor);
        this.mSubtitle.setTextColor(textColor);
    }

    public void startChronometer(long base) {
        this.mSubtitle.setVisibility(0);
        this.mSubtitle.setBase(base);
        this.mSubtitle.start();
    }

    protected String getErrorMessage(Bundle bundle) {
        if (bundle == null || !bundle.containsKey("userMessage")) {
            return null;
        }
        return this.getString(bundle.getInt("userMessage"));
    }

    protected String getErrorTitle(Bundle bundle) {
        if (bundle == null || !bundle.containsKey("userMessage")) {
            return null;
        }
        return this.getString(bundle.getInt("userTitle"));
    }

    protected void displayCallErrorDialog(Intent intent, DialogInterface.OnClickListener positiveListener) {
        String message = this.getErrorMessage(intent.getExtras());
        String title = this.getErrorTitle(intent.getExtras());
        if (TextUtils.isEmpty((CharSequence)title) || TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (this.mErrorDialog != null && this.mErrorDialog.isShowing()) {
            return;
        }
        this.mErrorDialog = new AlertDialog.Builder((Context)this, R.style.jgsdk_dialog_theme).setMessage((CharSequence)message).setTitle((CharSequence)title).setPositiveButton(R.string.jgsdk_dismiss_stats_btn, positiveListener).setCancelable(false).create();
        this.mErrorDialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mErrorDialog.show();
        Button button = this.mErrorDialog.getButton(-1);
        button.setBackgroundResource(R.drawable.jgsdk_error_dialog_btn_background);
    }
}

