/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.MenuItem;
import com.cisco.jabber.guest.AudioOutputActionProvider;
import com.cisco.jabber.guest.AudioRouteManager;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.R;
import java.util.List;

abstract class BaseFragment
extends Fragment {
    protected MenuItem mAudioRouteItem = null;
    private Activity mActivity;
    private static InvalidCertDialogData mInvalidCertDialogData;
    protected JabberGuestCall.JabberGuestInvalidCertificateCallback mInvalidCertCallback;
    private AlertDialog mDialog;

    BaseFragment() {
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getActivity().setVolumeControlStream(0);
    }

    protected void setAudioRoute(JabberGuestCall.AudioRouteType route) {
        AudioOutputActionProvider actionProvider;
        if (route == null) {
            return;
        }
        if (this.mAudioRouteItem != null && (actionProvider = (AudioOutputActionProvider)this.mAudioRouteItem.getActionProvider()) != null) {
            actionProvider.updateAudioIcon(route);
        }
    }

    public void onPause() {
        super.onPause();
        JabberGuestCall.unregisterInvalidCertificateHandler(this.mInvalidCertCallback);
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.mDialog = null;
        }
    }

    public void onResume() {
        AudioRouteManager audioMgr;
        super.onResume();
        JabberGuestCall.registerInvalidCertificateHandler(this.mInvalidCertCallback);
        if (mInvalidCertDialogData != null) {
            this.showInvalidCertDialog(mInvalidCertDialogData);
        }
        if ((audioMgr = JabberGuestCall.getAudioRouteManager()) != null) {
            JabberGuestCall.AudioRouteType audioType = audioMgr.getActiveAudioRouteType();
            this.setAudioRoute(audioType);
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mActivity = activity;
        this.mInvalidCertCallback = new JabberGuestCall.JabberGuestInvalidCertificateCallback(){

            @Override
            public void onInvalidCertificate(String certFingerprint, String identifierToDisplay, String certSubjectCN, String referenceID, List<String> invalidReason, String subjectCertificateData, List<String> intermediateCACertificateData, boolean allowUserToAccept) {
                mInvalidCertDialogData = new InvalidCertDialogData(referenceID, subjectCertificateData, allowUserToAccept);
                BaseFragment.this.showInvalidCertDialog(mInvalidCertDialogData);
            }
        };
    }

    private void showInvalidCertDialog(final InvalidCertDialogData data) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.mActivity, R.style.jgsdk_dialog_theme);
        String message = String.format(this.getString(R.string.jgsdk_certificate_warn_message), JabberGuestCall.getInstance().getToUri().getAuthority());
        builder.setMessage((CharSequence)message).setTitle(R.string.jgsdk_certificate_warn_title).setNegativeButton(R.string.jgsdk_decline, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface di, int id) {
                mInvalidCertDialogData = null;
                JabberGuestCall instance = JabberGuestCall.getInstance();
                if (instance != null) {
                    instance.rejectInvalidCertificate();
                }
                BaseFragment.this.mActivity.finish();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                mInvalidCertDialogData = null;
                JabberGuestCall instance = JabberGuestCall.getInstance();
                if (instance != null) {
                    instance.rejectInvalidCertificate();
                }
                BaseFragment.this.mActivity.finish();
            }
        });
        if (data.allowUserToAccept) {
            builder.setPositiveButton(R.string.jgsdk_accept, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface di, int id) {
                    mInvalidCertDialogData = null;
                    JabberGuestCall instance = JabberGuestCall.getInstance();
                    instance.acceptInvalidCertificate(data.referenceId, data.certificateData);
                }
            });
        }
        this.mDialog = builder.create();
        this.mDialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.show();
    }

    private class InvalidCertDialogData {
        String referenceId;
        String certificateData;
        boolean allowUserToAccept = false;

        InvalidCertDialogData(String refId, String certData, boolean allow) {
            this.referenceId = refId;
            this.certificateData = certData;
            this.allowUserToAccept = allow;
        }
    }
}

