/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.R;
import com.cisco.jabber.guest.RenderCallbacks;
import com.cisco.jabber.guest.util.Log;
import java.lang.ref.WeakReference;

public abstract class BaseTextureViewLayout
extends FrameLayout
implements RenderCallbacks {
    protected BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("jgsdkInstanceAvailable".equals(action)) {
                BaseTextureViewLayout.this.processNewInstanceAvailable(intent);
            } else if ("jgsdkCallStateChanged".equals(action)) {
                BaseTextureViewLayout.this.processCallStateChanged(intent);
            } else if ("jgsdkCallControlEvent".equals(action)) {
                BaseTextureViewLayout.this.processCallControlEvent(intent);
            } else if ("jgsdkCallErrorEvent".equals(action)) {
                BaseTextureViewLayout.this.processCallErrorEvent(intent);
            }
        }
    };
    protected WeakReference<JabberGuestCall> mJabberCallReference = null;
    protected TextureView mTextureView = null;
    protected int mFrameWidth = 0;
    protected int mFrameHeight = 0;
    protected int mMaxWidth = Integer.MAX_VALUE;
    protected int mMaxHeight = Integer.MAX_VALUE;

    public BaseTextureViewLayout(Context context, AttributeSet attrs, int defStyle, int layout2) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle, layout2);
    }

    public BaseTextureViewLayout(Context context, AttributeSet attrs, int layout2) {
        super(context, attrs);
        this.init(context, attrs, 0, layout2);
    }

    public BaseTextureViewLayout(Context context, int layout2) {
        super(context);
        this.init(context, null, 0, layout2);
    }

    void init(Context context, AttributeSet attrs, int defStyle, int layout2) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BaseTextureViewLayout, defStyle, 0);
        this.mMaxWidth = a.getDimensionPixelSize(0, this.mMaxWidth);
        this.mMaxHeight = a.getDimensionPixelSize(1, this.mMaxHeight);
        a.recycle();
        View.inflate((Context)this.getContext(), (int)layout2, (ViewGroup)this);
        this.mTextureView = (TextureView)this.findViewById(R.id.jgsdk_texture);
    }

    public TextureView getTextureView() {
        return this.mTextureView;
    }

    protected void processNewInstanceAvailable(Intent intent) {
        this.mJabberCallReference = new WeakReference<JabberGuestCall>(JabberGuestCall.getInstance());
        ((JabberGuestCall)this.mJabberCallReference.get()).registerContext(this.getContext());
    }

    protected void processCallStateChanged(Intent intent) {
    }

    protected void processCallControlEvent(Intent intent) {
    }

    protected void processCallErrorEvent(Intent intent) {
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        JabberGuestCall.registerReceiver(this.getContext(), this.mBroadcastReceiver);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        JabberGuestCall.unregisterReceiver(this.mBroadcastReceiver);
    }

    protected JabberGuestCall getJabberGuestCallFromReference() {
        if (this.mJabberCallReference != null) {
            JabberGuestCall instance = (JabberGuestCall)this.mJabberCallReference.get();
            return instance;
        }
        return null;
    }

    public void onFramesDropped() {
        Log.d("JabberGuestSDK", String.format("%s onFramesDropped", this.getClass().getSimpleName()));
    }

    public void onFramesResumed() {
        Log.d("JabberGuestSDK", String.format("%s onFramesResumed", this.getClass().getSimpleName()));
    }

    public void onFrameSizeChanged(int width, int height) {
        this.mFrameWidth = width;
        this.mFrameHeight = height;
        Log.d("JabberGuestSDK", String.format("%s onFrameSizeChanged %d, %d", this.getClass().getSimpleName(), width, height));
    }

    public void onFirstFrame() {
        Log.d("JabberGuestSDK", String.format("%s onFirstFrame", this.getClass().getSimpleName()));
    }
}

