/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.KeypadView;
import com.cisco.jabber.guest.R;
import com.cisco.jabber.guest.util.Log;

public class CallBarView
extends LinearLayout
implements View.OnClickListener {
    public static final int BUTTON_AUDIO = 1;
    public static final int BUTTON_VIDEO = 2;
    public static final int BUTTON_KEYPAD = 8;
    public static final int BUTTON_HOOK = 16;
    public static final int BUTTON_ALL = 255;
    private int mButtons;
    private KeypadView mKeypadView;
    protected BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            CallBarView.this.updateButtonStates();
        }
    };

    public CallBarView(Context context) {
        this(context, null, 0);
    }

    public CallBarView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallBarView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CallBarView, 0, 0);
        try {
            this.mButtons = a.getInteger(1, 255);
        }
        finally {
            a.recycle();
        }
        this.mKeypadView = new KeypadView(this.getContext());
        this.addButtons();
        JabberGuestCall.getInstance().registerContext(context);
    }

    public void setButtons(int buttons) {
        this.mButtons = buttons;
        this.addButtons();
    }

    private boolean isButtonDesired(int button) {
        return (this.mButtons & button) != 0;
    }

    private void addButton(int button) {
        int res;
        int text;
        int buttonLayout = R.layout.jgsdk_call_control_button;
        switch (button) {
            case 1: {
                text = R.string.jgsdk_control_bar_mute;
                res = R.drawable.jgsdk_ic_ccb_mute;
                break;
            }
            case 2: {
                text = R.string.jgsdk_video;
                res = R.drawable.jgsdk_ic_ccb_stop;
                break;
            }
            case 8: {
                text = R.string.jgsdk_control_bar_keypad;
                res = R.drawable.jgsdk_ic_ccb_keypad;
                break;
            }
            case 16: {
                text = R.string.jgsdk_control_bar_end;
                res = R.drawable.jgsdk_ic_ccb_end;
                buttonLayout = R.layout.jgsdk_call_control_imagebutton;
                break;
            }
            default: {
                res = 0;
                text = 0;
            }
        }
        CallBarView.inflate((Context)this.getContext(), (int)buttonLayout, (ViewGroup)this);
        View btn = this.getChildAt(this.getChildCount() - 1);
        if (button == 16) {
            ((ImageView)btn).setImageResource(res);
        } else {
            ((Button)btn).setCompoundDrawablesWithIntrinsicBounds(0, res, 0, 0);
            ((Button)btn).setText(text);
        }
        btn.setId(button);
        btn.setOnClickListener((View.OnClickListener)this);
    }

    private void updateButtonStates() {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            JabberGuestCall call;
            View btn = this.getChildAt(i);
            int button = btn.getId();
            if (button != 1 && button != 2 || (call = JabberGuestCall.getInstance()) == null) continue;
            if (button == 1) {
                btn.setActivated(call.isAudioMuted());
                continue;
            }
            if (button != 2) continue;
            btn.setActivated(call.isVideoMuted());
        }
    }

    private void addButtons() {
        int buttonCount;
        this.removeAllViews();
        if (this.isButtonDesired(1)) {
            this.addButton(1);
        }
        if (this.isButtonDesired(2)) {
            this.addButton(2);
        }
        if (this.isButtonDesired(8)) {
            this.addButton(8);
        }
        if (this.isButtonDesired(16)) {
            this.addButton(16);
        }
        if ((buttonCount = this.getChildCount()) == 1) {
            this.setBackgroundResourceWithPadding(this.getChildAt(0), R.drawable.jgsdk_ccb_background);
        } else if (buttonCount > 1) {
            for (int i = 0; i < buttonCount; ++i) {
                if (i == 0) {
                    this.setBackgroundResourceWithPadding(this.getChildAt(i), R.drawable.jgsdk_ccb_background_start);
                    continue;
                }
                if (i == buttonCount - 1) {
                    this.setBackgroundResourceWithPadding(this.getChildAt(i), R.drawable.jgsdk_ccb_background_end);
                    continue;
                }
                this.setBackgroundResourceWithPadding(this.getChildAt(i), R.drawable.jgsdk_ccb_background_middle);
            }
        }
        this.updateButtonStates();
    }

    private void setBackgroundResourceWithPadding(View v, int res) {
        int left = v.getPaddingLeft();
        int top = v.getPaddingTop();
        int right = v.getPaddingRight();
        int bottom = v.getPaddingRight();
        v.setBackgroundResource(res);
        v.setPadding(left, top, right, bottom);
    }

    public void onClick(View v) {
        JabberGuestCall call = JabberGuestCall.getInstance();
        switch (v.getId()) {
            case 1: {
                if (!v.isEnabled()) break;
                if (call != null && call.isAudioMuted()) {
                    call.unmuteAudio();
                    break;
                }
                if (call == null) break;
                call.muteAudio();
                break;
            }
            case 2: {
                if (!v.isEnabled()) break;
                if (call != null && call.isVideoMuted()) {
                    call.unmuteVideo();
                    break;
                }
                if (call == null) break;
                call.muteVideo();
                break;
            }
            case 8: {
                this.toggleShowKeypad();
                v.setActivated(this.isKeypadOpen());
                break;
            }
            case 16: {
                if (call == null) break;
                call.end();
            }
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.postDelayed(new Runnable(){

            public void run() {
                if (CallBarView.this.isKeypadOpen()) {
                    CallBarView.this.showKeypad(false);
                }
            }
        }, 100L);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        JabberGuestCall.registerReceiver(this.getContext(), this.mBroadcastReceiver);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        JabberGuestCall.unregisterReceiver(this.mBroadcastReceiver);
        if (this.isKeypadOpen()) {
            this.hideKeypad();
        }
    }

    protected void showKeypad() {
        this.showKeypad(true);
    }

    protected void showKeypad(boolean animate) {
        float scale;
        int keypadTopMargin;
        if (this.isKeypadOpen()) {
            this.setTranslationY(0.0f);
            this.hideKeypad();
        }
        int[] location = new int[2];
        this.getLocationInWindow(location);
        Rect rect = new Rect();
        this.getWindowVisibleDisplayFrame(rect);
        int offset = 15 + rect.bottom - location[1];
        this.mKeypadView.setDigitsTextViewVisibility(0);
        this.mKeypadView.measure(-2, -2);
        int measuredHeight = this.mKeypadView.getMeasuredHeight();
        int statusBarHeight = rect.top;
        int keypadBottomMargin = keypadTopMargin = rect.bottom - location[1] - this.getHeight();
        if (rect.bottom - offset - measuredHeight < rect.top + 50) {
            float availableHeight = location[1] - statusBarHeight - keypadBottomMargin - keypadTopMargin;
            scale = availableHeight / (float)measuredHeight;
        } else {
            scale = 1.0f;
        }
        Log.d("JabberGuestSDK", "keypad scale = " + scale);
        int orientation = this.getResources().getConfiguration().orientation;
        if (this.getRootView() instanceof FrameLayout) {
            FrameLayout root = (FrameLayout)this.getRootView();
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
            if (orientation == 2 && (double)scale < 1.0) {
                params.topMargin = keypadTopMargin + statusBarHeight;
                params.gravity = 49;
            } else {
                params.bottomMargin = rect.bottom - location[1] + 18;
                params.gravity = 81;
            }
            this.mKeypadView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mKeypadView.setScaleX(scale);
            this.mKeypadView.setScaleY(scale);
            this.mKeypadView.setPivotX(this.mKeypadView.getMeasuredWidth() / 2);
            this.mKeypadView.setPivotY(0.0f);
            if (animate) {
                this.mKeypadView.setScaleX(0.0f);
                this.mKeypadView.setScaleY(0.0f);
                this.mKeypadView.animate().setDuration(150L).scaleY(scale).scaleX(scale);
            }
            root.addView((View)this.mKeypadView);
        }
    }

    private void hideKeypad() {
        ((ViewManager)this.mKeypadView.getParent()).removeView((View)this.mKeypadView);
    }

    protected void toggleShowKeypad() {
        if (this.isKeypadOpen()) {
            this.animate().translationY(0.0f).setDuration(150L);
            this.hideKeypad();
            this.mKeypadView.clearDisplayedDigits();
        } else {
            this.showKeypad();
        }
    }

    public boolean isKeypadOpen() {
        return this.mKeypadView.getParent() != null;
    }
}

