/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.DragEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.cisco.jabber.guest.BaseFragment;
import com.cisco.jabber.guest.CallBarView;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.R;
import com.cisco.jabber.guest.RemoteView;
import com.cisco.jabber.guest.util.Log;

public class CallFragment
extends BaseFragment
implements View.OnTouchListener {
    public static final String ARG_CALL_BAR_FADE_DELAY = "call-bar-fade-delay";
    public static final int DEFAULT_HIDE_DELAY = 3000;
    private int mCallBarFadeDelay = 3000;
    private boolean mIsCallBarShowing = false;
    public static final String ARG_AUTO_HIDE_ACTION_BAR = "auto-hide-action-bar";
    private boolean mAutoHideActionBar = false;
    private final int mutedIconsAnimationDuration = 300;
    private static final String PREF_JGSDK_CALL_FRAGMENT = "jgsdk-call-fragment";
    private static final String PREF_SELF_VIEW_MINIMIZED = "self-view-minimized";
    private static final String PREF_SELF_VIEW_POSITION = "self-view-position";
    private SharedPreferences mPreferences;
    private Handler mHandler = new Handler();
    private Runnable mHideControlsRunnable = new Runnable(){

        public void run() {
            if (CallFragment.this.canAutoHideCallBar()) {
                CallFragment.this.hideCallBar();
            }
        }
    };
    View.OnTouchListener mDraggabbleTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getActionMasked()) {
                case 0: {
                    v.invalidate();
                    return v.startDrag(null, new View.DragShadowBuilder(v), (Object)v, 0);
                }
            }
            return false;
        }
    };
    View.OnDragListener mDragListener = new View.OnDragListener(){

        public boolean onDrag(View v, DragEvent event) {
            switch (event.getAction()) {
                case 1: {
                    break;
                }
                case 4: {
                    CallFragment.this.positionSelfView(null);
                    break;
                }
                case 2: {
                    boolean top = event.getY() < (float)(v.getHeight() / 2);
                    boolean left = event.getX() < (float)(v.getWidth() / 2);
                    SelfViewPosition position = SelfViewPosition.valueOf(top, left);
                    if (position == CallFragment.this.mSelfViewPosition) break;
                    CallFragment.this.positionSelfView(position);
                }
            }
            return true;
        }
    };
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("jgsdkInstanceAvailable".equals(action)) {
                CallFragment.this.processNewInstanceAvailable(intent);
            } else if ("jgsdkCallStateChanged".equals(action)) {
                CallFragment.this.processCallStateChanged(intent);
            } else if ("jgsdkCallControlEvent".equals(action)) {
                CallFragment.this.processCallControlEvent(intent);
            } else if ("jgsdkCallErrorEvent".equals(action)) {
                CallFragment.this.processCallErrorEvent(intent);
            }
        }
    };
    protected Runnable mUpdateStatistics = new Runnable(){

        private void setStatisticsText(int id2, String s) {
            ((TextView)CallFragment.this.mStatisticsView.findViewById(id2)).setText((CharSequence)s);
        }

        public void run() {
            JabberGuestCall instance = JabberGuestCall.getInstance();
            if (CallFragment.this.mStatisticsView.getVisibility() != 0 || instance == null || instance.getState() != JabberGuestCall.State.GuestCallStateConnected) {
                return;
            }
            JabberGuestCall.CallStatistics callStats = instance.getStatistics();
            this.setStatisticsText(R.id.jgsdk_audio_receive_codec_name, callStats.audioReceiveCodecName);
            this.setStatisticsText(R.id.jgsdk_audio_transmit_codec_name, callStats.audioTransmitCodecName);
            this.setStatisticsText(R.id.jgsdk_audio_receive_payload_type, Integer.toString(callStats.audioReceiveCodecPayloadType));
            this.setStatisticsText(R.id.jgsdk_audio_transmit_payload_type, Integer.toString(callStats.audioTransmitCodecPayloadType));
            this.setStatisticsText(R.id.jgsdk_video_receive_codec_name, callStats.videoReceiveCodecName);
            this.setStatisticsText(R.id.jgsdk_video_transmit_codec_name, callStats.videoTransmitCodecName);
            this.setStatisticsText(R.id.jgsdk_video_receive_payload_type, Integer.toString(callStats.videoReceiveCodecPayloadType));
            this.setStatisticsText(R.id.jgsdk_video_transmit_payload_type, Integer.toString(callStats.videoTransmitCodecPayloadType));
            this.setStatisticsText(R.id.jgsdk_video_receive_frame_rate, Float.toString(callStats.videoReceiveFramesPerSecond));
            this.setStatisticsText(R.id.jgsdk_video_transmit_frame_rate, Float.toString(callStats.videoTransmitFramesPerSecond));
            this.setStatisticsText(R.id.jgsdk_video_receive_frame_size, String.format("%d x %d", callStats.videoReceiveFrameWidth, callStats.videoReceiveFrameHeight));
            this.setStatisticsText(R.id.jgsdk_video_transmit_frame_size, String.format("%d x %d", callStats.videoTransmitFrameWidth, callStats.videoTransmitFrameHeight));
            Log.d("JabberGuestSDK", callStats.toString());
            CallFragment.this.mStatisticsView.postDelayed((Runnable)this, 500L);
        }
    };
    private ImageView mImageTagAudioMuted;
    private ImageView mImageTagVideoMuted;
    private SelfViewPosition mSelfViewPosition = SelfViewPosition.bottomRight;
    private boolean mSelfViewMinimized = false;
    private View mStatisticsView;
    private MenuItem mSelfViewMenuItem = null;
    protected RemoteView mRemoteView;
    protected View mSelfView;
    protected CallBarView mCallBarView;

    protected void showStatistics() {
        this.mStatisticsView.setVisibility(0);
        this.mHandler.post(this.mUpdateStatistics);
    }

    public void setCallBarFadeDelay(int delay) {
        this.mCallBarFadeDelay = delay;
    }

    public int getCallBarFadeDelay() {
        return this.mCallBarFadeDelay;
    }

    public void hideCallBar() {
        this.mHandler.removeCallbacks(this.mHideControlsRunnable);
        this.mIsCallBarShowing = false;
        this.mCallBarView.animate().alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                CallFragment.this.mCallBarView.setVisibility(4);
            }
        });
        Activity activity = this.getActivity();
        if (activity != null && this.mAutoHideActionBar) {
            activity.getActionBar().hide();
        }
        this.positionSelfView(null);
    }

    private void resetFadeDelay() {
        this.mHandler.removeCallbacks(this.mHideControlsRunnable);
        if (this.mCallBarFadeDelay > 0) {
            this.mHandler.postDelayed(this.mHideControlsRunnable, (long)this.mCallBarFadeDelay);
        }
    }

    public void showCallBar() {
        this.resetFadeDelay();
        this.mCallBarView.setVisibility(0);
        this.mCallBarView.animate().alpha(1.0f).setListener(null);
        this.mIsCallBarShowing = true;
        this.positionSelfView(null);
        Activity activity = this.getActivity();
        if (activity != null && this.mAutoHideActionBar) {
            activity.getActionBar().show();
        }
    }

    public boolean isKeypadOpen() {
        return this.mCallBarView.isKeypadOpen();
    }

    public boolean canAutoHideCallBar() {
        InterceptingRelativeLayout view = (InterceptingRelativeLayout)this.getView();
        if (view == null) {
            return false;
        }
        if (view.isTouchEventInProgress()) {
            return false;
        }
        if (this.isKeypadOpen()) {
            return false;
        }
        if (!this.isRemoteVideoActive()) {
            return false;
        }
        return !this.mRemoteView.areFramesDropping();
    }

    public boolean isRemoteVideoActive() {
        JabberGuestCall instance = JabberGuestCall.getInstance();
        return instance == null ? false : instance.getState() == JabberGuestCall.State.GuestCallStateConnected && instance.isRemoteVideoActive();
    }

    public void onPause() {
        super.onPause();
        JabberGuestCall.unregisterReceiver(this.mBroadcastReceiver);
    }

    public void onResume() {
        super.onResume();
        JabberGuestCall.registerReceiver(this.getActivity().getApplicationContext(), this.mBroadcastReceiver);
        this.updateAudioMuteButton();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        View v = inflater.inflate(R.layout.jgsdk_call_fragment, null);
        ((InterceptingRelativeLayout)v).setCallFragment(this);
        this.mSelfView = v.findViewById(R.id.jgsdk_self_view);
        this.mRemoteView = (RemoteView)v.findViewById(R.id.jgsdk_remote_view);
        this.mCallBarView = (CallBarView)v.findViewById(R.id.jgsdk_call_bar_view);
        this.mImageTagVideoMuted = (ImageView)v.findViewById(R.id.jgsdk_tag_mute_video);
        this.mImageTagAudioMuted = (ImageView)v.findViewById(R.id.jgsdk_tag_mute_audio);
        this.mStatisticsView = v.findViewById(R.id.jgsdk_stats_view);
        this.mPreferences = inflater.getContext().getSharedPreferences(PREF_JGSDK_CALL_FRAGMENT, 0);
        this.mSelfViewMinimized = this.mPreferences.getBoolean(PREF_SELF_VIEW_MINIMIZED, false);
        SelfViewPosition position = SelfViewPosition.values()[this.mPreferences.getInt(PREF_SELF_VIEW_POSITION, SelfViewPosition.bottomRight.ordinal())];
        Bundle args = this.getArguments();
        if (args == null) {
            args = new Bundle();
        }
        this.setCallBarFadeDelay(args.getInt(ARG_CALL_BAR_FADE_DELAY, 3000));
        this.mAutoHideActionBar = args.getBoolean(ARG_AUTO_HIDE_ACTION_BAR, false);
        v.setOnDragListener(this.mDragListener);
        this.mSelfView.setOnTouchListener(this.mDraggabbleTouchListener);
        this.mStatisticsView.findViewById(R.id.jgsdk_dismiss_stats_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CallFragment.this.mStatisticsView.setVisibility(8);
            }
        });
        JabberGuestCall instance = JabberGuestCall.getInstance();
        this.mImageTagVideoMuted.setVisibility(instance != null && instance.isVideoMuted() ? 0 : 4);
        this.mImageTagAudioMuted.setVisibility(instance != null && instance.isAudioMuted() ? 0 : 4);
        this.showCallBar();
        this.positionSelfView(position);
        return v;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        inflater.inflate(R.menu.jgsdk_call_fragment, menu2);
        this.mSelfViewMenuItem = menu2.findItem(R.id.jgsdk_item_show_self_view);
        this.mAudioRouteItem = menu2.findItem(R.id.jgsdk_item_audio_output);
    }

    public void onPrepareOptionsMenu(Menu menu2) {
        super.onPrepareOptionsMenu(menu2);
        JabberGuestCall instance = JabberGuestCall.getInstance();
        JabberGuestCall.State state = null;
        if (instance != null) {
            state = instance.getState();
        }
        this.updateSelfViewMenuIcon();
        this.mSelfViewMenuItem.setVisible(instance != null && state == JabberGuestCall.State.GuestCallStateConnected);
        this.mAudioRouteItem.setVisible(instance != null && state == JabberGuestCall.State.GuestCallStateConnected);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.jgsdk_item_show_self_view) {
            this.setSelfViewMinimized(this.mSelfView.getVisibility() == 0);
            this.positionSelfView(null);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void processCallStateChanged(Intent intent) {
        Activity activity = this.getActivity();
        if (activity != null) {
            activity.invalidateOptionsMenu();
        }
        this.showCallBar();
    }

    private void setSelfViewMinimized(boolean minimized) {
        this.mSelfViewMinimized = minimized;
        SharedPreferences.Editor edit = this.mPreferences.edit();
        edit.putBoolean(PREF_SELF_VIEW_MINIMIZED, minimized);
        edit.commit();
    }

    private void processCallControlEvent(Intent intent) {
        Bundle bundle = intent.getExtras();
        JabberGuestCall.CallControlEvent event = (JabberGuestCall.CallControlEvent)((Object)intent.getSerializableExtra("jgsdkCallControlEventValue"));
        this.showCallBar();
        switch (event) {
            case audioMuted: {
                this.mImageTagAudioMuted.setVisibility(0);
                this.muteIconsAnimation(event, (View)this.mImageTagAudioMuted);
                break;
            }
            case audioUnmuted: {
                this.muteIconsAnimation(event, (View)this.mImageTagAudioMuted);
                this.mImageTagAudioMuted.setVisibility(4);
                break;
            }
            case videoMuted: {
                this.mImageTagVideoMuted.setVisibility(0);
                this.muteIconsAnimation(event, (View)this.mImageTagVideoMuted);
                break;
            }
            case videoUnmuted: {
                this.muteIconsAnimation(event, (View)this.mImageTagVideoMuted);
                this.mImageTagVideoMuted.setVisibility(4);
                break;
            }
            case dtmfSent: {
                break;
            }
            case streamsUpdated: {
                break;
            }
            case audioRouteUpdated: {
                JabberGuestCall.AudioRouteType route;
                if (bundle == null || (route = (JabberGuestCall.AudioRouteType)((Object)bundle.getSerializable("AudioRoute"))) == null) break;
                this.setAudioRoute(route);
                break;
            }
        }
    }

    private void muteIconsAnimation(JabberGuestCall.CallControlEvent event, View v) {
        TranslateAnimation animate;
        switch (event) {
            case audioMuted: 
            case videoMuted: {
                animate = new TranslateAnimation(v.getX() > (float)v.getWidth() ? (float)v.getWidth() : (float)(-v.getWidth()), 0.0f, 0.0f, 0.0f);
                break;
            }
            case audioUnmuted: 
            case videoUnmuted: {
                animate = new TranslateAnimation(0.0f, v.getX() > (float)v.getWidth() ? (float)v.getWidth() : (float)(-v.getWidth()), 0.0f, 0.0f);
                break;
            }
            default: {
                return;
            }
        }
        animate.setDuration(300L);
        animate.setInterpolator((Interpolator)new LinearInterpolator());
        v.startAnimation((Animation)animate);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putString("mSelfViewPosition", this.mSelfViewPosition.name());
    }

    private void adjustSelfViewMargins() {
        boolean alignTop = this.mSelfViewPosition == SelfViewPosition.topLeft || this.mSelfViewPosition == SelfViewPosition.topRight;
        float translationY = 0.0f;
        if (alignTop) {
            Activity activity = this.getActivity();
            if (activity != null && activity.getActionBar().isShowing()) {
                translationY = activity.getActionBar().getHeight();
            }
        } else if (this.mIsCallBarShowing) {
            View parent = (View)this.mCallBarView.getParent();
            int space = parent.getWidth() - this.mCallBarView.getRight();
            if (this.mSelfView.getWidth() > space) {
                translationY = -(parent.getHeight() - this.mCallBarView.getTop());
            }
        }
        float currentTranslationY = this.mSelfView.getTranslationY();
        if (translationY * currentTranslationY < 0.0f) {
            this.mSelfView.setTranslationY(translationY);
        } else if (translationY != currentTranslationY) {
            this.mSelfView.animate().translationY(translationY).setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        }
    }

    private void positionSelfView(SelfViewPosition position) {
        if (position != null) {
            this.mSelfViewPosition = position;
            SharedPreferences.Editor edit = this.mPreferences.edit();
            edit.putInt(PREF_SELF_VIEW_POSITION, this.mSelfViewPosition.ordinal());
            edit.commit();
        }
        this.mSelfView.setVisibility(!this.mSelfViewMinimized ? 0 : 8);
        this.updateSelfViewMenuIcon();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mSelfView.getLayoutParams();
        layoutParams.addRule(12, 0);
        layoutParams.addRule(10, 0);
        layoutParams.addRule(11, 0);
        layoutParams.addRule(9, 0);
        layoutParams.addRule(this.mSelfViewPosition.verticalAlign, -1);
        layoutParams.addRule(this.mSelfViewPosition.horizontalAlign, -1);
        this.mSelfView.requestLayout();
        this.positionMuteBadges();
    }

    private void updateSelfViewMenuIcon() {
        if (this.mSelfViewMenuItem != null) {
            this.mSelfViewMenuItem.setIcon(this.mSelfViewMinimized ? R.drawable.jgsdk_ic_menu_toggle_selfview_default : R.drawable.jgsdk_ic_menu_toggle_selfview_selected);
        }
    }

    private void positionMuteBadges() {
        View[] badges;
        boolean alignLeft = this.mSelfViewPosition.horizontalAlign == 11;
        for (View v : badges = new View[]{this.mImageTagAudioMuted, this.mImageTagVideoMuted}) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)v.getLayoutParams();
            params.addRule(9, alignLeft ? 1 : 0);
            params.addRule(11, alignLeft ? 0 : 1);
            v.setLayoutParams((ViewGroup.LayoutParams)params);
            if (alignLeft) {
                v.setBackgroundResource(R.drawable.jgsdk_bkgd_docklet_left);
                continue;
            }
            v.setBackgroundResource(R.drawable.jgsdk_bkgd_docklet_right);
        }
    }

    private void processNewInstanceAvailable(Intent intent) {
    }

    private void processCallErrorEvent(Intent intent) {
    }

    public boolean onTouch(View view, MotionEvent event) {
        if (view != this.mSelfView) {
            this.showCallBar();
        }
        return false;
    }

    private void updateAudioMuteButton() {
        JabberGuestCall call = JabberGuestCall.getInstance();
        if (call != null && call.isAudioMuted()) {
            this.mImageTagAudioMuted.setVisibility(0);
            this.muteIconsAnimation(JabberGuestCall.CallControlEvent.audioMuted, (View)this.mImageTagAudioMuted);
        } else {
            this.muteIconsAnimation(JabberGuestCall.CallControlEvent.audioUnmuted, (View)this.mImageTagAudioMuted);
            this.mImageTagAudioMuted.setVisibility(4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SelfViewPosition {
        topLeft(10, 9),
        topRight(10, 11),
        bottomLeft(12, 9),
        bottomRight(12, 11);

        public int verticalAlign;
        public int horizontalAlign;

        private SelfViewPosition(int vertical, int horizontal) {
            this.verticalAlign = vertical;
            this.horizontalAlign = horizontal;
        }

        public static SelfViewPosition valueOf(boolean isTop, boolean isLeft) {
            if (isTop) {
                return isLeft ? topLeft : topRight;
            }
            return isLeft ? bottomLeft : bottomRight;
        }
    }

    public static class InterceptingRelativeLayout
    extends RelativeLayout {
        private CallFragment mCallFragment;
        private Rect mSelfViewRect = new Rect();
        private int mPointerDownCount = 0;
        private boolean mTouchEventInProgress = false;

        public InterceptingRelativeLayout(Context context) {
            super(context);
        }

        public InterceptingRelativeLayout(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
        }

        public InterceptingRelativeLayout(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        boolean showStatisticsSequence(MotionEvent event) {
            if (event.getActionMasked() == 0) {
                this.mPointerDownCount = 0;
            } else if (event.getActionMasked() == 5 && event.getActionIndex() == 1) {
                return ++this.mPointerDownCount == 5;
            }
            return false;
        }

        void setCallFragment(CallFragment callFragment) {
            this.mCallFragment = callFragment;
        }

        public boolean onTouchEvent(MotionEvent event) {
            if (this.mCallFragment == null) {
                return false;
            }
            if (event.getActionIndex() == 0) {
                int action = event.getActionMasked();
                boolean bl = this.mTouchEventInProgress = action != 1 && action != 3;
                if (action == 0 && !this.mSelfViewRect.contains((int)event.getX(), (int)event.getY())) {
                    this.mCallFragment.mHandler.post(new Runnable(){

                        public void run() {
                            InterceptingRelativeLayout.this.mCallFragment.showCallBar();
                        }
                    });
                }
            }
            if (!this.mTouchEventInProgress) {
                this.mCallFragment.resetFadeDelay();
            }
            if (this.showStatisticsSequence(event)) {
                this.mCallFragment.showStatistics();
            }
            return true;
        }

        public boolean onInterceptTouchEvent(MotionEvent ev) {
            this.onTouchEvent(ev);
            return false;
        }

        public boolean isTouchEventInProgress() {
            return this.mTouchEventInProgress;
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            this.mCallFragment.adjustSelfViewMargins();
            this.mCallFragment.mSelfView.getHitRect(this.mSelfViewRect);
        }
    }
}

