/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.R;

public class CallService
extends Service
implements SensorEventListener {
    public static final String ARG_PENDING_INTENT_FOR_NOTIFICATION = "pending-intent-for-notification";
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("jgsdkInstanceAvailable".equals(action)) {
                CallService.this.processNewInstanceAvailable(intent);
            } else if ("jgsdkCallStateChanged".equals(action)) {
                CallService.this.processCallStateChanged(intent);
            } else if ("jgsdkCallControlEvent".equals(action)) {
                CallService.this.processCallControlEvent(intent);
            } else if ("android.intent.action.PHONE_STATE".equals(action)) {
                JabberGuestCall call;
                String state = intent.getStringExtra("state");
                if (TelephonyManager.EXTRA_STATE_OFFHOOK.equals(state) && (call = JabberGuestCall.getInstance()) != null) {
                    call.end();
                }
            } else if ("jgsdkCallErrorEvent".equals(action)) {
                CallService.this.processCallErrorEvent(intent);
            }
        }
    };
    private int mStartId = -1;
    private boolean mIsNotificationVisible = false;
    private SensorManager mSensorManager;
    private boolean mProximityTriggeredMute = false;
    private Handler mHandler;
    private Sensor mSensor;
    private long mFirstProximityChangedEvent = 0L;
    private PendingIntent mPendingIntent;
    Runnable mMuteVideoRunnable = new Runnable(){

        public void run() {
            JabberGuestCall instance = JabberGuestCall.getInstance();
            if (instance == null) {
                return;
            }
            if (!instance.isVideoMuted()) {
                CallService.this.mProximityTriggeredMute = true;
                instance.muteVideo();
            }
        }
    };

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.mStartId = startId;
        if (intent != null) {
            this.mPendingIntent = (PendingIntent)intent.getParcelableExtra(ARG_PENDING_INTENT_FOR_NOTIFICATION);
        }
        JabberGuestCall.registerReceiver(this.getApplicationContext(), this.mBroadcastReceiver);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PHONE_STATE");
        this.registerReceiver(this.mBroadcastReceiver, filter);
        this.mSensorManager = (SensorManager)this.getSystemService("sensor");
        this.mSensor = this.mSensorManager.getDefaultSensor(8);
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensor, 3);
        this.mHandler = new Handler();
        return 1;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onDestroy() {
        if (this.mIsNotificationVisible) {
            this.clearCallNotification();
        }
        JabberGuestCall.unregisterReceiver(this.mBroadcastReceiver);
        this.unregisterReceiver(this.mBroadcastReceiver);
        this.mSensorManager.unregisterListener((SensorEventListener)this);
    }

    private void processNewInstanceAvailable(Intent intent) {
        JabberGuestCall instance = JabberGuestCall.getInstance();
        this.updateNewJabberGuestCallState(instance, instance.getState());
    }

    private void processCallStateChanged(Intent intent) {
        JabberGuestCall.State state = (JabberGuestCall.State)((Object)intent.getSerializableExtra("jgsdkCallStateValue"));
        JabberGuestCall instance = JabberGuestCall.getInstance();
        this.updateNewJabberGuestCallState(instance, state);
    }

    private void updateNewJabberGuestCallState(JabberGuestCall instance, JabberGuestCall.State state) {
        switch (state) {
            case GuestCallStateNotInitialized: {
                break;
            }
            case GuestCallStateDisconnected: {
                break;
            }
            case GuestCallStateDisconnecting: {
                this.clearCallNotification();
                this.stopSelf();
                break;
            }
            case GuestCallStateConnected: {
                break;
            }
            case GuestCallStateConnecting: {
                this.setCallNotification();
                break;
            }
        }
    }

    private void processCallControlEvent(Intent intent) {
        JabberGuestCall call = JabberGuestCall.getInstance();
        if (call != null && !call.isVideoMuted()) {
            this.mProximityTriggeredMute = false;
        }
    }

    private void processCallErrorEvent(Intent intent) {
    }

    protected void setCallNotification() {
        JabberGuestCall call = JabberGuestCall.getInstance();
        String appName = this.getResources().getString(this.getApplicationInfo().labelRes);
        String toName = call != null ? call.getToDisplayName() : "";
        Notification notification = new Notification.Builder((Context)this).setContentTitle((CharSequence)appName).setContentText((CharSequence)String.format(this.getString(R.string.jgsdk_call_with), toName)).setSmallIcon(R.drawable.jgsdk_ic_stat_notify_jabber_guest).setContentIntent(this.mPendingIntent).setOngoing(true).getNotification();
        this.startForeground(this.mStartId, notification);
        this.mIsNotificationVisible = true;
    }

    protected void clearCallNotification() {
        this.stopForeground(true);
        this.mIsNotificationVisible = false;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        JabberGuestCall instance = JabberGuestCall.getInstance();
        if (instance == null) {
            return;
        }
        float value = event.values[0];
        long time = SystemClock.currentThreadTimeMillis();
        if (this.mFirstProximityChangedEvent == 0L) {
            this.mFirstProximityChangedEvent = time;
        } else if (value == 0.0f && time - this.mFirstProximityChangedEvent < 500L) {
            return;
        }
        if (value < this.mSensor.getMaximumRange()) {
            this.mHandler.postDelayed(this.mMuteVideoRunnable, 1000L);
        } else {
            this.mHandler.removeCallbacks(this.mMuteVideoRunnable);
            if (instance.isVideoMuted() && this.mProximityTriggeredMute) {
                instance.unmuteVideo();
            }
        }
    }
}

