/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.media.AudioManager;
import android.media.SoundPool;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.SparseIntArray;
import android.view.OrientationEventListener;
import android.view.TextureView;
import android.view.WindowManager;
import com.cisco.jabber.guest.AudioRouteManager;
import com.cisco.jabber.guest.R;
import com.cisco.jabber.guest.RenderCallbacks;
import com.cisco.jabber.guest.jcf.JcfJabberGuestCall;
import com.cisco.jabber.guest.util.Log;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;

public abstract class JabberGuestCall {
    public static final String TAG = "JabberGuestSDK";
    public static final String ACTION_INSTANCE_AVAILABLE = "jgsdkInstanceAvailable";
    public static final String ACTION_CALL_STATE_CHANGED = "jgsdkCallStateChanged";
    public static final String ACTION_CALL_CONTROL_EVENT = "jgsdkCallControlEvent";
    public static final String ACTION_CALL_ERROR_EVENT = "jgsdkCallErrorEvent";
    public static final String ARG_CALL_STATE_VALUE = "jgsdkCallStateValue";
    public static final String ARG_CALL_CONTROL_EVENT_VALUE = "jgsdkCallControlEventValue";
    public static final String ARG_DTMF_SENT = "dtmf-sent";
    public static final String ARG_CATEGORY_LABEL = "category";
    public static final String ARG_CODE_LABEL = "code";
    public static final String ARG_INTERNAL_MESSAGE_LABEL = "message";
    public static final String ARG_USER_MESSAGE_LABEL = "userMessage";
    public static final String ARG_USER_TITLE_LABEL = "userTitle";
    public static final String ARG_AUDIO_ROUTE_UPDATE_LABEL = "AudioRoute";
    public static final int AUDIO_STREAM = 0;
    private static final IntentFilter DEFAULT_INTENT_FILTER = new IntentFilter();
    protected static JabberGuestCall mInstance;
    protected static AudioRouteManager mAudioRoutingInstance;
    protected State mState = State.GuestCallStateDisconnected;
    protected Uri mToUri = null;
    protected String mAddress = null;
    private String mToDisplayName = null;
    protected int mCurrentStreamID = 0;
    protected AudioManager mAudioManager;
    protected SoundPool mSoundPool;
    protected SparseIntArray mSoundPoolMap = new SparseIntArray("1234567890#*ABCDabcd".length());
    protected static JabberGuestInvalidCertificateCallback mJGSDKInvalidCertCallback;
    private RotationManager mRotationManager = null;
    protected Handler mHandler;
    private static LocalBroadcastManager mLBM;
    private long mElapsedRealtimeAtStart;
    protected static final String ALLOWED_DTMF = "1234567890#*ABCDabcd";
    protected static final String PREF_VIDEO_LICENSE = "JabberGuestVideoLicense";
    protected static final String VIDEO_LICENSE_IS_DISABLE = "VideoLicenseIsDiabled";

    public static void registerReceiver(Context context, BroadcastReceiver receiver) {
        JabberGuestCall.registerReceiver(context, receiver, DEFAULT_INTENT_FILTER);
    }

    public static void registerReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter) {
        Iterator actionsIter = filter.actionsIterator();
        while (actionsIter.hasNext()) {
            String action = (String)actionsIter.next();
            if (action.equals(ACTION_INSTANCE_AVAILABLE) || action.equals(ACTION_CALL_STATE_CHANGED) || action.equals(ACTION_CALL_CONTROL_EVENT) || action.equals(ACTION_CALL_ERROR_EVENT)) continue;
            throw new IllegalArgumentException("Provided filter must only contain supported values");
        }
        Log.d(TAG, "registerReceiver " + receiver.toString());
        Context appContext = context.getApplicationContext();
        if (mLBM == null) {
            mLBM = LocalBroadcastManager.getInstance((Context)appContext);
        }
        mLBM.registerReceiver(receiver, filter);
        if (filter.matchAction(ACTION_INSTANCE_AVAILABLE) && mInstance != null) {
            receiver.onReceive(appContext, new Intent(ACTION_INSTANCE_AVAILABLE));
        }
    }

    public static void unregisterReceiver(BroadcastReceiver receiver) {
        Log.d(TAG, "unregisterReceiver " + receiver.toString());
        if (mLBM != null) {
            mLBM.unregisterReceiver(receiver);
        }
    }

    private void publishNewInstanceAvailable() {
        Log.d(TAG, "JabberGuestCall newInstanceAvailable");
        if (mLBM == null) {
            return;
        }
        final Intent i = new Intent(ACTION_INSTANCE_AVAILABLE);
        Runnable newInstanceRunnable = new Runnable(){

            public void run() {
                mLBM.sendBroadcastSync(i);
            }
        };
        this.fireRunnableOnMainThread(newInstanceRunnable);
    }

    private void publishCallStateChanged(State newState) {
        Log.d(TAG, String.format("JabberGuestCall callStateChanged %s", new Object[]{newState}));
        if (mLBM == null) {
            return;
        }
        if (mInstance != this && mInstance != null) {
            return;
        }
        final Intent i = new Intent(ACTION_CALL_STATE_CHANGED);
        i.putExtra(ARG_CALL_STATE_VALUE, (Serializable)((Object)newState));
        Runnable callStateChangedRunnable = new Runnable(){

            public void run() {
                mLBM.sendBroadcastSync(i);
            }
        };
        this.fireRunnableOnMainThread(callStateChangedRunnable);
    }

    protected void publishCallControlEvent(CallControlEvent event, Bundle bundle) {
        Log.d(TAG, String.format("JabberGuestCall callControlEvent %s", new Object[]{event}));
        if (mLBM == null) {
            return;
        }
        final Intent i = new Intent(ACTION_CALL_CONTROL_EVENT);
        if (bundle != null) {
            i.replaceExtras(bundle);
        }
        i.putExtra(ARG_CALL_CONTROL_EVENT_VALUE, (Serializable)((Object)event));
        Runnable callControlEventRunnable = new Runnable(){

            public void run() {
                mLBM.sendBroadcastSync(i);
            }
        };
        this.fireRunnableOnMainThread(callControlEventRunnable);
    }

    protected void publishCallControlEvent(CallControlEvent event) {
        this.publishCallControlEvent(event, null);
    }

    protected void publishCallControlEvent(CallControlEvent event, String key, String value) {
        Bundle args = new Bundle(1);
        args.putString(key, value);
        this.publishCallControlEvent(event, args);
    }

    protected void publishCallErrorEvent(Bundle bundle) {
        Log.d(TAG, "JabberGuestCall callErrorEvent");
        if (mLBM == null) {
            return;
        }
        final Intent i = new Intent(ACTION_CALL_ERROR_EVENT);
        if (bundle != null) {
            i.replaceExtras(bundle);
        }
        Runnable callErrorEventRunnable = new Runnable(){

            public void run() {
                mLBM.sendBroadcastSync(i);
            }
        };
        this.fireRunnableOnMainThread(callErrorEventRunnable);
    }

    private void fireRunnableOnMainThread(Runnable runnable) {
        if (Looper.getMainLooper().equals(Looper.myLooper())) {
            runnable.run();
        } else {
            this.mHandler.post(runnable);
        }
    }

    public static AudioRouteManager getAudioRouteManager() {
        return mAudioRoutingInstance;
    }

    private boolean isValidToUri(Uri uri) {
        if (uri == null || uri.getScheme() == null) {
            return false;
        }
        return "jabberguest".equals(uri.getScheme()) || "jabberc".equals(uri.getScheme());
    }

    protected JabberGuestCall(Context context, Uri toUri) {
        if (!this.isValidToUri(toUri)) {
            throw new IllegalArgumentException("toUri must be in the form of jabberguest://jabberguest.server.name?uri=user@example.com");
        }
        this.mToUri = toUri;
        this.mAddress = toUri.getQueryParameter("uri");
        String name = toUri.getQueryParameter("name");
        this.mToDisplayName = TextUtils.isEmpty((CharSequence)name) ? this.mAddress : name;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.setState(State.GuestCallStateDisconnected);
        this.mRotationManager = new RotationManager(context);
    }

    protected void init(Context context) {
        this.mRotationManager.enable();
    }

    protected void initTelephonyAudio(Context context) {
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mSoundPool = new SoundPool(1, 0, 0);
        int id2 = -1;
        for (TelephonyAudio dtmf : TelephonyAudio.values()) {
            id2 = this.mSoundPool.load(context, dtmf.getAudioFileID(), 1);
            this.mSoundPoolMap.put((int)dtmf.getCharacter(), id2);
        }
    }

    public static Uri createUri(String server, String address, String displayName) {
        Uri.Builder uriBuilder = new Uri.Builder().scheme("jabberguest").authority(server).appendQueryParameter("uri", address);
        if (!TextUtils.isEmpty((CharSequence)displayName)) {
            uriBuilder.appendQueryParameter("name", displayName);
        }
        return uriBuilder.build();
    }

    public static synchronized JabberGuestCall createInstance(Context context, Uri toUri) {
        if (mInstance != null) {
            switch (mInstance.getState()) {
                case GuestCallStateNotInitialized: 
                case GuestCallStateDisconnected: {
                    break;
                }
                case GuestCallStateDisconnecting: 
                case GuestCallStateConnected: 
                case GuestCallStateConnecting: {
                    throw new IllegalStateException("Cannot create new JabberGuestCall instance until the existing instance has been ended.");
                }
            }
        }
        if (mInstance != null) {
            JabberGuestCall.mInstance.mSoundPool.release();
            JabberGuestCall.mInstance.mSoundPoolMap.clear();
        }
        mInstance = JcfJabberGuestCall.createInstance(context, toUri);
        mInstance.init(context);
        mInstance.initTelephonyAudio(context);
        mInstance.publishNewInstanceAvailable();
        if (mAudioRoutingInstance == null) {
            mAudioRoutingInstance = new AudioRouteManager(context.getApplicationContext());
        }
        return mInstance;
    }

    public static synchronized JabberGuestCall getInstance() {
        return mInstance;
    }

    public abstract boolean canSwitchCamera();

    public abstract void switchCamera();

    public void setCaptureOrientation(CaptureOrientation orientation) {
        if (orientation == CaptureOrientation.auto) {
            this.mRotationManager.enable();
        } else {
            int rotation;
            this.mRotationManager.disable();
            switch (orientation) {
                case up: {
                    rotation = 0;
                    break;
                }
                case left: {
                    rotation = 1;
                    break;
                }
                case down: {
                    rotation = 2;
                    break;
                }
                case right: {
                    rotation = 3;
                    break;
                }
                default: {
                    rotation = 0;
                }
            }
            this.onRotationChanged(rotation);
        }
    }

    public abstract boolean isFrontCamera();

    public abstract void preview();

    public abstract boolean start();

    public abstract void end();

    public void setSelfTextureView(TextureView textureView) {
        this.setSelfTextureView(textureView, null);
    }

    public abstract void setSelfTextureView(TextureView var1, RenderCallbacks var2);

    public void setRemoteTextureView(TextureView textureView) {
        this.setRemoteTextureView(textureView, null);
    }

    public abstract void setRemoteTextureView(TextureView var1, RenderCallbacks var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        State state = this.mState;
        synchronized (state) {
            return this.mState;
        }
    }

    public Uri getToUri() {
        return this.mToUri;
    }

    public abstract boolean isLocalVideoActive();

    public abstract boolean isRemoteVideoActive();

    public abstract boolean isVideoMuted();

    public abstract void muteVideo();

    public abstract void unmuteVideo();

    public abstract boolean isAudioMuted();

    public abstract void muteAudio();

    public abstract void unmuteAudio();

    public abstract void sendDigits(String var1);

    protected abstract void onRotationChanged(int var1);

    public synchronized CallStatistics getStatistics() {
        CallStatistics stats = new CallStatistics();
        stats.mElaspedRealtimeAtStart = this.mElapsedRealtimeAtStart;
        stats.mDuration = SystemClock.elapsedRealtime() - this.mElapsedRealtimeAtStart;
        if (mInstance != null) {
            mInstance.setSessionStatistics(stats);
        }
        return stats;
    }

    protected abstract void setSessionStatistics(CallStatistics var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setState(State newState) {
        State state = this.mState;
        synchronized (state) {
            if (newState == State.GuestCallStateDisconnected && this.mState == State.GuestCallStateDisconnecting) {
                this.finish();
            }
            if (newState == this.mState) {
                return;
            }
            Log.d(TAG, String.format("JabberGuestCall %s setState() %s => %s", new Object[]{this, this.mState, newState}));
            this.mState = newState;
            if (this.mState == State.GuestCallStateConnected) {
                this.mElapsedRealtimeAtStart = SystemClock.elapsedRealtime();
            }
            this.publishCallStateChanged(this.mState);
            if (this.mAudioManager != null) {
                this.mAudioManager.setMode(this.mState == State.GuestCallStateConnected ? 3 : 0);
            }
        }
    }

    public String getToDisplayName() {
        return this.mToDisplayName;
    }

    protected void playKeyPadSound(char digit) {
        if (this.mAudioManager != null && this.mSoundPoolMap != null) {
            int ringerMode = this.mAudioManager.getRingerMode();
            switch (ringerMode) {
                case 2: {
                    Integer audioID = this.mSoundPoolMap.get((int)digit);
                    if (audioID == null) break;
                    this.playAudioFile(audioID, 0);
                    break;
                }
                case 0: {
                    Log.d(TAG, "Ringer is silent.");
                    break;
                }
                case 1: {
                    Log.d(TAG, "Ringer is on vibrate.");
                }
            }
        }
    }

    private int playAudioFile(int audioID, int loop) {
        int streamID = 0;
        if (this.mAudioManager != null && this.mSoundPool != null) {
            streamID = this.mSoundPool.play(audioID, (float)this.mAudioManager.getStreamVolume(0), (float)this.mAudioManager.getStreamVolume(0), 1, loop, 1.0f);
        }
        return streamID;
    }

    protected static boolean isValidDTMF(char digit) {
        return ALLOWED_DTMF.indexOf(digit) >= 0;
    }

    public static boolean instanceExists() {
        return mInstance != null;
    }

    public void audioRouteUpdated(AudioRouteType route) {
        if (route == null) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putSerializable(ARG_AUDIO_ROUTE_UPDATE_LABEL, (Serializable)((Object)route));
        this.publishCallControlEvent(CallControlEvent.audioRouteUpdated, bundle);
    }

    public static void registerInvalidCertificateHandler(JabberGuestInvalidCertificateCallback certCallback) {
        mJGSDKInvalidCertCallback = certCallback;
    }

    public static void unregisterInvalidCertificateHandler(JabberGuestInvalidCertificateCallback certCallback) {
        if (certCallback == mJGSDKInvalidCertCallback || certCallback == null) {
            mJGSDKInvalidCertCallback = null;
        }
    }

    public abstract void acceptInvalidCertificate(String var1, String var2);

    public abstract void rejectInvalidCertificate();

    public abstract void registerContext(Context var1);

    public static void disableVideoLicenseActivation(Context context) {
        Log.d(TAG, "setVideoLicenseIsDisabled");
        SharedPreferences sp = context.getSharedPreferences(PREF_VIDEO_LICENSE, 0);
        sp.edit().putBoolean(VIDEO_LICENSE_IS_DISABLE, true).apply();
        Log.d(TAG, String.format("%s=%b", VIDEO_LICENSE_IS_DISABLE, true));
    }

    protected static boolean checkActivation(Context context) {
        if (context != null) {
            Log.d(TAG, "checkActivation");
            SharedPreferences sp = context.getSharedPreferences(PREF_VIDEO_LICENSE, 0);
            boolean value = sp.getBoolean(VIDEO_LICENSE_IS_DISABLE, false);
            Log.d(TAG, String.format("%s=%b", VIDEO_LICENSE_IS_DISABLE, value));
            return !sp.getBoolean(VIDEO_LICENSE_IS_DISABLE, false);
        }
        Log.w(TAG, "Applicaton context is null, skip Video license check");
        return true;
    }

    protected void finish() {
        if (this.mRotationManager != null) {
            this.mRotationManager.disable();
        }
    }

    static {
        DEFAULT_INTENT_FILTER.addAction(ACTION_INSTANCE_AVAILABLE);
        DEFAULT_INTENT_FILTER.addAction(ACTION_CALL_CONTROL_EVENT);
        DEFAULT_INTENT_FILTER.addAction(ACTION_CALL_STATE_CHANGED);
        DEFAULT_INTENT_FILTER.addAction(ACTION_CALL_ERROR_EVENT);
        mAudioRoutingInstance = null;
        mJGSDKInvalidCertCallback = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TelephonyAudio {
        DTMF_AUDIO_1(R.raw.jgsdk_dtmf_1, '1'),
        DTMF_AUDIO_2(R.raw.jgsdk_dtmf_2, '2'),
        DTMF_AUDIO_3(R.raw.jgsdk_dtmf_3, '3'),
        DTMF_AUDIO_4(R.raw.jgsdk_dtmf_4, '4'),
        DTMF_AUDIO_5(R.raw.jgsdk_dtmf_5, '5'),
        DTMF_AUDIO_6(R.raw.jgsdk_dtmf_6, '6'),
        DTMF_AUDIO_7(R.raw.jgsdk_dtmf_7, '7'),
        DTMF_AUDIO_8(R.raw.jgsdk_dtmf_8, '8'),
        DTMF_AUDIO_9(R.raw.jgsdk_dtmf_9, '9'),
        DTMF_AUDIO_0(R.raw.jgsdk_dtmf_0, '0'),
        DTMF_AUDIO_hash(R.raw.jgsdk_dtmf_hash, '#'),
        DTMF_AUDIO_star(R.raw.jgsdk_dtmf_star, '*');

        private final int mAudioFileID;
        private final char mCharacter;

        private TelephonyAudio(int audioFileID, char character) {
            this.mAudioFileID = audioFileID;
            this.mCharacter = character;
        }

        public char getCharacter() {
            return this.mCharacter;
        }

        public int getAudioFileID() {
            return this.mAudioFileID;
        }
    }

    private class RotationManager
    extends OrientationEventListener {
        private int mCurrentRotation;
        private WindowManager mWindowManager;

        public RotationManager(Context context) {
            super(context);
            this.mCurrentRotation = -1;
            this.mWindowManager = (WindowManager)context.getSystemService("window");
        }

        public void onOrientationChanged(int orientation) {
            int newRotation = this.mWindowManager.getDefaultDisplay().getRotation();
            if (newRotation != this.mCurrentRotation) {
                this.updateRotation(newRotation);
            }
        }

        public void enable() {
            this.updateRotation(this.mWindowManager.getDefaultDisplay().getRotation());
            super.enable();
        }

        private void updateRotation(int newRotation) {
            this.mCurrentRotation = newRotation;
            JabberGuestCall.this.onRotationChanged(this.mCurrentRotation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AudioRouteType {
        speaker(R.string.jgsdk_speaker, R.drawable.jgsdk_ic_menu_speaker_normal),
        earphone(R.string.jgsdk_earphone, R.drawable.jgsdk_ic_menu_earphone),
        bluetooth(R.string.jgsdk_bluetooth, R.drawable.jgsdk_ic_menu_bluetooth);

        final int label;
        final int drawable;

        private AudioRouteType(int label, int drawable2) {
            this.label = label;
            this.drawable = drawable2;
        }
    }

    public class CallStatistics {
        public String audioTransmitCodecName = "";
        public int audioTransmitCodecPayloadType = -1;
        public int audioTransmitCodecType;
        public int audioTransmitCodecClockRate;
        public int audioTransmitSentPackets;
        public int audioTransmitPacketsReceived;
        public int audioTransmitPacketsLost;
        public float audioTransmitPercentLost;
        public float audioTransmitCumPercentLost;
        public int audioTransmitBitrate;
        public int audioTransmitJitter;
        public int audioTransmitRoundTrip;
        public String audioReceiveCodecName = "";
        public int audioReceiveCodecPayloadType = -1;
        public int audioReceiveCodecType;
        public int audioReceiveCodecClockRate;
        public int audioReceivePacketsReceived;
        public int audioReceivePacketsLost;
        public float audioReceivePercentLost;
        public float audioReceiveCumPercentLost;
        public int audioReceiveBitrate;
        public int audioReceiveJitter;
        public String videoTransmitCodecName = "";
        public int videoTransmitCodecPayloadType = -1;
        public int videoTransmitCodecType;
        public int videoTransmitCodecClockRate;
        public int videoTransmitSentPackets;
        public int videoTransmitPacketsReceived;
        public int videoTransmitPacketsLost;
        public float videoTransmitPercentLost;
        public float videoTransmitCumPercentLost;
        public int videoTransmitBitrate;
        public int videoTransmitJitter;
        public int videoTransmitRoundTrip;
        public float videoTransmitFramesPerSecond = -1.0f;
        public int videoTransmitFrameHeight = -1;
        public int videoTransmitFrameWidth = -1;
        public String videoReceiveCodecName = "";
        public int videoReceiveCodecPayloadType = -1;
        public int videoReceiveCodecType;
        public int videoReceiveCodecClockRate;
        public int videoReceivePacketsReceived;
        public int videoReceivePacketsLost;
        public float videoReceivePercentLost;
        public float videoReceiveCumPercentLost;
        public int videoReceiveBitrate;
        public int videoReceiveJitter;
        public float videoReceiveFramesPerSecond = -1.0f;
        public int videoReceiveFrameHeight = -1;
        public int videoReceiveFrameWidth = -1;
        public long mElaspedRealtimeAtStart;
        public long mDuration;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Current Call Statistics:");
            sb.append("\n");
            for (Field f : this.getClass().getDeclaredFields()) {
                sb.append(f.getName());
                sb.append("=");
                try {
                    sb.append(f.get(this));
                }
                catch (IllegalArgumentException e) {
                    sb.append("Unknown");
                }
                catch (IllegalAccessException e) {
                    sb.append("Unknown");
                }
                sb.append("\n");
            }
            sb.append("\n");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JabberGuestInvalidCertificateCallback {
        public void onInvalidCertificate(String var1, String var2, String var3, String var4, List<String> var5, String var6, List<String> var7, boolean var8);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CaptureOrientation {
        auto,
        up,
        left,
        down,
        right;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CallControlEvent {
        audioMuted,
        audioUnmuted,
        videoMuted,
        videoUnmuted,
        dtmfSent,
        streamsUpdated,
        audioRouteUpdated,
        cameraSwitched;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        GuestCallStateDisconnected,
        GuestCallStateConnecting,
        GuestCallStateConnected,
        GuestCallStateDisconnecting,
        GuestCallStateNotInitialized;


        public boolean isActive() {
            return this == GuestCallStateConnecting || this == GuestCallStateConnected || this == GuestCallStateDisconnecting;
        }
    }
}

