/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.app.ActionBar;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.cisco.jabber.guest.BaseActivity;
import com.cisco.jabber.guest.CallFragment;
import com.cisco.jabber.guest.CallService;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.PreviewFragment;
import com.cisco.jabber.guest.R;

public class JabberGuestCallActivity
extends BaseActivity {
    public static final String ARG_ADDRESS_TO_DIAL = "jgsdk-address-to-dial";
    public static final String ARG_DISPLAY_NAME_TO_DIAL = "jgsdk-display-name-to-dial";
    public static final String ARG_JABBER_GUEST_SERVER = "jgsdk-jabber-guest-server";
    public static final String ARG_SHOW_PREVIEW = "jgsdk-show-preview";
    public static final String ARG_REDIAL_AFTER_CALL = "jgsdk-redial-after-call";
    public static final String ARG_PLAY_RING_TONE = "jgsdk-play-ring-tone";
    private static final String ARG_RESUME_CALL_FROM_NOTIFICATION = "jgsdk-resume-call-from-notification";
    private Uri mUriToDial = null;
    private JabberGuestCall.State mLastKnownState = null;
    private boolean mShowPreview = true;
    private boolean mRedialAfterCall = false;
    private boolean mPlayRingTone = true;
    private static Intent mOriginalIntent = null;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("jgsdkInstanceAvailable".equals(action)) {
                JabberGuestCallActivity.this.onJabberGuestCallInstanceAvailable();
            } else if ("jgsdkCallStateChanged".equals(action)) {
                JabberGuestCallActivity.this.onJabberGuestCallStateChanged();
            } else if (!"jgsdkCallControlEvent".equals(action) && "jgsdkCallErrorEvent".equals(action)) {
                JabberGuestCallActivity.this.onJabberGuestCallError(intent);
            }
        }
    };
    private MediaPlayer mMediaPlayer = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.onNewIntent(intent);
        }
    }

    protected void onStart() {
        super.onStart();
        JabberGuestCall.registerReceiver((Context)this, this.mBroadcastReceiver);
    }

    protected void onStop() {
        super.onStop();
        JabberGuestCall.unregisterReceiver(this.mBroadcastReceiver);
        JabberGuestCall call = JabberGuestCall.getInstance();
        if (call != null && !call.getState().isActive() && this.isFinishing()) {
            mOriginalIntent = null;
        }
    }

    protected void onPause() {
        JabberGuestCall call;
        super.onPause();
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        if ((call = JabberGuestCall.getInstance()) != null && !call.getState().isActive()) {
            call.end();
        }
    }

    protected void onNewIntent(Intent intent) {
        Uri uri;
        boolean viaLauncher;
        super.onNewIntent(intent);
        if (intent == null) {
            return;
        }
        boolean resumeCall = false;
        JabberGuestCall call = JabberGuestCall.getInstance();
        boolean bl = viaLauncher = intent != null && intent.hasCategory("android.intent.category.LAUNCHER");
        if (viaLauncher && mOriginalIntent != null) {
            intent = mOriginalIntent;
            boolean bl2 = resumeCall = call != null && call.getState().isActive();
        }
        if ((uri = intent.getData()) == null) {
            String address = intent.getStringExtra(ARG_ADDRESS_TO_DIAL);
            String displayName = intent.getStringExtra(ARG_DISPLAY_NAME_TO_DIAL);
            String server = intent.getStringExtra(ARG_JABBER_GUEST_SERVER);
            if (!TextUtils.isEmpty((CharSequence)address) && !TextUtils.isEmpty((CharSequence)server)) {
                uri = JabberGuestCall.createUri(server, address, displayName);
            }
        }
        if (uri != null && call != null && call.getState().isActive()) {
            boolean same;
            String newAddress = uri.getQueryParameter("uri");
            String currentAddress = call.getToUri().getQueryParameter("uri");
            boolean bl3 = newAddress == null ? currentAddress == null : (same = newAddress.equals(currentAddress));
            if (!same) {
                Toast.makeText((Context)this, (int)R.string.jgsdk_finish_started_call, (int)1).show();
                return;
            }
            resumeCall = true;
        }
        this.setIntent(intent);
        mOriginalIntent = intent;
        this.mUriToDial = uri;
        this.mShowPreview = intent.getBooleanExtra(ARG_SHOW_PREVIEW, true);
        this.mRedialAfterCall = intent.getBooleanExtra(ARG_REDIAL_AFTER_CALL, false);
        this.mPlayRingTone = intent.getBooleanExtra(ARG_PLAY_RING_TONE, true);
        if (this.mUriToDial != null && !(resumeCall |= intent.getBooleanExtra(ARG_RESUME_CALL_FROM_NOTIFICATION, false))) {
            this.createJabberGuestCallInstance();
        }
    }

    protected PendingIntent getPendingIntentForNotification() {
        Intent resultIntent = new Intent((Context)this, ((Object)((Object)this)).getClass());
        resultIntent.putExtras(this.getIntent());
        resultIntent.putExtra(ARG_RESUME_CALL_FROM_NOTIFICATION, true);
        PendingIntent pi = PendingIntent.getActivity((Context)this, (int)0, (Intent)resultIntent, (int)0x8000000);
        return pi;
    }

    protected void onJabberGuestCallError(Intent intent) {
        final JabberGuestCall.State errorState = (JabberGuestCall.State)((Object)intent.getSerializableExtra("jgsdkCallStateValue"));
        this.displayCallErrorDialog(intent, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (JabberGuestCallActivity.this.mErrorDialog != null) {
                    JabberGuestCallActivity.this.mErrorDialog.dismiss();
                }
                JabberGuestCallActivity.this.mErrorDialog = null;
                if (!errorState.isActive() || errorState == JabberGuestCall.State.GuestCallStateConnecting || !JabberGuestCallActivity.this.mRedialAfterCall) {
                    JabberGuestCallActivity.this.finish();
                }
            }
        });
    }

    protected void onJabberGuestCallStateChanged() {
        JabberGuestCall.State state;
        JabberGuestCall call = JabberGuestCall.getInstance();
        JabberGuestCall.State state2 = state = call != null ? call.getState() : null;
        if (call == null || state == null) {
            Log.e((String)"JabberGuestSDK", (String)"Notified of new JabberGuestCall state, but it is null. Finishing.");
            this.finish();
            return;
        }
        this.updateActionBar(call);
        if (this.mLastKnownState == null && !state.isActive()) {
            if (this.mShowPreview) {
                this.showPreviewFragment();
            } else {
                this.showCallFragment();
                call.start();
            }
        } else if (!state.isActive() && this.mLastKnownState.isActive()) {
            if (this.mRedialAfterCall) {
                this.mShowPreview = true;
                this.createJabberGuestCallInstance();
            } else if (this.mErrorDialog == null) {
                this.finish();
            }
        } else {
            Intent serviceIntent = new Intent((Context)this, CallService.class);
            serviceIntent.putExtra("pending-intent-for-notification", (Parcelable)this.getPendingIntentForNotification());
            this.startService(serviceIntent);
            this.showCallFragment();
            if (state == JabberGuestCall.State.GuestCallStateConnecting) {
                this.playRingBack();
            } else {
                this.stopRingBack();
            }
        }
        this.mLastKnownState = state;
    }

    private void createJabberGuestCallInstance() {
        JabberGuestCall.createInstance((Context)this, this.mUriToDial);
    }

    protected void onJabberGuestCallInstanceAvailable() {
        JabberGuestCall call = JabberGuestCall.getInstance();
        if (call == null) {
            Log.e((String)"JabberGuestSDK", (String)"Notified of new JabberGuestCall instance, but it is null. Finishing.");
            this.finish();
            return;
        }
        this.mLastKnownState = null;
        this.onJabberGuestCallStateChanged();
    }

    private void showCallFragment() {
        if (!(this.getContentFragment() instanceof CallFragment)) {
            CallFragment f = new CallFragment();
            f.setArguments(this.getFragmentArgs());
            this.replaceContentFragment(f);
        }
    }

    private void showPreviewFragment() {
        if (!(this.getContentFragment() instanceof PreviewFragment)) {
            PreviewFragment f = new PreviewFragment();
            f.setArguments(this.getFragmentArgs());
            this.replaceContentFragment(f);
        }
    }

    protected void updateActionBar(JabberGuestCall call) {
        Configuration configuration = this.getApplicationContext().getResources().getConfiguration();
        switch (call.getState()) {
            case GuestCallStateConnected: {
                this.setTitle(call.getToDisplayName());
                this.startChronometer(call.getStatistics().mElaspedRealtimeAtStart);
                break;
            }
            case GuestCallStateConnecting: {
                this.setTitle(R.string.jgsdk_call_calling);
                this.setSubtitle(call.getToDisplayName());
                break;
            }
            case GuestCallStateDisconnected: {
                this.getActionBar().show();
                if (!configuration.isLayoutSizeAtLeast(3) && configuration.orientation == 1) {
                    this.setTitle(R.string.jgsdk_call_ready_short);
                } else {
                    this.setTitle(R.string.jgsdk_call_ready);
                }
                this.setSubtitle(call.getToDisplayName());
                break;
            }
            case GuestCallStateDisconnecting: {
                this.setTitle(R.string.jgsdk_call_ending);
                this.setSubtitle(call.getToDisplayName());
                break;
            }
        }
        boolean preview = !call.getState().isActive();
        ActionBar actionBar = this.getActionBar();
        int res = R.drawable.jgsdk_actionbar_call_background;
        actionBar.setBackgroundDrawable(this.getResources().getDrawable(res));
        this.setTitleColor(-1);
    }

    private Bundle getFragmentArgs() {
        Bundle args = new Bundle(1);
        args.putBoolean("auto-hide-action-bar", true);
        return args;
    }

    private Fragment getContentFragment() {
        return this.getFragmentManager().findFragmentById(0x1020002);
    }

    private void replaceContentFragment(Fragment f) {
        FragmentTransaction t = this.getFragmentManager().beginTransaction();
        t.replace(0x1020002, f);
        t.commit();
    }

    private void playRingBack() {
        if (!this.mPlayRingTone) {
            return;
        }
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = MediaPlayer.create((Context)this, (int)R.raw.jgsdk_ringback);
            this.mMediaPlayer.setLooping(true);
        }
        this.mMediaPlayer.start();
    }

    private void stopRingBack() {
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        JabberGuestCall call = JabberGuestCall.getInstance();
        if (call != null) {
            this.updateActionBar(call);
        }
    }
}

