/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.content.Context;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.R;
import java.util.Locale;

public class KeypadView
extends FrameLayout
implements View.OnClickListener {
    private TextView mText;
    private Paint mPaint;
    private boolean mIsRtl;

    public KeypadView(Context context) {
        super(context);
        this.doLayout(context);
    }

    public KeypadView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.doLayout(context);
    }

    public KeypadView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.doLayout(context);
    }

    protected void doLayout(Context context) {
        KeypadView.inflate((Context)this.getContext(), (int)R.layout.jgsdk_keypad, (ViewGroup)this);
        this.addButtonClickListeners();
        this.mText = (TextView)this.findViewById(R.id.jgsdk_digits_entered);
        this.mPaint = new Paint();
        this.mPaint.setTextSize(this.mText.getTextSize());
        JabberGuestCall.getInstance().registerContext(this.getContext());
        Locale deviceLocale = context.getResources().getConfiguration().locale;
        byte directionality = Character.getDirectionality(deviceLocale.getDisplayName().charAt(0));
        this.mIsRtl = directionality == 1 || directionality == 2;
    }

    private void addButtonClickListeners() {
        int[] buttonIds;
        for (int id2 : buttonIds = new int[]{R.id.jgsdk_dial0, R.id.jgsdk_dial1, R.id.jgsdk_dial2, R.id.jgsdk_dial3, R.id.jgsdk_dial4, R.id.jgsdk_dial5, R.id.jgsdk_dial6, R.id.jgsdk_dial7, R.id.jgsdk_dial8, R.id.jgsdk_dial9, R.id.jgsdk_dial_hash, R.id.jgsdk_dial_star}) {
            View v = this.findViewById(id2);
            v.setOnClickListener((View.OnClickListener)this);
            v.setSoundEffectsEnabled(false);
        }
    }

    public void onClick(View view) {
        String keyPressed = (String)view.getTag();
        JabberGuestCall call = JabberGuestCall.getInstance();
        if (call != null && keyPressed != null) {
            this.displayDigits(keyPressed);
            call.sendDigits(keyPressed);
        }
    }

    private void displayDigits(String digit) {
        CharSequence existingDigits = this.mText.getText();
        if (existingDigits.length() > 0 && existingDigits.charAt(0) == '\u200e') {
            existingDigits = existingDigits.subSequence(1, existingDigits.length());
        }
        String digits = existingDigits + digit;
        int length = digits.length();
        int maxWidth = this.mText.getMeasuredWidth() - this.mText.getPaddingLeft() - this.mText.getPaddingRight();
        int keep = this.mPaint.breakText((CharSequence)digits, 0, length, false, (float)maxWidth, null);
        CharSequence displayDigits = digits.subSequence(length - keep, length);
        if (this.mIsRtl) {
            this.mText.setText((CharSequence)("\u200e" + displayDigits));
        } else {
            this.mText.setText(displayDigits);
        }
    }

    public void clearDisplayedDigits() {
        if (this.mText != null) {
            this.mText.setText((CharSequence)"");
        }
    }

    public void setDigitsTextViewVisibility(int visibility) {
        this.mText.setVisibility(visibility);
    }
}

