/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.cisco.jabber.guest.BaseFragment;
import com.cisco.jabber.guest.CallFragment;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.PreviewView;
import com.cisco.jabber.guest.R;

public class PreviewFragment
extends BaseFragment
implements View.OnClickListener {
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("jgsdkInstanceAvailable".equals(action)) {
                PreviewFragment.this.processNewInstanceAvailable(intent);
            } else if ("jgsdkCallStateChanged".equals(action)) {
                PreviewFragment.this.processCallStateChanged(intent);
            } else if ("jgsdkCallControlEvent".equals(action)) {
                PreviewFragment.this.processCallControlEvent(intent);
            } else if ("jgsdkCallErrorEvent".equals(action)) {
                PreviewFragment.this.processCallErrorEvent(intent);
            }
        }
    };
    private MenuItem mMuteVideoItem;
    private Button mCallButton;
    private View mTextViewVideoMuted;
    private PreviewView mPreviewView;
    private boolean mAutoTransactionToCallFragment;

    public static PreviewFragment createInstance() {
        return new PreviewFragment();
    }

    public void onPause() {
        super.onPause();
        JabberGuestCall.unregisterReceiver(this.mBroadcastReceiver);
    }

    public void onResume() {
        super.onResume();
        JabberGuestCall.registerReceiver(this.getActivity().getApplicationContext(), this.mBroadcastReceiver);
        if (this.mPreviewView != null) {
            this.mPreviewView.resetSelfTextureView();
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.jgsdk_preview_fragment, container, false);
        this.mCallButton = (Button)v.findViewById(R.id.jgsdk_call_button);
        this.mCallButton.setOnClickListener((View.OnClickListener)this);
        this.mTextViewVideoMuted = v.findViewById(R.id.jgsdk_text_video_stopped);
        this.mPreviewView = (PreviewView)v.findViewById(R.id.jgsdk_preview_view);
        this.setHasOptionsMenu(true);
        return v;
    }

    private void processNewInstanceAvailable(Intent intent) {
        this.updateVideoMuteMenuIcon();
        this.mCallButton.setEnabled(true);
    }

    private void processCallStateChanged(Intent intent) {
        JabberGuestCall.State state = (JabberGuestCall.State)((Object)intent.getSerializableExtra("jgsdkCallStateValue"));
        switch (state) {
            case GuestCallStateDisconnecting: {
                break;
            }
            case GuestCallStateDisconnected: {
                break;
            }
            case GuestCallStateConnected: {
                break;
            }
            case GuestCallStateConnecting: {
                if (!this.mAutoTransactionToCallFragment) break;
                CallFragment f = new CallFragment();
                f.setArguments(this.getArguments());
                FragmentTransaction t = this.getActivity().getFragmentManager().beginTransaction();
                t.replace(this.getId(), (Fragment)f);
                t.setTransition(4097);
                t.commit();
                break;
            }
            case GuestCallStateNotInitialized: {
                break;
            }
        }
    }

    private void processCallControlEvent(Intent intent) {
        Bundle bundle = intent.getExtras();
        JabberGuestCall.CallControlEvent event = (JabberGuestCall.CallControlEvent)((Object)intent.getSerializableExtra("jgsdkCallControlEventValue"));
        switch (event) {
            case audioRouteUpdated: {
                JabberGuestCall.AudioRouteType route;
                if (bundle == null || (route = (JabberGuestCall.AudioRouteType)((Object)bundle.getSerializable("AudioRoute"))) == null) break;
                this.setAudioRoute(route);
                break;
            }
        }
    }

    private void processCallErrorEvent(Intent intent) {
    }

    protected boolean onCallClick() {
        return false;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (!v.isEnabled()) {
            return;
        }
        if (id2 == R.id.jgsdk_call_button) {
            this.mPreviewView.showSpinnerOnStartCall();
            v.setEnabled(false);
            if (this.onCallClick()) {
                this.mAutoTransactionToCallFragment = false;
                return;
            }
            if (!this.hasNetworkConnectivity()) {
                Toast.makeText((Context)this.getActivity(), (int)R.string.jgsdk_network_unavailable, (int)0).show();
                return;
            }
            this.mAutoTransactionToCallFragment = true;
            if (!JabberGuestCall.getInstance().start()) {
                this.mPreviewView.mProgressBar.setVisibility(8);
                v.setEnabled(true);
            }
        }
    }

    public boolean hasNetworkConnectivity() {
        boolean ret = false;
        ConnectivityManager cm = (ConnectivityManager)this.getActivity().getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        if (netInfo != null && netInfo.isAvailable() && netInfo.isConnected()) {
            ret = true;
        }
        return ret;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        inflater.inflate(R.menu.jgsdk_preview_fragment, menu2);
        this.mAudioRouteItem = menu2.findItem(R.id.jgsdk_item_audio_output);
        this.mMuteVideoItem = menu2.findItem(R.id.jgsdk_item_videostopped);
        this.updateVideoMuteMenuIcon();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.jgsdk_item_videostopped) {
            JabberGuestCall call = JabberGuestCall.getInstance();
            boolean wasMuted = call.isVideoMuted();
            if (wasMuted) {
                call.unmuteVideo();
            } else {
                call.muteVideo();
            }
            this.updateVideoMuteMenuIcon(!wasMuted);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        TypedArray styledAttributes = this.getActivity().getTheme().obtainStyledAttributes(new int[]{16843499});
        int actionBarSize = (int)styledAttributes.getDimension(0, 0.0f);
        styledAttributes.recycle();
        RelativeLayout.LayoutParams textViewParams = new RelativeLayout.LayoutParams(-1, -2);
        textViewParams.setMargins(0, actionBarSize, 0, 0);
        this.mTextViewVideoMuted.setLayoutParams((ViewGroup.LayoutParams)textViewParams);
    }

    private void updateVideoMuteMenuIcon() {
        JabberGuestCall call = JabberGuestCall.getInstance();
        if (call == null) {
            return;
        }
        this.updateVideoMuteMenuIcon(call.isVideoMuted());
    }

    private void updateVideoMuteMenuIcon(boolean isMuted) {
        if (this.mMuteVideoItem == null) {
            return;
        }
        this.mMuteVideoItem.setIcon(isMuted ? R.drawable.jgsdk_ic_menu_videostopped_selected : R.drawable.jgsdk_ic_menu_videostopped_normal);
        this.mTextViewVideoMuted.setVisibility(isMuted ? 0 : 8);
    }
}

