/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import com.cisco.jabber.guest.BaseTextureViewLayout;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.R;

public class PreviewView
extends BaseTextureViewLayout {
    private static final int LAYOUT = R.layout.jgsdk_preview_view;
    private View mAvatar;
    public View mProgressBar;
    private boolean mFirstFrameReceived = false;
    private boolean mHideProgressBarOnFirstFrameReceived = true;

    public PreviewView(Context context) {
        super(context, LAYOUT);
        this.initAttributes(context, null, 0);
    }

    public PreviewView(Context context, AttributeSet attrs) {
        super(context, attrs, LAYOUT);
        this.initAttributes(context, attrs, 0);
    }

    public PreviewView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle, LAYOUT);
        this.initAttributes(context, attrs, defStyle);
    }

    void initAttributes(Context context, AttributeSet attrs, int defStyle) {
        this.mAvatar = this.findViewById(R.id.jgsdk_avatar);
        this.mProgressBar = this.findViewById(R.id.jgsdk_progressbar);
        this.showAvatarOrPreview();
    }

    protected void processNewInstanceAvailable(Intent intent) {
        super.processNewInstanceAvailable(intent);
        JabberGuestCall instance = this.getJabberGuestCallFromReference();
        instance.setSelfTextureView(this.getTextureView(), this);
        this.mFirstFrameReceived = false;
        this.showAvatarOrPreview();
    }

    protected void processCallControlEvent(Intent intent) {
        super.processCallControlEvent(intent);
        this.showAvatarOrPreview();
    }

    protected void processCallErrorEvent(Intent intent) {
        this.mFirstFrameReceived = false;
        this.showAvatarOrPreview();
    }

    public void onFirstFrame() {
        super.onFirstFrame();
        this.mFirstFrameReceived = true;
        this.showAvatarOrPreview();
    }

    private void showAvatarOrPreview() {
        JabberGuestCall instance = this.getJabberGuestCallFromReference();
        if (instance != null && this.mFirstFrameReceived) {
            this.mAvatar.setVisibility(8);
            if (this.mHideProgressBarOnFirstFrameReceived) {
                this.mProgressBar.setVisibility(8);
                this.mHideProgressBarOnFirstFrameReceived = true;
            }
        } else {
            this.mAvatar.setVisibility(0);
            this.mProgressBar.setVisibility(0);
        }
    }

    void showSpinnerOnStartCall() {
        this.mProgressBar.setVisibility(0);
        this.mHideProgressBarOnFirstFrameReceived = false;
    }

    protected void resetSelfTextureView() {
        JabberGuestCall instance = this.getJabberGuestCallFromReference();
        if (instance != null && this.getTextureView() != null) {
            instance.setSelfTextureView(this.getTextureView(), this);
        }
    }
}

