/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Toast;
import com.cisco.jabber.guest.BaseTextureViewLayout;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.R;

public class RemoteView
extends BaseTextureViewLayout {
    private static final int LAYOUT = R.layout.jgsdk_remote_view;
    private View mLogoView;
    private View mAvatar;
    private boolean mLogoShown;
    private Rect mFrameRegion = null;
    private boolean mFramesDropping = false;

    public RemoteView(Context context) {
        super(context, LAYOUT);
        this.initAttributes(context, null, 0);
    }

    public RemoteView(Context context, AttributeSet attrs) {
        super(context, attrs, LAYOUT);
        this.initAttributes(context, attrs, 0);
    }

    public RemoteView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle, LAYOUT);
        this.initAttributes(context, attrs, defStyle);
    }

    void initAttributes(Context context, AttributeSet attrs, int defStyle) {
        this.mLogoView = this.findViewById(R.id.jgsdk_remote_view_logo);
        this.mAvatar = this.findViewById(R.id.jgsdk_avatar);
        this.mAvatar.setVisibility(8);
    }

    protected void processNewInstanceAvailable(Intent intent) {
        super.processNewInstanceAvailable(intent);
        JabberGuestCall instance = this.getJabberGuestCallFromReference();
        if (instance == null) {
            return;
        }
        instance.setRemoteTextureView(this.getTextureView(), this);
        this.showAvatarOrTexture();
    }

    protected void processCallStateChanged(Intent intent) {
        super.processCallStateChanged(intent);
        this.showAvatarOrTexture();
    }

    protected void processCallControlEvent(Intent intent) {
        super.processCallControlEvent(intent);
        this.showAvatarOrTexture();
    }

    public boolean areFramesDropping() {
        return this.mFramesDropping;
    }

    public void onFramesDropped() {
        super.onFramesDropped();
        JabberGuestCall call = JabberGuestCall.getInstance();
        if (call != null && call.isRemoteVideoActive()) {
            this.mFramesDropping = true;
            Toast.makeText((Context)this.getContext(), (int)R.string.jgsdk_no_video_being_received, (int)0).show();
        }
        this.showAvatarOrTexture();
    }

    public void onFramesResumed() {
        super.onFramesResumed();
        this.mFramesDropping = false;
        this.showAvatarOrTexture();
    }

    public void onFrameSizeChanged(int width, int height) {
        super.onFrameSizeChanged(width, height);
        this.updateFrameRegion();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateFrameRegion();
    }

    private void showAvatarOrTexture() {
        JabberGuestCall instance = this.getJabberGuestCallFromReference();
        if (this.mFramesDropping || instance == null || instance.getState() != JabberGuestCall.State.GuestCallStateConnected || !instance.isRemoteVideoActive()) {
            this.mAvatar.setVisibility(0);
        } else {
            this.mAvatar.setVisibility(8);
        }
    }

    private void updateFrameRegion() {
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        if (viewWidth == 0 || viewHeight == 0 || this.mFrameWidth == 0 || this.mFrameHeight == 0) {
            this.mFrameRegion = null;
            return;
        }
        float scale = Math.min((float)viewWidth / (float)this.mFrameWidth, (float)viewHeight / (float)this.mFrameHeight);
        int scaledWidth = (int)((float)this.mFrameWidth * scale);
        int scaledHeight = (int)((float)this.mFrameHeight * scale);
        this.mFrameRegion = new Rect(viewWidth / 2 - scaledWidth / 2, viewHeight / 2 - scaledHeight / 2, viewWidth / 2 + scaledHeight / 2, viewHeight / 2 + scaledHeight / 2);
        this.showLogo();
    }

    private void animateLogoOut() {
        this.mLogoView.animate().alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                RemoteView.this.mLogoView.setVisibility(8);
            }
        });
    }

    private void animateLogoIn() {
        this.mLogoView.setAlpha(0.0f);
        this.mLogoView.setVisibility(0);
        this.mLogoView.animate().alpha(1.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                RemoteView.this.mLogoView.postDelayed(new Runnable(){

                    public void run() {
                        RemoteView.this.animateLogoOut();
                    }
                }, 5000L);
            }
        });
    }

    private void showLogo() {
        this.mLogoView.setX((float)this.mFrameRegion.left);
        this.mLogoView.setY((float)(this.mFrameRegion.bottom - this.mLogoView.getMeasuredHeight()));
        if (this.getVisibility() != 0 || this.mLogoView == null || this.mFrameRegion == null || this.mLogoShown) {
            return;
        }
        this.mLogoShown = true;
        this.mLogoView.postDelayed(new Runnable(){

            public void run() {
                RemoteView.this.animateLogoIn();
            }
        }, 500L);
    }
}

