/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest;

import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.cisco.jabber.guest.BaseTextureViewLayout;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.R;

public class SelfView
extends BaseTextureViewLayout
implements View.OnClickListener {
    private static final int LAYOUT = R.layout.jgsdk_self_view;
    private ImageView mSwitchCamera;
    private TextView mStoppedText;
    private boolean mCanSwitchCamera = true;
    private boolean mVideoStopped = false;
    private ProgressBar mProgBar = null;

    public SelfView(Context context) {
        super(context, LAYOUT);
        this.initAttributes(context, null, 0);
    }

    public SelfView(Context context, AttributeSet attrs) {
        super(context, attrs, LAYOUT);
        this.initAttributes(context, attrs, 0);
    }

    public SelfView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle, LAYOUT);
        this.initAttributes(context, attrs, defStyle);
    }

    void initAttributes(Context context, AttributeSet attrs, int defStyle) {
        this.setBackgroundResource(R.drawable.jgsdk_bkgd_self_view);
        this.mStoppedText = (TextView)this.findViewById(R.id.jgsdk_video_stopped_text);
        this.mSwitchCamera = (ImageView)this.findViewById(R.id.jgsdk_switch_camera);
        this.mProgBar = (ProgressBar)this.findViewById(R.id.jgsdk_selfview_progressbar);
        this.mSwitchCamera.setOnClickListener((View.OnClickListener)this);
        this.onFrameSizeChanged(174, 233);
    }

    protected void processNewInstanceAvailable(Intent intent) {
        super.processNewInstanceAvailable(intent);
        JabberGuestCall instance = this.getJabberGuestCallFromReference();
        if (instance == null) {
            return;
        }
        this.mCanSwitchCamera = instance.canSwitchCamera();
        this.updateSwitchCameraVisibility();
        this.mVideoStopped = instance.isVideoMuted();
        this.updateVideoStoppedVisibility();
        this.processCallStateChanged(intent);
    }

    protected void processCallControlEvent(Intent intent) {
        super.processCallControlEvent(intent);
        JabberGuestCall.CallControlEvent event = (JabberGuestCall.CallControlEvent)((Object)intent.getSerializableExtra("jgsdkCallControlEventValue"));
        switch (event) {
            case audioMuted: 
            case audioUnmuted: 
            case videoMuted: 
            case videoUnmuted: {
                JabberGuestCall instance = this.getJabberGuestCallFromReference();
                if (instance == null) break;
                this.mVideoStopped = instance.isVideoMuted();
                this.updateVideoStoppedVisibility();
                break;
            }
            case cameraSwitched: {
                this.setSwitchingCameras(false);
                break;
            }
            case dtmfSent: 
            case streamsUpdated: 
            case audioRouteUpdated: {
                break;
            }
        }
    }

    protected void processCallStateChanged(Intent intent) {
        super.processCallStateChanged(intent);
        JabberGuestCall instance = this.getJabberGuestCallFromReference();
        if (instance == null) {
            return;
        }
        JabberGuestCall.State state = instance.getState();
        if (state == JabberGuestCall.State.GuestCallStateConnecting || state == JabberGuestCall.State.GuestCallStateConnected) {
            instance.setSelfTextureView(this.getTextureView(), this);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.jgsdk_switch_camera) {
            if (!this.mCanSwitchCamera) {
                return;
            }
            v.setSelected(!v.isSelected());
            if (JabberGuestCall.getInstance() != null) {
                this.setSwitchingCameras(true);
                JabberGuestCall.getInstance().switchCamera();
            }
        }
    }

    public void updateVideoStoppedVisibility() {
        if (this.mStoppedText != null) {
            this.mStoppedText.setVisibility(this.mVideoStopped ? 0 : 4);
        }
    }

    public void updateSwitchCameraVisibility() {
        this.mSwitchCamera.setVisibility(this.mCanSwitchCamera ? 0 : 8);
    }

    private void setSwitchingCameras(boolean switching) {
        if (this.mCanSwitchCamera) {
            this.mSwitchCamera.setEnabled(!switching);
            this.mSwitchCamera.setVisibility(switching ? 4 : 0);
        }
        if (this.mProgBar != null) {
            this.mProgBar.setVisibility(switching ? 0 : 8);
        }
    }

    public void onFrameSizeChanged(int width, int height) {
        super.onFrameSizeChanged(width, height);
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureTextureView();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int maxWidth = this.getMeasuredMaxWidth();
        int maxHeight = this.getMeasuredMaxHeight();
        if (widthMode != 0x40000000 && widthSize > maxWidth) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)maxWidth, (int)Integer.MIN_VALUE);
        }
        if (heightMode != 0x40000000 && heightSize > maxHeight) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)maxHeight, (int)Integer.MIN_VALUE);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void measureTextureView() {
        int unspecified = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.mSwitchCamera.measure(unspecified, unspecified);
        FrameLayout.LayoutParams textureLayoutParams = (FrameLayout.LayoutParams)this.getTextureView().getLayoutParams();
        textureLayoutParams.bottomMargin = this.mSwitchCamera.getMeasuredHeight();
        ViewGroup.LayoutParams params = this.getLayoutParams();
        int maxWidth = this.mMaxWidth - this.getPaddingLeft() - this.getPaddingRight() - textureLayoutParams.rightMargin - textureLayoutParams.leftMargin;
        int maxHeight = this.mMaxHeight - this.getPaddingTop() - this.getPaddingBottom() - textureLayoutParams.topMargin - textureLayoutParams.bottomMargin;
        if (params.width == -2 || params.height == -2) {
            float scale;
            int newWidth = this.mFrameWidth;
            int newHeight = this.mFrameHeight;
            int minWidth = this.getSuggestedMinimumWidth();
            int minHeight = this.getSuggestedMinimumHeight();
            if (newWidth < minWidth) {
                scale = (float)minWidth / (float)newWidth;
                newWidth = (int)((float)newWidth * scale);
                newHeight = (int)((float)newHeight * scale);
            }
            if (newHeight < minHeight) {
                scale = (float)minHeight / (float)newHeight;
                newWidth = (int)((float)newWidth * scale);
                newHeight = (int)((float)newHeight * scale);
            }
            if (newWidth > maxWidth) {
                scale = (float)maxWidth / (float)newWidth;
                newWidth = (int)((float)newWidth * scale);
                newHeight = (int)((float)newHeight * scale);
            }
            if (newHeight > maxHeight) {
                scale = (float)maxHeight / (float)newHeight;
                newWidth = (int)((float)newWidth * scale);
                newHeight = (int)((float)newHeight * scale);
            }
            textureLayoutParams.width = newWidth;
            textureLayoutParams.height = newHeight;
        }
    }

    private int getMeasuredMaxWidth() {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.getTextureView().getLayoutParams();
        return lp.width + lp.leftMargin + lp.rightMargin + this.getPaddingLeft() + this.getPaddingRight();
    }

    private int getMeasuredMaxHeight() {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.getTextureView().getLayoutParams();
        return lp.height + lp.topMargin + lp.bottomMargin + this.getPaddingTop() + this.getPaddingBottom();
    }
}

