/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest.jcf;

import android.net.http.SslError;
import android.util.Base64;
import com.cisco.jabber.guest.util.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.StrictHostnameVerifier;

class CertValidation {
    public static final int VALID = 0;
    public static final int INVALID = 1;
    private static final String TAG = "CertValidation";

    CertValidation() {
    }

    public static int verifyCertificate(String[] pemCertChain, String domain) {
        ArrayList<byte[]> derCertChain = new ArrayList<byte[]>();
        for (String cert : pemCertChain) {
            byte[] decoded = Base64.decode((String)cert.replaceAll("-----BEGIN CERTIFICATE-----", "").replaceAll("-----END CERTIFICATE-----", ""), (int)0);
            derCertChain.add(decoded);
        }
        return CertValidation.verifyCertificate((byte[][])derCertChain.toArray((T[])new byte[0][]), domain);
    }

    public static int verifyCertificate(byte[][] certChain, String domain) {
        Log.d(TAG, "leng:" + certChain.length);
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        CertificateFactory factory = null;
        try {
            factory = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < certChain.length; ++i) {
                if (certChain[i] == null) continue;
                ByteArrayInputStream stream = new ByteArrayInputStream(certChain[i]);
                certificateList.add((X509Certificate)factory.generateCertificate(stream));
                stream.close();
            }
        }
        catch (CertificateException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            new StrictHostnameVerifier().verify(domain, (X509Certificate)certificateList.get(0));
        }
        catch (Exception e) {
            Log.w(TAG, "Certificate hostname mismatch. " + domain + " not in cert names", e);
            return 1;
        }
        SslError error = CertValidation.verifyCertificates(certificateList.toArray(new X509Certificate[certificateList.size()]), domain, "RSA");
        if (error == null) {
            Log.d(TAG, "trust");
            return 0;
        }
        Log.d(TAG, "untrust");
        return 1;
    }

    private static SslError verifyCertificates(X509Certificate[] chain, String domain, String authType) {
        try {
            CertValidation.createDefaultTrustManager().checkServerTrusted(chain, authType);
            return null;
        }
        catch (CertificateException e) {
            return new SslError(3, chain[0]);
        }
    }

    private static X509TrustManager createDefaultTrustManager() {
        try {
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init((KeyStore)null);
            TrustManager[] tms = tmf.getTrustManagers();
            X509TrustManager trustManager = CertValidation.findX509TrustManager(tms);
            return trustManager;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    private static X509TrustManager findX509TrustManager(TrustManager[] tms) {
        for (TrustManager tm : tms) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        return null;
    }
}

