/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest.jcf;

import android.os.Handler;
import com.cisco.jabber.guest.util.Log;
import com.cisco.jabber.jcf.ServiceFactory;
import java.util.concurrent.Semaphore;

public class JcfDispatcher
implements Runnable {
    private static Thread mThread = null;
    private final Handler mDispatcherHandler;
    private final Semaphore mDispatchSemaphore = new Semaphore(1);
    private final Runnable mDispatchRunnable = new Runnable(){

        public void run() {
            Log.d("JabberGuestSDK", "JCF: pumping task.");
            ServiceFactory.getInstance().pumpAllDispatcherTasks();
            JcfDispatcher.this.mDispatchSemaphore.release();
        }
    };

    public static Thread startAsThread() {
        if (mThread != null && mThread.isAlive()) {
            return mThread;
        }
        mThread = new Thread(new JcfDispatcher());
        mThread.start();
        return mThread;
    }

    public JcfDispatcher() {
        this.mDispatcherHandler = new Handler();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.mDispatchSemaphore.acquire();
                    Log.d("JabberGuestSDK", "JCF: waiting for task.");
                    ServiceFactory.getInstance().waitForDispatcherTask();
                    this.mDispatcherHandler.post(this.mDispatchRunnable);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

