/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest.jcf;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.R;
import com.cisco.jabber.guest.RenderCallbacks;
import com.cisco.jabber.guest.api.CSFLogHelper;
import com.cisco.jabber.guest.api.RenderSink;
import com.cisco.jabber.guest.jcf.BaseJGCallObserver;
import com.cisco.jabber.guest.jcf.CertValidation;
import com.cisco.jabber.guest.jcf.JcfDispatcher;
import com.cisco.jabber.guest.jcf.RenderCallbackMapper;
import com.cisco.jabber.guest.util.Log;
import com.cisco.jabber.jcf.AcceptInvalidCertOption;
import com.cisco.jabber.jcf.InvalidCertReason;
import com.cisco.jabber.jcf.InvalidCertificateCallback;
import com.cisco.jabber.jcf.InvalidCertificateCallbackResponse;
import com.cisco.jabber.jcf.InvalidCertificateHandler;
import com.cisco.jabber.jcf.JGAudioStatistics;
import com.cisco.jabber.jcf.JGCall;
import com.cisco.jabber.jcf.JGCallObserver;
import com.cisco.jabber.jcf.JGCodecStatistics;
import com.cisco.jabber.jcf.JGMuteState;
import com.cisco.jabber.jcf.JGNetworkStatus;
import com.cisco.jabber.jcf.JGOrientation;
import com.cisco.jabber.jcf.JGRenderSink;
import com.cisco.jabber.jcf.JGVideoLayout;
import com.cisco.jabber.jcf.JGVideoStatistics;
import com.cisco.jabber.jcf.JabberCRestErrorCategory;
import com.cisco.jabber.jcf.JabberCRestWaitError;
import com.cisco.jabber.jcf.JabberCRestWaitEvent;
import com.cisco.jabber.jcf.ServiceFactory;
import com.cisco.jabber.jcf.SystemService;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class JcfJabberGuestCall
extends JabberGuestCall {
    private static final String SHARED_PREFS_FILE = "JcfJabberGuestCall";
    private static final boolean ATTACH_DEBUGGER = false;
    private static final JGVideoLayout RENDER_SINK_LAYOUT = JGVideoLayout.I420;
    private final RenderSink mRemoteRenderSink = new RenderSink();
    private final RenderSink mSelfRenderSink = new RenderSink();
    private static InvalidCertificateCallbackResponse mJCFInvalidCertCallbackResponse = null;
    private String mServer;
    private SharedPreferences mSharedPrefs;
    private Context mApplicationContext;
    private static Context mRecentActiveViewContext = null;
    private NetworkReceiver mNetworkReceiver;
    private NetworkState mNetworkState;
    private InvalidCertificateHandler mJCFInvalidCertHandler;
    private boolean mInvalidCertDlgOnScreen = false;
    private boolean mVideoLicenseDelayed = false;
    private boolean mVideoLicenseDlgOnScreen = false;
    private InvalidCertificateCallback mJCFInvalidCertCallback = new InvalidCertificateCallback(){

        public void OnInvalidCert(String certFingerprint, String identifierToDisplay, String certSubjectCN, String referenceID, List<InvalidCertReason> invalidReason, String subjectCertificateData, List<String> intermediateCACertificateData, boolean allowUserToAccept, InvalidCertificateCallbackResponse InvalidCertificateCallbackResponse2) {
            mJCFInvalidCertCallbackResponse = InvalidCertificateCallbackResponse2;
            JcfJabberGuestCall.this.mInvalidCertDlgOnScreen = true;
            if (CertValidation.verifyCertificate(intermediateCACertificateData.toArray(new String[0]), referenceID) == 0) {
                JcfJabberGuestCall.this.acceptInvalidCertificate(referenceID, subjectCertificateData);
                return;
            }
            Log.i("JabberGuestSDK", "Invalid Cert: " + referenceID + " ; " + certSubjectCN);
            if (JcfJabberGuestCall.this.mSharedPrefs.getString(referenceID, "").equals(subjectCertificateData)) {
                JcfJabberGuestCall.this.acceptInvalidCertificate(referenceID, subjectCertificateData);
            } else if (mJGSDKInvalidCertCallback != null) {
                LinkedList<String> strInvalidReason = new LinkedList<String>();
                for (InvalidCertReason reason : invalidReason) {
                    strInvalidReason.add(reason.name());
                }
                mJGSDKInvalidCertCallback.onInvalidCertificate(certFingerprint, identifierToDisplay, certSubjectCN, referenceID, strInvalidReason, subjectCertificateData, intermediateCACertificateData, allowUserToAccept);
                if (!allowUserToAccept) {
                    JcfJabberGuestCall.this.rejectInvalidCertificate();
                }
            } else {
                JcfJabberGuestCall.this.rejectInvalidCertificate();
            }
        }
    };
    private final JGCall mService;
    private final JGCallObserver mObserver = new BaseJGCallObserver(){

        @Override
        public void OnEventChanged(List<JabberCRestWaitEvent> added, List<JabberCRestWaitEvent> removed) {
            JabberCRestWaitEvent event = added.get(0);
            Log.d("JabberGuestSDK", String.format("OnEventChanged: %s", event.getEvent()));
            if (event.getEvent().compareTo("error") == 0 || event.getEvent().compareTo("bye") == 0) {
                JabberCRestWaitError error = event.getError();
                int code = error.getCode();
                String message = error.getMessage();
                long categoryvalue = 0L;
                int messageresourceid = R.string.jgsdk_call_server_no_response;
                JabberCRestErrorCategory category = error.getCategory();
                if (category != null) {
                    switch (category) {
                        case UNKNOWN_ERROR: {
                            messageresourceid = R.string.jgsdk_error_unknown;
                            categoryvalue = category.getCValue();
                            break;
                        }
                        case NET_ERROR: 
                        case HTTP_ERROR: {
                            messageresourceid = R.string.jgsdk_error_networking;
                            categoryvalue = category.getCValue();
                            break;
                        }
                        case MEDIAGATEWAY_ICE_FAILED: {
                            messageresourceid = R.string.jgsdk_error_networking_between_device;
                            categoryvalue = category.getCValue();
                            break;
                        }
                        case BLANK_SDP: 
                        case SIP_ERROR: 
                        case ROAP_EXCEPTION: 
                        case MEDIAGATEWAY_UNDEFINED: 
                        case SIP_CONFIGURATION_ERROR: {
                            messageresourceid = R.string.jgsdk_error_server;
                            categoryvalue = category.getCValue();
                            break;
                        }
                        case BLANK_SIP_URI: 
                        case INVALID_SIP_URI: {
                            messageresourceid = R.string.jgsdk_error_link_invalid;
                            categoryvalue = category.getCValue();
                            break;
                        }
                        case LINK_NOT_FOUND_ERROR: {
                            messageresourceid = R.string.jgsdk_error_link_not_found;
                            categoryvalue = category.getCValue();
                            break;
                        }
                        case MEDIAGATEWAY_ALLOCATION_FAILED: {
                            messageresourceid = R.string.jgsdk_error_server_busy;
                            categoryvalue = category.getCValue();
                            break;
                        }
                        case SIP_ENDPOINT_BUSY: {
                            messageresourceid = R.string.jgsdk_error_destination_busy;
                            categoryvalue = category.getCValue();
                            break;
                        }
                        case LINK_NOT_VALID_YET_ERROR: {
                            messageresourceid = R.string.jgsdk_error_link_not_active;
                            categoryvalue = category.getCValue();
                            break;
                        }
                        case LINK_EXPIRED_ERROR: {
                            messageresourceid = R.string.jgsdk_error_link_expired;
                            categoryvalue = category.getCValue();
                            break;
                        }
                        case LINK_DISABLED_ERROR: {
                            messageresourceid = R.string.jgsdk_error_link_disabled;
                            categoryvalue = category.getCValue();
                            break;
                        }
                        case INVALID_CALL_STATE: {
                            messageresourceid = R.string.jgsdk_error_invalid_call_state;
                            categoryvalue = category.getCValue();
                            break;
                        }
                        case TURN_CRED_ACQUIRE_FAILED: {
                            messageresourceid = R.string.jgsdk_error_turn_cred_acquire_failed;
                            categoryvalue = category.getCValue();
                            break;
                        }
                        case INVALID_API_VERSION_ERROR: 
                        case UNSUPPORTED_API_VERSION_ERROR: {
                            messageresourceid = R.string.jgsdk_error_server_api_version_failed;
                            categoryvalue = category.getCValue();
                            break;
                        }
                    }
                }
                int titleresourceid = -1;
                titleresourceid = JcfJabberGuestCall.this.mState == JabberGuestCall.State.GuestCallStateDisconnected || JcfJabberGuestCall.this.mState == JabberGuestCall.State.GuestCallStateConnecting ? R.string.jgsdk_call_not_completed : R.string.jgsdk_call_dropped;
                Bundle errorBundle = new Bundle();
                errorBundle.putLong("category", categoryvalue);
                errorBundle.putInt("userTitle", titleresourceid);
                errorBundle.putInt("code", code);
                errorBundle.putString("message", message);
                errorBundle.putInt("userMessage", messageresourceid);
                errorBundle.putSerializable("jgsdkCallStateValue", (Serializable)((Object)JcfJabberGuestCall.this.mState));
                JcfJabberGuestCall.this.publishCallErrorEvent(errorBundle);
            }
        }

        @Override
        public void OnCallStateChanged() {
            Log.d("JabberGuestSDK", String.format("OnCallStateChanged: %s", JcfJabberGuestCall.this.mService.getCallState().toString()));
            switch (JcfJabberGuestCall.this.mService.getCallState()) {
                case Allocated: 
                case Allocating: 
                case Initializing: {
                    break;
                }
                case Connected: {
                    JcfJabberGuestCall.this.setState(JabberGuestCall.State.GuestCallStateConnected);
                    JcfJabberGuestCall.this.mService.setRemoteRenderSink((JGRenderSink)JcfJabberGuestCall.this.mRemoteRenderSink, RENDER_SINK_LAYOUT);
                    break;
                }
                case Connecting: {
                    JcfJabberGuestCall.this.setState(JabberGuestCall.State.GuestCallStateConnecting);
                    break;
                }
                case Disconnected: {
                    JcfJabberGuestCall.this.setState(JabberGuestCall.State.GuestCallStateDisconnected);
                    break;
                }
                case Disconnecting: {
                    JcfJabberGuestCall.this.setState(JabberGuestCall.State.GuestCallStateDisconnecting);
                    JcfJabberGuestCall.this.mService.stopSelfView();
                    break;
                }
                case NotInitialized: {
                    JcfJabberGuestCall.this.setState(JabberGuestCall.State.GuestCallStateNotInitialized);
                    break;
                }
            }
        }

        @Override
        public void OnSentDTMFChanged() {
            String sentDTMF = JcfJabberGuestCall.this.mService.getSentDTMF();
            for (char digit : sentDTMF.toCharArray()) {
                JcfJabberGuestCall.this.publishCallControlEvent(JabberGuestCall.CallControlEvent.dtmfSent, "dtmf-sent", String.valueOf(digit));
                JcfJabberGuestCall.this.playKeyPadSound(digit);
            }
        }

        @Override
        public void OnAudioOutMuteStateChanged() {
            JGMuteState state = JcfJabberGuestCall.this.mService.getAudioOutMuteState();
            if (state == JGMuteState.Muted) {
                JcfJabberGuestCall.this.publishCallControlEvent(JabberGuestCall.CallControlEvent.audioMuted);
            } else if (state == JGMuteState.Unmuted) {
                JcfJabberGuestCall.this.publishCallControlEvent(JabberGuestCall.CallControlEvent.audioUnmuted);
            }
        }

        @Override
        public void OnVideoOutMuteStateChanged() {
            JGMuteState state = JcfJabberGuestCall.this.mService.getVideoOutMuteState();
            if (state == JGMuteState.Muted) {
                JcfJabberGuestCall.this.publishCallControlEvent(JabberGuestCall.CallControlEvent.videoMuted);
            } else if (state == JGMuteState.Unmuted) {
                JcfJabberGuestCall.this.publishCallControlEvent(JabberGuestCall.CallControlEvent.videoUnmuted);
            }
        }

        @Override
        public void OnCameraSwitchedChanged() {
            JcfJabberGuestCall.this.publishCallControlEvent(JabberGuestCall.CallControlEvent.cameraSwitched);
        }

        @Override
        public void OnVideoInMuteStateChanged() {
            super.OnVideoInMuteStateChanged();
            JcfJabberGuestCall.this.publishCallControlEvent(JabberGuestCall.CallControlEvent.streamsUpdated);
            JcfJabberGuestCall.this.mService.setRemoteRenderSink((JGRenderSink)JcfJabberGuestCall.this.mRemoteRenderSink, RENDER_SINK_LAYOUT);
        }

        @Override
        public void OnVideoLicenseActivatedChanged() {
            if (JcfJabberGuestCall.this.mService.getVideoLicenseActivated()) {
                Context context = JcfJabberGuestCall.this.mApplicationContext == null ? mRecentActiveViewContext : JcfJabberGuestCall.this.mApplicationContext;
                JabberGuestCall.disableVideoLicenseActivation(context);
                if (JcfJabberGuestCall.this.mVideoLicenseDlgFragment != null) {
                    JcfJabberGuestCall.this.mVideoLicenseDlgFragment.dismiss();
                }
                JcfJabberGuestCall.this.start();
            }
        }
    };
    protected VideoLicenseActivateDialog mVideoLicenseDlgFragment = null;
    private Object lockVideoLicenseDlgOnScreen = new Object();
    private Object lockVideoLicenseDelayed = new Object();

    public static JcfJabberGuestCall createInstance(Context context, Uri toUri) {
        return new JcfJabberGuestCall(context, toUri);
    }

    private static void attachGdbServer(Context context) {
        try {
            new ProcessBuilder(new String[0]).command(context.getFilesDir().getParent() + "/lib/gdbserver", "tcp:5039", "--attach", "" + Process.myPid()).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            Log.e("JabberGuestSDK", "IOException failed to start gdbserver");
        }
    }

    protected void finish() {
        super.finish();
        if (this.mJCFInvalidCertHandler != null) {
            this.mJCFInvalidCertHandler.ClearInvalidCertificateCache();
        }
        if (this.mService != null && this.mObserver != null) {
            this.mService.removeObserver(this.mObserver);
        }
        if (this.mJCFInvalidCertHandler != null && this.mJCFInvalidCertCallback != null) {
            this.mJCFInvalidCertHandler.UnRegisterInvalidCertificateCallback(this.mJCFInvalidCertCallback);
        }
    }

    public void registerContext(Context context) {
        if (context == null) {
            Log.w("JabberGuestSDK", "registerContext with a null");
        }
        mRecentActiveViewContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createVideoLicenseDlg() {
        Object object = this.lockVideoLicenseDlgOnScreen;
        synchronized (object) {
            if (this.mVideoLicenseDlgOnScreen) {
                Log.w("JabberGuestSDK", "Skip creating a new Video license dialog, already one on screen");
                return;
            }
        }
        if (mRecentActiveViewContext == null) {
            Log.e("JabberGuestSDK", "Failed to display Video License activation dialog. Context not registered!");
            return;
        }
        this.mVideoLicenseDlgFragment = new VideoLicenseActivateDialog();
        this.mVideoLicenseDlgFragment.show(((Activity)mRecentActiveViewContext).getFragmentManager(), "videoLicenseDialog");
        object = this.lockVideoLicenseDlgOnScreen;
        synchronized (object) {
            this.mVideoLicenseDlgOnScreen = true;
        }
    }

    private JcfJabberGuestCall(Context context, Uri toUri) {
        super(context, toUri);
        this.ensureMainThread();
        this.mApplicationContext = context.getApplicationContext();
        this.setJcfLogLevel(Log.getLogLevel());
        this.mNetworkReceiver = new NetworkReceiver();
        this.mApplicationContext.registerReceiver((BroadcastReceiver)this.mNetworkReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        RenderSink.setenv((String)this.mApplicationContext.getCacheDir().getAbsolutePath());
        this.mHandler = new Handler();
        JabberGuestCall instance = JabberGuestCall.getInstance();
        if (instance != null && instance instanceof JcfJabberGuestCall) {
            ((JcfJabberGuestCall)instance).finish();
        }
        this.mService = (JGCall)ServiceFactory.getInstance().getService(100001L);
        SystemService systemService = (SystemService)ServiceFactory.getInstance().getService(1000L);
        this.mJCFInvalidCertHandler = systemService.getInvalidCertificateHandler();
        this.mJCFInvalidCertHandler.RegisterInvalidCertificateCallback(this.mJCFInvalidCertCallback);
        this.mJCFInvalidCertHandler.ClearInvalidCertificateCache();
        this.mService.addObserver(this.mObserver);
        this.mServer = toUri.getAuthority();
        JcfDispatcher.startAsThread();
        this.mService.setToAddress(this.mAddress);
        this.mService.setServerName(this.mServer);
        this.mService.setClientType("android");
        this.mService.setClientId(this.getDeviceId(this.mApplicationContext));
        this.mSharedPrefs = this.mApplicationContext.getSharedPreferences(SHARED_PREFS_FILE, 0);
        this.mService.setSelfRenderSink((JGRenderSink)this.mSelfRenderSink, RENDER_SINK_LAYOUT);
        this.updateCurrentNetworkState();
    }

    private String getDeviceId(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getDeviceId();
    }

    private void ensureMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("Must be called from main thread");
        }
    }

    public boolean canSwitchCamera() {
        this.ensureMainThread();
        return this.mService.getCanSwitchCamera();
    }

    public void switchCamera() {
        this.ensureMainThread();
        this.mService.switchCamera();
    }

    public boolean isFrontCamera() {
        this.ensureMainThread();
        return this.mService.getIsFrontCamera();
    }

    public void preview() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        this.ensureMainThread();
        if (JabberGuestCall.checkActivation(this.mApplicationContext != null ? this.mApplicationContext : mRecentActiveViewContext)) {
            if (!this.mInvalidCertDlgOnScreen) {
                this.createVideoLicenseDlg();
            } else {
                Object object = this.lockVideoLicenseDelayed;
                synchronized (object) {
                    this.mVideoLicenseDelayed = true;
                }
            }
            return false;
        }
        this.mService.startCall();
        return true;
    }

    public void end() {
        this.ensureMainThread();
        if (this.mState == JabberGuestCall.State.GuestCallStateConnecting || this.mState == JabberGuestCall.State.GuestCallStateConnected) {
            this.mService.endCall();
        } else if (this.mState != JabberGuestCall.State.GuestCallStateDisconnecting) {
            this.mService.stopSelfView();
            this.setState(JabberGuestCall.State.GuestCallStateDisconnected);
        }
        if (this.mApplicationContext != null && this.mNetworkReceiver != null) {
            this.mApplicationContext.unregisterReceiver((BroadcastReceiver)this.mNetworkReceiver);
            this.mApplicationContext = null;
            this.mNetworkReceiver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelfTextureView(TextureView textureView, RenderCallbacks callbacks) {
        this.ensureMainThread();
        this.mSelfRenderSink.setTextureView(textureView);
        this.mSelfRenderSink.setRenderSinkListener(this.mHandler, (RenderSink.RenderSinkListener)new RenderCallbackMapper(callbacks));
        this.mService.setSelfRenderSink((JGRenderSink)this.mSelfRenderSink, RENDER_SINK_LAYOUT);
        if (JabberGuestCall.checkActivation(this.mApplicationContext != null ? this.mApplicationContext : mRecentActiveViewContext)) {
            if (!this.mInvalidCertDlgOnScreen) {
                this.createVideoLicenseDlg();
            } else {
                Object object = this.lockVideoLicenseDelayed;
                synchronized (object) {
                    this.mVideoLicenseDelayed = true;
                }
            }
        } else {
            this.mService.startSelfView();
        }
    }

    public void setRemoteTextureView(TextureView textureView, RenderCallbacks callbacks) {
        this.ensureMainThread();
        this.mRemoteRenderSink.setTextureView(textureView);
        this.mRemoteRenderSink.setRenderSinkListener(this.mHandler, (RenderSink.RenderSinkListener)new RenderCallbackMapper(callbacks));
        this.mService.setRemoteRenderSink((JGRenderSink)this.mRemoteRenderSink, RENDER_SINK_LAYOUT);
    }

    public boolean isLocalVideoActive() {
        this.ensureMainThread();
        return this.mService.getSelfVideoActive();
    }

    public boolean isRemoteVideoActive() {
        this.ensureMainThread();
        return this.mState == JabberGuestCall.State.GuestCallStateConnected && this.mService.getVideoInUnmuted();
    }

    public boolean isVideoMuted() {
        this.ensureMainThread();
        return this.mService.getVideoOutMuted();
    }

    public void muteVideo() {
        this.ensureMainThread();
        this.mService.muteVideoOut(true);
    }

    public void unmuteVideo() {
        this.ensureMainThread();
        this.mService.muteVideoOut(false);
    }

    public boolean isAudioMuted() {
        this.ensureMainThread();
        return this.mService.getAudioOutMuted();
    }

    public void muteAudio() {
        this.ensureMainThread();
        this.mService.muteAudioOut(true);
    }

    public void unmuteAudio() {
        this.ensureMainThread();
        this.mService.muteAudioOut(false);
    }

    public void sendDigits(String digits) {
        this.ensureMainThread();
        this.mService.sendDTMF(digits);
    }

    protected void onRotationChanged(int rotation) {
        this.ensureMainThread();
        JGOrientation orientation = JGOrientation.Unknown;
        if (rotation == 0) {
            orientation = JGOrientation.Up;
        } else if (rotation == 1) {
            orientation = JGOrientation.Left;
        } else if (rotation == 2) {
            orientation = JGOrientation.Down;
        } else if (rotation == 3) {
            orientation = JGOrientation.Right;
        }
        Log.d("JabberGuestSDK", "onRotationChanged: " + orientation.toString());
        this.mService.setOrientation(orientation);
    }

    protected void setSessionStatistics(JabberGuestCall.CallStatistics statsStruct) {
        JGVideoStatistics videoStats;
        Log.d("JabberGuestSDK", "setSessionStatistics");
        JGAudioStatistics audioStats = this.mService.getAudioStatistics();
        if (audioStats != null) {
            JGCodecStatistics audioReceiveCodec = audioStats.getReceiveCodec();
            if (audioReceiveCodec != null) {
                statsStruct.audioReceiveCodecName = audioReceiveCodec.getName();
                statsStruct.audioReceiveCodecType = audioReceiveCodec.getType();
                statsStruct.audioReceiveCodecPayloadType = audioReceiveCodec.getPayloadType();
                statsStruct.audioReceiveCodecClockRate = audioReceiveCodec.getClockRate();
            }
            statsStruct.audioReceivePacketsReceived = audioStats.getReceivedPackets();
            statsStruct.audioReceivePacketsLost = audioStats.getReceivePacketsLost();
            statsStruct.audioReceivePercentLost = audioStats.getReceivePercentLost();
            statsStruct.audioReceiveCumPercentLost = audioStats.getReceiveCumPercentLost();
            statsStruct.audioReceiveBitrate = audioStats.getReceiveBitrate();
            statsStruct.audioReceiveJitter = audioStats.getReceiveJitter();
            JGCodecStatistics audioTransmitCodec = audioStats.getTransmitCodec();
            if (audioTransmitCodec != null) {
                statsStruct.audioTransmitCodecName = audioTransmitCodec.getName();
                statsStruct.audioTransmitCodecType = audioTransmitCodec.getType();
                statsStruct.audioTransmitCodecPayloadType = audioTransmitCodec.getPayloadType();
                statsStruct.audioTransmitCodecClockRate = audioTransmitCodec.getClockRate();
            }
            statsStruct.audioTransmitSentPackets = audioStats.getSentPackets();
            statsStruct.audioTransmitPacketsReceived = audioStats.getTransmitPacketsReceived();
            statsStruct.audioTransmitPacketsLost = audioStats.getTransmitPacketsLost();
            statsStruct.audioTransmitPercentLost = audioStats.getTransmitPercentLost();
            statsStruct.audioTransmitCumPercentLost = audioStats.getTransmitCumPercentLost();
            statsStruct.audioTransmitBitrate = audioStats.getTransmitBitrate();
            statsStruct.audioTransmitJitter = audioStats.getTransmitJitter();
            statsStruct.audioTransmitRoundTrip = audioStats.getTransmitRoundTrip();
        }
        if ((videoStats = this.mService.getVideoStatistics()) != null) {
            JGCodecStatistics videoReceiveCodec = videoStats.getReceiveCodec();
            if (videoReceiveCodec != null) {
                statsStruct.videoReceiveCodecName = videoReceiveCodec.getName();
                statsStruct.videoReceiveCodecType = videoReceiveCodec.getType();
                statsStruct.videoReceiveCodecPayloadType = videoReceiveCodec.getPayloadType();
                statsStruct.videoReceiveCodecClockRate = videoReceiveCodec.getClockRate();
            }
            statsStruct.videoReceivePacketsReceived = videoStats.getReceivedPackets();
            statsStruct.videoReceivePacketsLost = videoStats.getReceivePacketsLost();
            statsStruct.videoReceivePercentLost = videoStats.getReceivePercentLost();
            statsStruct.videoReceiveCumPercentLost = videoStats.getReceiveCumPercentLost();
            statsStruct.videoReceiveBitrate = videoStats.getReceiveBitrate();
            statsStruct.videoReceiveJitter = videoStats.getReceiveJitter();
            statsStruct.videoReceiveFramesPerSecond = videoStats.getReceivedFramesPerSecond();
            statsStruct.videoReceiveFrameHeight = videoStats.getReceiveFrameHeight();
            statsStruct.videoReceiveFrameWidth = videoStats.getReceiveFrameWidth();
            JGCodecStatistics videoTransmitCodec = videoStats.getTransmitCodec();
            if (videoTransmitCodec != null) {
                statsStruct.videoTransmitCodecName = videoTransmitCodec.getName();
                statsStruct.videoTransmitCodecType = videoTransmitCodec.getType();
                statsStruct.videoTransmitCodecPayloadType = videoTransmitCodec.getPayloadType();
                statsStruct.videoTransmitCodecClockRate = videoTransmitCodec.getClockRate();
            }
            statsStruct.videoTransmitSentPackets = videoStats.getSentPackets();
            statsStruct.videoTransmitPacketsReceived = videoStats.getTransmitPacketsReceived();
            statsStruct.videoTransmitPacketsLost = videoStats.getTransmitPacketsLost();
            statsStruct.videoTransmitPercentLost = videoStats.getTransmitPercentLost();
            statsStruct.videoTransmitCumPercentLost = videoStats.getTransmitCumPercentLost();
            statsStruct.videoTransmitBitrate = videoStats.getTransmitBitrate();
            statsStruct.videoTransmitJitter = videoStats.getTransmitJitter();
            statsStruct.videoTransmitRoundTrip = videoStats.getTransmitRoundTrip();
            statsStruct.videoTransmitFramesPerSecond = videoStats.getTransmittedFramesPerSecond();
            statsStruct.videoTransmitFrameHeight = videoStats.getTransmitFrameHeight();
            statsStruct.videoTransmitFrameWidth = videoStats.getTransmitFrameWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptInvalidCertificate(String referenceID, String subjectCertificateData) {
        this.ensureMainThread();
        this.mInvalidCertDlgOnScreen = false;
        if (mJCFInvalidCertCallbackResponse != null) {
            LinkedList<AcceptInvalidCertOption> acceptOptions = new LinkedList<AcceptInvalidCertOption>();
            acceptOptions.add(AcceptInvalidCertOption.ACCEPT_FOR_SESSION);
            mJCFInvalidCertCallbackResponse.AcceptInvalidCert(acceptOptions);
            mJCFInvalidCertCallbackResponse = null;
            if (!TextUtils.isEmpty((CharSequence)referenceID) && !TextUtils.isEmpty((CharSequence)subjectCertificateData)) {
                this.mSharedPrefs.edit().putString(referenceID, subjectCertificateData).commit();
            }
        }
        Object object = this.lockVideoLicenseDelayed;
        synchronized (object) {
            if (this.mVideoLicenseDelayed) {
                this.createVideoLicenseDlg();
                this.mVideoLicenseDelayed = false;
            }
        }
    }

    public synchronized void rejectInvalidCertificate() {
        this.ensureMainThread();
        this.mInvalidCertDlgOnScreen = false;
        if (mJCFInvalidCertCallbackResponse != null) {
            Log.e("JabberGuestSDK", "Call failed, certificate is invalid.");
            mJCFInvalidCertCallbackResponse.RejectInvalidCert();
            this.mJCFInvalidCertHandler.ClearInvalidCertificateCache();
            mJCFInvalidCertCallbackResponse = null;
            this.end();
            this.finish();
        }
    }

    private void updateCurrentNetworkState() {
        NetworkState newState;
        ConnectivityManager conn = (ConnectivityManager)this.mApplicationContext.getSystemService("connectivity");
        NetworkInfo networkInfo = conn.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.getType() == 1 && networkInfo.isConnected()) {
            newState = NetworkState.WifiConnected;
            Log.d("JabberGuestSDK", "Current connected network - wifi");
        } else if (networkInfo != null && networkInfo.getType() == 0 && networkInfo.isConnected()) {
            newState = NetworkState.MobileConnected;
            Log.d("JabberGuestSDK", "Current connected network - mobile");
        } else {
            newState = NetworkState.Disconnected;
            Log.d("JabberGuestSDK", "Current connected network - none");
        }
        if (this.mNetworkState == null || newState != this.mNetworkState) {
            switch (newState) {
                case WifiConnected: {
                    if (this.mNetworkState != null && this.mNetworkState == NetworkState.MobileConnected) {
                        this.mService.updateNetworkStatus(JGNetworkStatus.Changed);
                        break;
                    }
                    this.mService.updateNetworkStatus(JGNetworkStatus.Online);
                    break;
                }
                case MobileConnected: {
                    if (this.mNetworkState != null && this.mNetworkState == NetworkState.WifiConnected) {
                        this.mService.updateNetworkStatus(JGNetworkStatus.Changed);
                        break;
                    }
                    this.mService.updateNetworkStatus(JGNetworkStatus.Online);
                    break;
                }
                case Disconnected: {
                    this.mService.updateNetworkStatus(JGNetworkStatus.Offline);
                    break;
                }
            }
        }
        this.mNetworkState = newState;
    }

    public void setJcfLogLevel(int level) {
        CSFLogHelper.setCsfLoggingLevel((int)level);
    }

    public void setCpveLogLevel(int level) {
        CSFLogHelper.setCpveLoggingLevel((int)level);
    }

    static {
        System.loadLibrary("gnustl_shared");
        System.loadLibrary("rendersink");
        System.loadLibrary("cryptox");
        System.loadLibrary("sslx");
        System.loadLibrary("srtp");
        System.loadLibrary("cpve-opensource");
        System.loadLibrary("cpve");
        System.loadLibrary("JCF");
        System.loadLibrary("csfloghelper");
    }

    private class VideoLicenseActivateDialog
    extends DialogFragment {
        private ListView mVideoLicenseResponseView;

        public void onCreate(Bundle savedInstanceState) {
            this.setShowsDialog(true);
            this.setStyle(1, 0x1030010);
            super.onCreate(savedInstanceState);
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            this.getDialog().setCanceledOnTouchOutside(false);
            View v = inflater.inflate(R.layout.jgsdk_video_license_view, container, true);
            return v;
        }

        public void onStart() {
            super.onStart();
            Dialog dlg = this.getDialog();
            if (dlg != null) {
                int width = 700;
                int height = -2;
                dlg.getWindow().setLayout(width, height);
            }
            this.createVideoLicenseResponseList(dlg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dismiss() {
            ProgressBar bar = (ProgressBar)this.getActivity().getFragmentManager().findFragmentByTag("videoLicenseDialog").getView().findViewById(R.id.jgsdk_progressbar1);
            bar.setVisibility(8);
            Object object = JcfJabberGuestCall.this.lockVideoLicenseDlgOnScreen;
            synchronized (object) {
                JcfJabberGuestCall.this.mVideoLicenseDlgOnScreen = false;
            }
            super.dismiss();
        }

        private void createVideoLicenseResponseList(Dialog dlg) {
            this.mVideoLicenseResponseView = (ListView)dlg.findViewById(R.id.jgsdk_video_license_options);
            Object[] titles = this.getResources().getStringArray(R.array.jgsdk_video_license_options);
            ArrayAdapter adapter = new ArrayAdapter(this.getActivity().getBaseContext(), R.layout.jgsdk_video_license_view_item, titles);
            this.mVideoLicenseResponseView.setAdapter((ListAdapter)adapter);
            this.mVideoLicenseResponseView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    ProgressBar bar = (ProgressBar)VideoLicenseActivateDialog.this.getActivity().getFragmentManager().findFragmentByTag("videoLicenseDialog").getView().findViewById(R.id.jgsdk_progressbar1);
                    switch (position) {
                        case 0: {
                            if (bar != null) {
                                bar.setVisibility(0);
                                bar.bringToFront();
                            }
                            JcfJabberGuestCall.this.mService.activateVideoLicense();
                            break;
                        }
                        case 1: {
                            JabberGuestCall jgCall = JabberGuestCall.getInstance();
                            String server = jgCall.getToUri().getAuthority();
                            String licenseUrl = VideoLicenseActivateDialog.this.getActivity().getResources().getString(R.string.url_videolicense);
                            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)String.format(licenseUrl, server)));
                            VideoLicenseActivateDialog.this.getActivity().startActivity(intent);
                            break;
                        }
                        case 2: {
                            VideoLicenseActivateDialog.this.dismiss();
                            break;
                        }
                    }
                }
            });
        }
    }

    private class NetworkReceiver
    extends BroadcastReceiver {
        private NetworkReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            JcfJabberGuestCall.this.updateCurrentNetworkState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NetworkState {
        WifiConnected,
        MobileConnected,
        Disconnected;

    }
}

