/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest.util;

import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.jcf.JcfJabberGuestCall;

public class Log {
    public static final String GLOBAL_LOG_TAG = "JabberGuestSDK";
    public static final String KEY_PREF_LOGLEVEL = "LOGLEVEL";
    public static final String KEY_PREF_JCF_LOGLEVEL = "JCF_LOGLEVEL";
    public static final String KEY_PREF_CPVE_LOGLEVEL = "CPVE_LOGLEVEL";
    private static final String LOG_FORMAT = "%s|%02x|%s";
    protected static int mLogLevel = 5;
    protected static int mCpveLogLevel = 5;
    protected static int mJcfLogLevel = 5;

    public static void v(String tag, String msg, Throwable tr) {
        if (Log.check(2)) {
            android.util.Log.v((String)GLOBAL_LOG_TAG, (String)String.format(LOG_FORMAT, tag, Thread.currentThread().getId(), msg), (Throwable)tr);
        }
    }

    public static void v(String tag, String msg) {
        if (Log.check(2)) {
            android.util.Log.v((String)GLOBAL_LOG_TAG, (String)String.format(LOG_FORMAT, tag, Thread.currentThread().getId(), msg));
        }
    }

    public static void d(String tag, String msg, Throwable tr) {
        if (Log.check(3)) {
            android.util.Log.d((String)GLOBAL_LOG_TAG, (String)String.format(LOG_FORMAT, tag, Thread.currentThread().getId(), msg), (Throwable)tr);
        }
    }

    public static void d(String tag, String msg) {
        if (Log.check(3)) {
            android.util.Log.d((String)GLOBAL_LOG_TAG, (String)String.format(LOG_FORMAT, tag, Thread.currentThread().getId(), msg));
        }
    }

    public static void i(String tag, String msg, Throwable tr) {
        if (Log.check(4)) {
            android.util.Log.i((String)GLOBAL_LOG_TAG, (String)String.format(LOG_FORMAT, tag, Thread.currentThread().getId(), msg), (Throwable)tr);
        }
    }

    public static void i(String tag, String msg) {
        if (Log.check(4)) {
            android.util.Log.i((String)GLOBAL_LOG_TAG, (String)String.format(LOG_FORMAT, tag, Thread.currentThread().getId(), msg));
        }
    }

    public static void w(String tag, String msg, Throwable tr) {
        if (Log.check(5)) {
            android.util.Log.w((String)GLOBAL_LOG_TAG, (String)String.format(LOG_FORMAT, tag, Thread.currentThread().getId(), msg), (Throwable)tr);
        }
    }

    public static void w(String tag, String msg) {
        if (Log.check(5)) {
            android.util.Log.w((String)GLOBAL_LOG_TAG, (String)String.format(LOG_FORMAT, tag, Thread.currentThread().getId(), msg));
        }
    }

    public static void e(String tag, String msg, Throwable tr) {
        if (Log.check(6)) {
            android.util.Log.e((String)GLOBAL_LOG_TAG, (String)String.format(LOG_FORMAT, tag, Thread.currentThread().getId(), msg), (Throwable)tr);
        }
    }

    public static void e(String tag, String msg) {
        if (Log.check(6)) {
            android.util.Log.e((String)GLOBAL_LOG_TAG, (String)String.format(LOG_FORMAT, tag, Thread.currentThread().getId(), msg));
        }
    }

    public static void wtf(String tag, String msg, Throwable tr) {
        android.util.Log.wtf((String)GLOBAL_LOG_TAG, (String)String.format(LOG_FORMAT, tag, Thread.currentThread().getId(), msg), (Throwable)tr);
    }

    public static void wtf(String tag, String msg) {
        android.util.Log.wtf((String)GLOBAL_LOG_TAG, (String)String.format(LOG_FORMAT, tag, Thread.currentThread().getId(), msg));
    }

    public static boolean check(int level) {
        return level >= mLogLevel || android.util.Log.isLoggable((String)GLOBAL_LOG_TAG, (int)level);
    }

    public static void setLogLevel(int level) {
        mLogLevel = level;
    }

    public static void setJcfLogLevel(int level) {
        mJcfLogLevel = level;
        JabberGuestCall inst = JabberGuestCall.getInstance();
        if (inst != null && inst instanceof JcfJabberGuestCall) {
            ((JcfJabberGuestCall)inst).setJcfLogLevel(level);
        }
    }

    public static void setCpveLogLevel(int level) {
        mCpveLogLevel = level;
        JabberGuestCall inst = JabberGuestCall.getInstance();
        if (inst != null && inst instanceof JcfJabberGuestCall) {
            ((JcfJabberGuestCall)inst).setCpveLogLevel(level);
        }
    }

    public static int getLogLevel() {
        return mLogLevel;
    }

    public static int getJcfLogLevel() {
        return mJcfLogLevel;
    }

    public static int getCpveLogLevel() {
        return mCpveLogLevel;
    }

    public static int convertLogLevelString(String strLogLevel) {
        if (strLogLevel.equals("Error")) {
            return 6;
        }
        if (strLogLevel.equals("Warning")) {
            return 5;
        }
        if (strLogLevel.equals("Info")) {
            return 4;
        }
        if (strLogLevel.equals("Debug")) {
            return 3;
        }
        if (strLogLevel.equals("Verbose")) {
            return 2;
        }
        if (strLogLevel.equals("Trace")) {
            return 2;
        }
        return 5;
    }
}

