/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.jcf;

import java.util.HashMap;
import java.util.Map;

public enum InvalidCertReason {
    INVALID_REVOKED,
    INTERNAL_ERROR,
    BASIC_CONSTRAINTS,
    NO_REVOCATION_CHECK,
    REVOCATION_OFFLINE,
    UNTRUSTED_ROOT,
    INVALID_SIGNATURE,
    INVALID_CHAIN,
    CN_NO_MATCH,
    WRONG_USAGE,
    EXPIRED,
    INVALID_NAME,
    INVALID_POLICY,
    FAILED_TO_VERIFY_XMPP_SUBJECT_ALT_NAME,
    REVOCATION_STATUS_UNKNOWN,
    INVALID_EXTENSION,
    CTL_IS_NOT_VALID,
    INVALID_NAME_CONSTRAINT,
    NO_POLICY_ISSUANCE,
    EXPLICIT_DISTRUST,
    NOT_SUPPORTED_CRITICAL_EXT,
    IS_PARTIAL_CHAIN,
    CERT_TRUST_CYCLIC,
    NO_TIME_VALID,
    UNKNOWN;

    private static final Map<Long, InvalidCertReason> lookup;
    private long cValue;

    private InvalidCertReason() {
        this(Utility.nextValue);
    }

    private InvalidCertReason(long value) {
        this.cValue = value;
        Utility.nextValue = value + 1L;
    }

    public long getCValue() {
        return this.cValue;
    }

    public static InvalidCertReason getValue(long value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Long, InvalidCertReason>();
        for (InvalidCertReason value : InvalidCertReason.values()) {
            lookup.put(value.getCValue(), value);
        }
    }

    private static class Utility {
        private static long nextValue = 0L;

        private Utility() {
        }
    }
}

