/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.jcf;

import java.util.HashMap;
import java.util.Map;

public enum ServerConnectionStatus {
    Unknown,
    Connected,
    ConnectedBackup,
    ConnectedPrimary,
    Connecting,
    ConnectingBackup,
    ConnectingPrimary,
    Disconnected,
    DisconnectedWaitingToRetry,
    Disconnecting,
    LastConnectFailed,
    LastConnectSucceeded,
    NotConfigured,
    Reconnecting,
    Started,
    Stopped,
    ConnectedVideoDisabled,
    Available,
    Unavailable;

    private static final Map<Long, ServerConnectionStatus> lookup;
    private long cValue;

    private ServerConnectionStatus() {
        this(Utility.nextValue);
    }

    private ServerConnectionStatus(long value) {
        this.cValue = value;
        Utility.nextValue = value + 1L;
    }

    public long getCValue() {
        return this.cValue;
    }

    public static ServerConnectionStatus getValue(long value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Long, ServerConnectionStatus>();
        for (ServerConnectionStatus value : ServerConnectionStatus.values()) {
            lookup.put(value.getCValue(), value);
        }
    }

    private static class Utility {
        private static long nextValue = 0L;

        private Utility() {
        }
    }
}

