/*
 *Copyright (c) 2015 Cisco and/or its affiliates.  All rights reserved.
 */

package com.jabberguest.sample.interview;

import java.util.List;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.PreviewFragment;
import com.cisco.jabber.guest.JabberGuestCall.JabberGuestInvalidCertificateCallback;
import com.cisco.jabber.guest.JabberGuestCall.State;

/**
 * A custom Preview Fragment to handle each of the interview calls.
 */
public class CustomPreviewFragment extends PreviewFragment {

    private JabberGuestCall mInstance;
    private String mInterviewer;
    private Uri mAddress;
    private CustomCallFragment mCustomCallFragment;

    /**
     * Class to handle invalid certificate notifications
     */
    private class JabberGuestCertificateHandler implements JabberGuestInvalidCertificateCallback {

        @Override
        public void onInvalidCertificate(String certFingerprint,
                String identifierToDisplay,
                String certSubjectCN, String referenceID,
                List<String> invalidReason, String subjectCertificateData,
                List<String> intermediateCACertificateData,
                boolean allowUserToAccept) {

            // For this sample we are accepting all certificates
            JabberGuestCall.getInstance().acceptInvalidCertificate(referenceID, subjectCertificateData);
        }
    } 
    JabberGuestCertificateHandler mCertificateHandler = new JabberGuestCertificateHandler();

    /**
     * Receiver to handle JabberGuestCall State changes
     * This receiver is used to update the UI based on what state the call is in.
     */
    private class JabberGuestStateBroadcastReceiver extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {

            String action = intent.getAction();
            if (JabberGuestCall.ACTION_CALL_STATE_CHANGED.equals(action)) {

                State state = (JabberGuestCall.State) intent.getSerializableExtra(JabberGuestCall.ARG_CALL_STATE_VALUE);

                if (state == State.GuestCallStateDisconnected) {            		
                    // If we are disconnected, hide the preview
                    ((MainActivity) getActivity()).hidePreview();
                }
            }
        }
    }
    JabberGuestStateBroadcastReceiver mStateReceiver = new JabberGuestStateBroadcastReceiver();

    /*
     * (non-Javadoc)
     * @see com.cisco.jabber.guest.PreviewFragment#onCallClick()
     */
    @Override
    protected boolean onCallClick() {

        // Register the JabberGuestInvalidCertificateCallback
        JabberGuestCall.registerInvalidCertificateHandler(mCertificateHandler);

        // Register the JabberGuestCall State receiver
        JabberGuestCall.registerReceiver(getActivity(), mStateReceiver);

        // Start the JabberCall Instance
        mInstance.start();

        Toast.makeText(getActivity(), getString(R.string.connecting_to_) + mInterviewer, Toast.LENGTH_LONG).show();

        // Show the CustomCallFragment
        mCustomCallFragment = new CustomCallFragment();
        getFragmentManager().beginTransaction().hide(this).add(R.id.mainFrameLayout, mCustomCallFragment, "CustomCallFragment").commit();

        return true;
    }

    /*
     * (non-Javadoc)
     * @see com.cisco.jabber.guest.BaseFragment#onCreate(android.os.Bundle)
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {

        Bundle args = getArguments();
        mInterviewer = args.getString("interviewer");
        mAddress = Uri.parse(args.getString("address"));

        // Set the URI to dial
        mInstance = JabberGuestCall.getInstance();
        if (mInstance == null) {
            mInstance = JabberGuestCall.createInstance(getActivity(), mAddress);
        } else {
            mInstance.end();
            mInstance = JabberGuestCall.createInstance(getActivity(), mAddress);
        }

        super.onCreate(savedInstanceState);
    }

    /*
     * (non-Javadoc)
     * @see com.cisco.jabber.guest.PreviewFragment#onPause()
     */
    @Override
    public void onPause() {

        if (mCustomCallFragment != null)
            getFragmentManager().beginTransaction().show(this).remove(mCustomCallFragment).commit();

        // Unregister the JabberGuestInvalidCertificateCallback
        JabberGuestCall.unregisterInvalidCertificateHandler(mCertificateHandler);

        // Unregister the JabberGuestCall State receiver
        JabberGuestCall.unregisterReceiver(mStateReceiver);

        super.onPause();
    }

    /*
     * (non-Javadoc)
     * @see android.app.Fragment#onViewCreated(android.view.View, android.os.Bundle)
     */
    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {

        // Customize the Button
        Button callButton = (Button) view.findViewById(R.id.jgsdk_call_button);
        callButton.setText(getString(R.string.connect_to_) + mInterviewer);

        super.onViewCreated(view, savedInstanceState);
    }

}
