/*
 *Copyright (c) 2015 Cisco and/or its affiliates.  All rights reserved.
 */

package com.jabberguest.sample.interview;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;


public class InterviewAdapter extends ArrayAdapter<Interview> {

    static class InterviewHolder {
        ImageView interviewerImageView;
        TextView interviewerTextView;
        TextView dateTimeTextView;
    }

    Context context; 
    int layoutResourceId;    
    Interview data[] = null;


    public InterviewAdapter(Context context, int layoutResourceId, Interview[] data) {
        super(context, layoutResourceId, data);
        this.layoutResourceId = layoutResourceId;
        this.context = context;
        this.data = data;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {

        View row = convertView;
        InterviewHolder holder = null;

        if(row == null)
        {
            LayoutInflater inflater = ((Activity)context).getLayoutInflater();
            row = inflater.inflate(layoutResourceId, parent, false);

            holder = new InterviewHolder();
            holder.interviewerImageView = (ImageView) row.findViewById(R.id.interviewerImageView);
            holder.interviewerTextView = (TextView) row.findViewById(R.id.interviewerTextView);
            holder.dateTimeTextView = (TextView) row.findViewById(R.id.dateTimeTextView);

            row.setTag(holder);
        }
        else
        {
            holder = (InterviewHolder) row.getTag();
        }

        Interview interview = data[position];
        holder.interviewerImageView.setImageResource(interview.interviewerResourceId);
        holder.interviewerTextView.setText(interview.interviewer);
        holder.dateTimeTextView.setText(interview.datetime);

        return row;
    }

}
