/*
 * Copyright (c) 2015 Cisco and/or its affiliates.  All rights reserved.
 */

package com.jabberguest.sample.interview;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Random;

import android.net.Uri;
import android.os.Bundle;
import android.app.Activity;
import android.app.FragmentManager;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListView;
import android.widget.TextView;

import com.cisco.jabber.guest.JabberGuestCall;
import com.jabberguest.sample.interview.R;

public class MainActivity extends Activity {

    // !!! Specify your own Server and Address !!!     
    public static final String DEFAULT_SERVER = "jabberguestsandbox.cisco.com";
    public static final String DEFAULT_ADDRESS = "5555";

    private Uri mCallUri;
    private ArrayList<Interview> mInterviews;
    private ListView mMainListView;
    private CustomPreviewFragment mCustomPreviewFragment;
    private static final String CUSTOM_PREVIEW_FRAGMENT_TAG = "CustomPreviewFragment";

    /*
     * (non-Javadoc)
     * @see android.app.Activity#onCreate(android.os.Bundle)
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

//      The Jabber Guest SDK for Android uses H.264 AVC video, which requires activation of license agreement
//      by each user. If your application uses any of our included SDK components that use this functionality
//      (SelfView, PreviewView, PreviewFragment, or JabberGuestCallActivity), the user will be prompted to 
//      activate the video license with a DialogFragment. Once the user activates the video license, they will
//      not be prompted to do so again for subsequent calls. If the app is uninstalled or reinstalled, the video 
//      license will need to be reactivated.
//
//      If your application does not use any of those SDK components, you will have to provide the JabberGuestCall
//      instance with a valid activity context where this dialog can be displayed prior to calling start() or 
//      setSelfTextureView(TextureView textureView) on your JabberGuestCall instance; see the documentation for
//      the registerContext(Context context) method of the JabberGuestCall class for more details. Failure to
//      register a context with your JabberGuestCall instance prior to calling start() or 
//      setSelfTextureView(TextureView textureView) will result in an error being logged, and your calls will
//      not be allowed to proceed.
//        
//      If your company has it’s own license agreement for H.264 AVC video from MPEG LA, and you wish to disable
//      the display of the video license DialogFragment, place the following code in your app before calls are 
//      made to start() or setSelfTextureView(TextureView textureView) on your JabberGuestCall instance:
//        
//      JabberGuestCall.disableVideoLicenseActivation(getApplicationContext()); 

        // Compose a URI to initialize the JabberGuestCall
        mCallUri = JabberGuestCall.createUri(DEFAULT_SERVER, DEFAULT_ADDRESS, null);

        // Set the ListView OnItemClickListener
        mMainListView = (ListView) this.findViewById(R.id.mainlistView);
        mMainListView.setOnItemClickListener(new OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {

                // When clicked, get the Interview information and show the Preview
                Interview interview = mInterviews.get(position);
                showPreview(interview.interviewer, interview.address);				
            }

        });

        // Get a calendar to present a faux schedule
        Calendar scheduleCalendar = Calendar.getInstance();

        // Get the long date format
        DateFormat dateFormat = android.text.format.DateFormat.getLongDateFormat(this);

        TextView titleTextView = (TextView) this.findViewById(R.id.titleTextView);
        String title = getString(R.string.interview_schedule_for) + dateFormat.format(scheduleCalendar.getTime());
        titleTextView.setText(title);

        // Get the current hour
        DateFormat timeFormat = android.text.format.DateFormat.getTimeFormat(this);

        // Back up the current hour by 1 and zero out the minutes
        scheduleCalendar.add(Calendar.HOUR_OF_DAY, -1);
        scheduleCalendar.set(Calendar.MINUTE, 0);

        // Setup for some random names to populate the list
        String date;
        String name;
        String[] firstNames = this.getResources().getStringArray(R.array.firstNames);
        String[] lastNames = this.getResources().getStringArray(R.array.lastNames);

        // Create some Interviews, incrementing the time by 30 minutes each
        mInterviews = new ArrayList<Interview>();         
        for (int i = 0; i < 11; i++) {

            // For this sample, all the URIs point to the same one: mCallUri
            // In a real example, each element would have a unique target URI

            Random r = new Random();
            date = timeFormat.format(scheduleCalendar.getTime());
            name = firstNames[r.nextInt(firstNames.length)].concat(" ").concat(lastNames[r.nextInt(lastNames.length)]);	
            mInterviews.add(new Interview(R.drawable.ic_generic_user_square_medium, name, date, mCallUri));

            scheduleCalendar.add(Calendar.MINUTE, 30);
        }

        InterviewAdapter mInterviewArrayAdapter = new InterviewAdapter(this, R.layout.item_interview, mInterviews.toArray(new Interview[mInterviews.size()]));

        mMainListView.setAdapter(mInterviewArrayAdapter);
    }

    /*
     * (non-Javadoc)
     * @see android.app.Activity#onMenuItemSelected(int, android.view.MenuItem)
     */
    @Override
    public boolean onMenuItemSelected(int featureId, MenuItem item) {

        switch (item.getItemId()) {

        case android.R.id.home:
            hidePreview();
            break;
        }

        return super.onMenuItemSelected(featureId, item);
    }

    /*
     * (non-Javadoc)
     * @see android.app.Activity#onBackPressed()
     */
    @Override
    public void onBackPressed() {

        // Handle hiding the preview fragment on a back press
        if (mCustomPreviewFragment != null && mCustomPreviewFragment.isAdded())
            hidePreview();
        else
            super.onBackPressed();
    }

    /**
     * Hide the CustomPreviewFragment
     */
    public void hidePreview() {

        FragmentManager fm = getFragmentManager();

        // See if we already have a fragment created
        if (mCustomPreviewFragment == null)
            mCustomPreviewFragment = (CustomPreviewFragment) fm.findFragmentByTag(CUSTOM_PREVIEW_FRAGMENT_TAG);

        if (mCustomPreviewFragment == null)
            return;

        // Remove the fragment
        fm.beginTransaction()
        .remove(mCustomPreviewFragment)
        .commit();

        findViewById(R.id.mainLinearLayout).setVisibility(View.VISIBLE);

        // Hide the UP affordance
        getActionBar().setDisplayHomeAsUpEnabled(false);
    }

    /**
     * Show the CustomPreviewFragment
     */	
    public void showPreview(String interviewer, Uri toUri) {

        FragmentManager fm = getFragmentManager();

        // See if we already have a fragment created
        if (mCustomPreviewFragment == null)
            mCustomPreviewFragment = (CustomPreviewFragment) fm.findFragmentByTag(CUSTOM_PREVIEW_FRAGMENT_TAG);

        if (mCustomPreviewFragment == null) {			
            mCustomPreviewFragment = new CustomPreviewFragment();
        }

        // Pass information to the Fragment
        Bundle args = new Bundle();
        args.putString("interviewer", interviewer);
        args.putString("address", toUri.toString());
        mCustomPreviewFragment.setArguments(args);

        fm.beginTransaction()
        .setCustomAnimations(android.R.animator.fade_in, android.R.animator.fade_out)
        .add(R.id.mainFrameLayout, mCustomPreviewFragment, CUSTOM_PREVIEW_FRAGMENT_TAG)
        .commit();

        findViewById(R.id.mainLinearLayout).setVisibility(View.INVISIBLE);

        // Show the UP affordance
        getActionBar().setDisplayHomeAsUpEnabled(true);
    }


}
