/*
 * Copyright (c) 2015 Cisco and/or its affiliates.  All rights reserved.
 */

package com.jabberguest.sample.preview;

import java.util.List;

import android.net.Uri;
import android.os.Bundle;
import android.app.Activity;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.Toast;

import com.cisco.jabber.guest.CallFragment;
import com.cisco.jabber.guest.JabberGuestCall;
import com.cisco.jabber.guest.PreviewFragment;
import com.cisco.jabber.guest.JabberGuestCall.JabberGuestInvalidCertificateCallback;
import com.jabberguest.sample.preview.R;

public class MainActivity extends Activity {

    // !!! Specify your own Server and Address !!!     
    public static final String DEFAULT_SERVER = "jabberguestsandbox.cisco.com";
    public static final String DEFAULT_ADDRESS = "5555";

    private Uri mCallUri;
    private JabberGuestCall mInstance;

    // Class to handle invalid certificate notifications
    private class JabberGuestCertificateHandler implements JabberGuestInvalidCertificateCallback {

        @Override
        public void onInvalidCertificate(String certFingerprint,
                String identifierToDisplay,
                String certSubjectCN, String referenceID,
                List<String> invalidReason, String subjectCertificateData,
                List<String> intermediateCACertificateData,
                boolean allowUserToAccept) {

            // For this sample we are accepting all certificates
            JabberGuestCall.getInstance().acceptInvalidCertificate(referenceID, subjectCertificateData);
        }
    } 
    JabberGuestCertificateHandler mCertificateHandler = new JabberGuestCertificateHandler();

    /**
     * Fragment that shows how to use the Preview functionality of Jabber Guest.
     */
    public static class CustomPreviewFragment extends com.cisco.jabber.guest.PreviewFragment {

        public Uri uri;

        public CustomPreviewFragment() {
            super();
        }

        /*
         * (non-Javadoc)
         * @see android.app.Fragment#onViewCreated(android.view.View, android.os.Bundle)
         */
        @Override
        public void onViewCreated(View view, Bundle savedInstanceState) {

            Button callButton = (Button) view.findViewById(R.id.jgsdk_call_button);
            callButton.setText("Video Call a Support Tech");

            super.onViewCreated(view, savedInstanceState);
        }

        /*
         * (non-Javadoc)
         * @see com.cisco.jabber.guest.PreviewFragment#onCallClick()
         */
        @Override
        protected boolean onCallClick() {

            JabberGuestCall instance = JabberGuestCall.getInstance();
            if (instance == null) {
                return false;
            }

            // Show the CallFragment
            ((MainActivity) getActivity()).showCall(uri);          

            // Optionally give some custom alert or toast
            Toast.makeText(getActivity(), "Transferring you to a support technician at " + uri.getQueryParameter("uri"), Toast.LENGTH_LONG).show();

            return true;
        }

    }

    /*
     * (non-Javadoc)
     * @see android.app.Activity#onCreate(android.os.Bundle)
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

//      The Jabber Guest SDK for Android uses H.264 AVC video, which requires activation of license agreement
//      by each user. If your application uses any of our included SDK components that use this functionality
//      (SelfView, PreviewView, PreviewFragment, or JabberGuestCallActivity), the user will be prompted to 
//      activate the video license with a DialogFragment. Once the user activates the video license, they will
//      not be prompted to do so again for subsequent calls. If the app is uninstalled or reinstalled, the video 
//      license will need to be reactivated.
//
//      If your application does not use any of those SDK components, you will have to provide the JabberGuestCall
//      instance with a valid activity context where this dialog can be displayed prior to calling start() or 
//      setSelfTextureView(TextureView textureView) on your JabberGuestCall instance; see the documentation for
//      the registerContext(Context context) method of the JabberGuestCall class for more details. Failure to
//      register a context with your JabberGuestCall instance prior to calling start() or 
//      setSelfTextureView(TextureView textureView) will result in an error being logged, and your calls will
//      not be allowed to proceed.
//        
//      If your company has it’s own license agreement for H.264 AVC video from MPEG LA, and you wish to disable
//      the display of the video license DialogFragment, place the following code in your app before calls are 
//      made to start() or setSelfTextureView(TextureView textureView) on your JabberGuestCall instance:
//        
//      JabberGuestCall.disableVideoLicenseActivation(getApplicationContext()); 

        // Compose a URI to initialize the JabberGuestCall
        mCallUri = JabberGuestCall.createUri(DEFAULT_SERVER, DEFAULT_ADDRESS, null);

        // Create a new instance for each call.
        mInstance = JabberGuestCall.createInstance(getApplicationContext(), mCallUri);

        // Register the JabberGuestInvalidCertificateCallback
        JabberGuestCall.registerInvalidCertificateHandler(mCertificateHandler);

        // Handle the user clicking the default preview button
        findViewById(R.id.defaultPreviewButton).setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                showPreview();             
            }

        });          

        // Handle the user clicking the custom preview button
        findViewById(R.id.customPreviewButton).setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                showCustomPreview(mCallUri);             
            }

        }); 

    }

    /**
     * Show the Jabber Guest Call Fragment.
     * @param uri 
     */
    private void showCall(final Uri uri) {

        if (uri == null)
            throw new IllegalArgumentException();

        CallFragment callFragment = new CallFragment();
        getFragmentManager().beginTransaction().replace(R.id.placeHolderLinearLayout, callFragment).commit();

        findViewById(R.id.placeHolderLinearLayout).setVisibility(View.VISIBLE);

        // Actually start the Jabber Guest Call
        if (mInstance != null) {
            mInstance.start();
        }
    }

    /**
     * Show the Jabber Guest Custom Preview Fragment.
     * @param uri
     */
    private void showCustomPreview(final Uri uri) {

        if (uri == null)
            throw new IllegalArgumentException();

        CustomPreviewFragment previewFragment = new CustomPreviewFragment();
        previewFragment.uri = uri;
        getFragmentManager().beginTransaction().replace(R.id.placeHolderLinearLayout, previewFragment).commit();

        findViewById(R.id.placeHolderLinearLayout).setVisibility(View.VISIBLE);
    }

    /**
     * Show the Jabber Guest Preview Fragment.
     * @param uri 
     */
    private void showPreview() {        

        PreviewFragment previewFragment = PreviewFragment.createInstance();
        getFragmentManager().beginTransaction().replace(R.id.placeHolderLinearLayout, previewFragment).commit();

        findViewById(R.id.placeHolderLinearLayout).setVisibility(View.VISIBLE);
    }    
}
