//
//  JabberGuestViewController.swift
//  CustomerSupport
//
//  Copyright (c) 2015 Cisco. All rights reserved.
//

import UIKit



class JabberGuestViewController: UIViewController {
    
    @IBOutlet var remoteView:UIImageView?
    @IBOutlet var aiView:UIActivityIndicatorView?
    var callTriedToConnect = false
    var callBar:CJGuestCallBarView = CJGuestCallBarView()
    
    
    
    required init(coder aDecoder: NSCoder) {
        
        remoteView = UIImageView(frame:CGRectMake(0,0,400,400))
        remoteView?.backgroundColor = UIColor.blackColor()
        remoteView?.contentMode = .ScaleAspectFill
        remoteView?.clipsToBounds = true
        
        
        aiView?.activityIndicatorViewStyle = UIActivityIndicatorViewStyle.WhiteLarge
        aiView = UIActivityIndicatorView(frame:CGRect(x:100, y:100, width:10, height:10))
        aiView?.startAnimating()
        
        super.init(coder:aDecoder)
        
        NSNotificationCenter.defaultCenter().addObserver(self, selector: "handleCallStateChange", name: CJGuestCallStateChangeNotification, object: nil)
        
        
        // The Jabber Guest SDK for iOS uses H.264 AVC video, which requires activation of a license agreement
        // by each user. The user will be prompted to activate the video license with an AlertView.
        //
        // If your company has it’s own license agreement for H.264 AVC video from MPEG LA, and you wish to
        // disable the display of the video license AlertView, you may call the disableActivation API (see below)
        //
        // If you disable the built-in activation capability of the Jabber SDK for iOS, you do so at your own risk
        // and are responsible for any royalties or other fees associated with your use of the H.264 AVC video codec.
        
        // CJGuestVideoLicense.sharedInstance.disableActivation()

        let call:CJGuestCall = CJGuestCall.sharedInstance()
        call.serverName = "jabberguestsandbox.cisco.com"
        call.toURI = "5555"
        call.startCall { (isActivated:Bool) -> Void in
            if(!isActivated) {
                self.navigationController?.popViewControllerAnimated(true)
            }
            
        }
        
        
    }
    
    
    
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.view.addSubview(remoteView!)
        self.view.addSubview(aiView!)
        remoteView?.setTranslatesAutoresizingMaskIntoConstraints(true)
        
        remoteView?.autoresizingMask = UIViewAutoresizing.FlexibleLeftMargin | UIViewAutoresizing.FlexibleRightMargin | UIViewAutoresizing.FlexibleBottomMargin | UIViewAutoresizing.FlexibleTopMargin
        remoteView?.center = CGPointMake(view.bounds.midX, view.bounds.midY)
        aiView?.center = remoteView!.center
        
    }
    
    func layoutCJGuestCallSubViews() {
        
        CJGuestCall.sharedInstance().remoteView = remoteView
        
        let combined : CJGuestCallBarButtonOption = .GuestCallBarButtonOptionAudioMute | .GuestCallBarButtonOptionHook
        
        var callBarOrigin = CGPoint(x:remoteView!.frame.origin.x + ((remoteView!.frame.size.width - (CJGuestCallBarView.callBarButtonSize().width * 2)) / 2.0), y:remoteView!.frame.origin.y + remoteView!.frame.size.height - CJGuestCallBarView.callBarButtonSize().height)
        callBar = CJGuestCallBarView(origin: callBarOrigin , mask:combined)
        callBar.delegate = self
        self.view.addSubview(callBar)
        
        
        
        
    }
    
    
    func handleCallStateChange() {
        let call:CJGuestCall = CJGuestCall.sharedInstance()
        
        switch call.callState {
        case .GuestCallStateConnecting:
            callTriedToConnect = true
        case .GuestCallStateConnected:
            aiView?.stopAnimating()
            self.layoutCJGuestCallSubViews()
        case .GuestCallStateDisconnected:
            if(callTriedToConnect) {
               self.navigationController?.popViewControllerAnimated(true)
            }
        default:break
            
        }
    }
    
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    deinit {
        NSNotificationCenter.defaultCenter().removeObserver(self)
    }
    
    
    
}
