/**
 * Sample code for creating the video widget and setting up an event handler.
 *
 * @param {String} window.videowidgetParams.callUrl Call url that the widget
 *     should be setup to call.
 *
 * @param {Function} [window.videowidgetParams.onEvent] Optional callback for
 *     widget callevents.
 */
(function () {
    var container = document.getElementById('videowidget'),
        widget = document.createElement('iframe'),
        callEventHandler,
        onEvent = window.videowidgetParams ? window.videowidgetParams.onEvent : null,
        link = window.videowidgetParams ? window.videowidgetParams.callUrl : null;

    if (!link) {
        throw new Error('window.videowidgetParams.callUrl must be set before creating the widget.');
    }

    if (onEvent && !JSON) {
        throw new Error('No JSON parser is defined. Add <!DOCTYPE html> or include a third party JSON parsing library.');
    }

    // Setup widget parameters
    widget.id = 'videoWidgetFrame';
    widget.name = 'videoWidgetFrame';
    widget.frameBorder = '0';
    widget.scrolling = 'no';
    widget.setAttribute('allowTransparency', 'true');
    widget.width = '100%';
    widget.height = '100%';
    widget.src = link + '?widget=true';

    // Append the widget
    container.appendChild(widget);

    // Wrap any specified event handler with this function to unpack the JSON
    // string into a nice JavaScript object
    callEventHandler = function(e) {
        var callEvent,
            linkHost = link.substr(0, link.search('/call')).replace(/https?:/, '');

        if ((e.origin === 'null') || (e.origin.replace(/https?:/, '') === linkHost)) {
            callEvent = JSON.parse(e.data);
            try {
                onEvent(callEvent);
            } catch(error) {
                // Error in onEvent: ignore
            }
        }
    };

    // If onEvent handler specified, attach wrapper that will call it with
    // the JSON data parsed and ready to go
    if (onEvent) {
        if (window.attachEvent) {
            window.attachEvent('onmessage', callEventHandler);
        } else {
            window.addEventListener('message', callEventHandler, false);
        }
    }
})();
