#*****************************************************************************
#  This sample is supplied as is with no implied warranty.  
#  It is designed to assist you in using the Cisco AnyConnect VPN API. 
#  It is assumed that you will build a production application and 
#  refer to this sample as a reference only.
#*****************************************************************************
CXX = clang++
CXXFLAGS = -mmacosx-version-min=10.9 -arch x86_64 -arch arm64 -DHAVE_CONFIG_H -DPLATFORM_DARWIN -D_NOEXPORTDLL -std=c++11 -g -O0 -Wall ${INCLUDES}
INCLUDES = -I. -I../../include -I/usr/include/libxml2
LIB_DIR = ../../lib/MAC/Intel
CURL_VER = 4
LIBS = -lvpnapi -lxml2 -lz -lvpncommoncrypt -lvpncommon -lpthread -lacciscocrypto -lacciscossl -lresolv
LDFLAGS = -g -headerpad_max_install_names
DYLIB_DIR = /opt/cisco/anyconnect/lib

all: client client_dylib

client: CLIClientMain.o CLIClientImpl.o
	@echo "\nLinking using static libs..."
	${CXX} ${CXXFLAGS} ${LDFLAGS} ${INCLUDES} -L${LIB_DIR} -o client \
	-framework SystemConfiguration -framework Security -framework CoreFoundation -framework CoreServices \
	-framework IOKit CLIClientMain.o CLIClientImpl.o \
	${LIBS} -laccurl

client_dylib: CLIClientMain.o CLIClientImpl.o
	@echo "\nLinking using dynamic libs..."
	${CXX} ${CXXFLAGS} ${LDFLAGS} ${INCLUDES} -L${DYLIB_DIR} -o client_dylib \
	-framework SystemConfiguration -framework Security -framework CoreFoundation -framework CoreServices \
	-framework IOKit CLIClientMain.o CLIClientImpl.o \
	${LIBS} -laccurl.${CURL_VER}

install: client_dylib
	install_name_tool -change libacciscocrypto.dylib ${DYLIB_DIR}/libacciscocrypto.dylib client_dylib
	install_name_tool -change libacciscossl.dylib ${DYLIB_DIR}/libacciscossl.dylib client_dylib
	install_name_tool -change libvpnapi.dylib ${DYLIB_DIR}/libvpnapi.dylib client_dylib
	install_name_tool -change libvpncommon.dylib ${DYLIB_DIR}/libvpncommon.dylib client_dylib
	install_name_tool -change libvpncommoncrypt.dylib ${DYLIB_DIR}/libvpncommoncrypt.dylib client_dylib
	install_name_tool -change libaccurl.${CURL_VER}.dylib ${DYLIB_DIR}/libaccurl.${CURL_VER}.dylib client_dylib

clean:
	rm -f *.o client client_dylib
