#*****************************************************************************
#  This sample is supplied as is with no implied warranty.  
#  It is designed to assist you in using the Cisco AnyConnect VPN API. 
#  It is assumed that you will build a production application and 
#  refer to this sample as a reference only.
#*****************************************************************************
CXX = clang++
CPPFLAGS = -DHAVE_CONFIG_H
CXXFLAGS = -arch x86_64 -arch arm64 -g -O0 -Wall -std=c++11
CXXFLAGS += -I. -I../../include -I/usr/include/libxml2
LIB_DIR = ../../lib/MAC/Intel
CURL_VER = 4
LIBS = -lvpnapi -lxml2 -lz -lvpncommoncrypt -lvpncommon -lpthread -lacciscocrypto -lacciscossl -lresolv
FRAMEWORKS = -framework SystemConfiguration -framework Security -framework CoreFoundation -framework CoreServices -framework IOKit
LDFLAGS = -headerpad_max_install_names
DYLIB_DIR = /opt/cisco/secureclient/lib

all: client client_dylib

client: CLIClientMain.o CLIClientImpl.o
	@echo "\nLinking using static libs..."
	${CXX} -o client CLIClientMain.o CLIClientImpl.o \
	${FRAMEWORKS} -L${LIB_DIR} ${LIBS} -laccurl ${LDFLAGS}

client_dylib: CLIClientMain.o CLIClientImpl.o
	@echo "\nLinking using dynamic libs..."
	${CXX} -o client_dylib CLIClientMain.o CLIClientImpl.o \
	${FRAMEWORKS} -L${DYLIB_DIR} -laccurl.${CURL_VER} ${LIBS} ${LDFLAGS}

install: client_dylib
	install_name_tool -change libacciscocrypto.dylib ${DYLIB_DIR}/libacciscocrypto.dylib client
	install_name_tool -change libacciscossl.dylib ${DYLIB_DIR}/libacciscossl.dylib client
	install_name_tool -change libvpnapi.dylib ${DYLIB_DIR}/libvpnapi.dylib client
	install_name_tool -change libvpncommon.dylib ${DYLIB_DIR}/libvpncommon.dylib client
	install_name_tool -change libvpncommoncrypt.dylib ${DYLIB_DIR}/libvpncommoncrypt.dylib client
	install_name_tool -change libaccurl.${CURL_VER}.dylib ${DYLIB_DIR}/libaccurl.${CURL_VER}.dylib client

clean:
	rm -f *.o client client_dylib
