/**************************************************************************
*   Copyright (c) 2022 Cisco Systems, Inc.
*   All Rights Reserved. Cisco Highly Confidential.
***************************************************************************
* 
*   File:   ClientIfcCommon.h
*   Author: Chris Fitzgerald
*   Date:   03/2022
* 
***************************************************************************
*   Client Interface Common defines for the Client API.
***************************************************************************/
#ifndef _CLIENTIFCCOMMON_
#define _CLIENTIFCCOMMON_

/*
 * SCRIPTING_SUPPORTED, INTERPROCESS_COMMUNICATION_SUPPORTED macro is a copy of corresponding
 * #define from GenDefs.h. Any change in #define for the macro in GenDefs.h must propogated to
 * this header file too. We duplicate this definition here due to the manner in which we distribute
 * our code to partners; we cannot include GenDefs.h from here.
 */
#if !defined(PLATFORM_APPLE_SSLVPN) && !defined(PLATFORM_ANDROID) && !defined(PLATFORM_WIN_APP)
#define SCRIPTING_SUPPORTED
#endif
#if !defined(PLATFORM_WIN_APP)
#define INTERPROCESS_COMMUNICATION_SUPPORTED
#endif

/*
 * SCEP_CERTIFICATE_ENROLLMENT_SUPPORTED macro is a copy of corresponding #define from GenDefs.h.
 * Any change in #define for the macro in GenDefs.h must propogated to this header file too. We
 * duplicate this definition here due to the manner in which we distribute our code to partners;
 * we cannot include GenDefs.h from here.
 */
#if defined(_WIN32) || defined(_WIN32_WCE) || defined(PLATFORM_DARWIN) || defined(PLATFORM_LINUX) || defined(PLATFORM_ANDROID) || defined(PLATFORM_APPLE_SSLVPN)
#define SCEP_CERTIFICATE_ENROLLMENT_SUPPORTED
#endif

/*
 * HOST_DATA_SUPPORTED macro is a copy of corresponding #define from GenDefs.h. Any change
 * in #define for the macro in GenDefs.h must propogated to this header file too. We duplicate
 * this definition here due to the manner in which we distribute our code to partners;
 * we cannot include GenDefs.h from here.
 */
#if defined(PLATFORM_ANDROID) || defined(PLATFORM_APPLE_SSLVPN) || defined(PLATFORM_CHROMEBOOK)
#define HOST_DATA_SUPPORTED
#endif

/*
 * MANUAL_PKCS12_IMPORT_SUPPORTED macro is a copy of corresponding #define from GenDefs.h.
 * Any change in #define for the macro in GenDefs.h must propogated to this header file too.
 * We duplicate this definition here due to the manner in which we distribute our
 * code to partners; we cannot include GenDefs.h from here.
 */
#if defined(PLATFORM_APPLE_SSLVPN) || defined(PLATFORM_ANDROID) || defined(PRODUCT_TYPE_SSA)
#define MANUAL_PKCS12_IMPORT_SUPPORTED
#endif

/*
 * PROGRAM_DATA_IMPORT_SUPPORTED macro is a copy of corresponding #define from GenDefs.h.
 * Any change in #define for the macro in GenDefs.h must propogated to this header file too.
 * We duplicate this definition here due to the manner in which we distribute our
 * code to partners; we cannot include GenDefs.h from here.
 */
#if defined(PLATFORM_ANDROID)
#define PROGRAM_DATA_IMPORT_SUPPORTED
#endif

/*
 * CREDENTIAL_PREFILL_SUPPORTED macro is a copy of corresponding #define from GenDefs.h.
 * Any change in #define for the macro in GenDefs.h must propogated to this header file too.
 * We duplicate this definition here due to the manner in which we distribute our
 * code to partners; we cannot include GenDefs.h from here.
 */
#if defined(PLATFORM_ANDROID)
#define CREDENTIAL_PREFILL_SUPPORTED
#endif

#if defined(MANUAL_PKCS12_IMPORT_SUPPORTED) && !defined(__GENDEFS_H)
#if defined(HAVE_STDINT_H)
#include <stdint.h>
#else
typedef unsigned char uint8_t;
#endif // HAVE_STDINT_H
#endif // MANUAL_PKCS12_IMPORT_SUPPORTED

#if defined(PLATFORM_WIN_APP)
typedef unsigned char uint8_t;
#endif


#endif // _CLIENTIFCCOMMON_
