/**************************************************************************
*   Copyright (c) 2008, 2021 Cisco Systems, Inc.
*   All Rights Reserved. Cisco Confidential.
***************************************************************************
*
*   File:    PreferenceBase.h
*   Date:    7/2008
*
***************************************************************************
*   Preferences Base class declaration for the Client API.
***************************************************************************/

#ifndef _PREFERENCEBASE_
#define _PREFERENCEBASE_

#include "api.h"
#include <list>
#include <vector>
#include "PromptEntry.h"

class Preference;
struct DEFAULT_PREFERENCE;

enum PreferenceAttribute{Available,            
                         UserControllable,     
                         UserControlAllowed,
                         PostAuthVerification, 
                         UnknownAttribute};

#define PREFERENCE_COUNT UnknownPreference
#define ATTRIBUTE_COUNT UnknownAttribute

typedef std::list<Preference*> PreferenceList;

class VPN_VPNAPI PreferenceBase
{

    protected:
     
        PreferenceBase(PreferenceId preferenceId,
                       const tstring& label,
                       PromptType prefType,
                       const tstring& initialValue,
                       ApiStringMap* pOptions = NULL,
                       Preference* pParent = NULL);

    public:

        const PreferenceId& getPreferenceId() const;
        PreferenceScope getPreferenceScope() const;

        const tstring& getPreferenceValue() const;
        bool setPreferenceValue(const tstring& value);

        bool getPreferenceAttribute(const PreferenceAttribute& attribute); 
        void setPreferenceAttribute(const PreferenceAttribute& attribute, bool value);

        const PreferenceList& getChildren() const; 
        
        void addChildPreference(Preference* pPref);
        void removeChildPreference(Preference* pPref);
     
        PromptEntry* getPromptEntry() const;

        static Preference* createPreferenceFromId(PreferenceId prefId);
        
        static tstring getPreferenceNameFromId(PreferenceId prefId);
        static PreferenceId getPreferenceIdFromName(const tstring& name);
        static PreferenceAttribute getAttributeIdFromName(const tstring& attributeName);
        static tstring getAttributeNameFromId(const PreferenceAttribute attrId);
        static PreferenceId getParentId(const PreferenceId prefId);
        static PreferenceScope getPreferenceScopeFromId(PreferenceId prefId);
        static tstring getDefaultValue(PreferenceId prefId);
        static bool getDefaultAttribute(PreferenceId prefId, 
                                        PreferenceAttribute attribute);
        static bool isParentPreference(const PreferenceId prefId);
        static bool isPreferenceDefined(const PreferenceId prefId);
        static bool isValidPreference(const PreferenceId prefId);

        PreferenceBase& operator=(const PreferenceBase&);
        explicit PreferenceBase(const PreferenceBase&);
        ~PreferenceBase();

        static const tstring PreferenceEnabled;
        static const tstring PreferenceDisabled;

        static const tstring DisconnectOnSuspend;
        static const tstring ReconnectAfterResume;

        static const tstring AllStores;
        static const tstring MachineStore;
        static const tstring UserStore;
        static const tstring SystemStore;
        static const tstring LoginStore;
        static const tstring UserFirefoxNSS;
        static const tstring UserPEMFile;

        static const tstring Automatic;
        static const tstring SoftwareToken;
        static const tstring HardwareToken;

        static const tstring SingleLogon;
        static const tstring SingleLocalLogon;
        static const tstring SingleLogonNoRemote;

        static const tstring LocalUsersOnly;
        static const tstring AllowRemoteUsers;

        static const tstring ProxyNative;
        static const tstring ProxyIgnoreProxy;
        static const tstring ProxyOverride;

        static const tstring PPPExclusionAutomatic;
        static const tstring PPPExclusionDisable;
        static const tstring PPPExclusionOverride;

        static const tstring Connect;
        static const tstring Pause;
        static const tstring Disconnect;
        static const tstring DoNothing;

        static const tstring SameUserOnly;
        static const tstring AnyUser;

        static const tstring PasswordComplexityAlpha;
        static const tstring PasswordComplexityPin;
        static const tstring PasswordComplexityStrong;

        static const tstring Open;
        static const tstring Closed;

        static const tstring IPv4;
        static const tstring IPv6;
        static const tstring IPv4_IPv6;
        static const tstring IPv6_IPv4;
        
    private:
        PreferenceId me_preferenceId;
        PromptEntry* m_pPromptEntry;
        PreferenceList m_childPreferences;
        PreferenceScope me_preferenceScope;
        bool mb_attributes[ATTRIBUTE_COUNT];
        
        static const char* sm_attributeStrs[];
        static const DEFAULT_PREFERENCE sm_defaultPreferences[];
};

#endif // _PREFERENCEBASE_
