/******************************************************************************\
 *  This sample is supplied as is with no implied warranty.  
 *  It is designed to assist you in using the Cisco AnyConnect VPN API. 
 *  It is assumed that you will build a production application and 
 *  refer to this sample as a reference only.
 \*****************************************************************************/

// MainDialog.h : header file
//

#pragma once

#include <map>
#include <list>
#include <string>
#include "GUIClientImpl.h"
class Gui;
class PromptDialog;

enum CustomMessage
{   
    MF_NEWEVENT = WM_APP
};

/**
 * MainDialog dialog
 */
class MainDialog : public CDialog
{
// Construction
public:
	MainDialog(Gui* pParent = NULL);	// standard constructor

	enum { IDD = IDD_EXAMPLE4_DIALOG };
	
    CStatusBarCtrl *m_statusBar;
    PromptDialog *m_promptDialog;
    GUIClientImpl *m_pApiImpl;
    ConnectPromptInfo *m_pPromptInfo;
    std::list<tstring> m_promptNames;

    void HandlePromptCB(ConnectPromptInfo &connectPrompt);
    /**
     * This method demonstrates the posting of an event once the API has
     * indicated there is data available (see GUIClientImpl::EventAvailable).
     *
     * After the posted event fires, the method MainDialog::OnEventAvailable
     * is called.
     */
    void HandleEventAvailable();

    void showStatusbarText (const tstring &text);

// Implementation
protected:
    Gui *m_pParent;
    tstring m_hostName;
    
    virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
    afx_msg void OnCbnSelchangeCombo1();
    afx_msg void OnBnClickedOk();
    afx_msg void OnBnClickedCancel();
    afx_msg void OnBnClickedDisconnect();

    /**
     * This method is invoked after the posted event from the method
     * MainDialog::HandleEventAvailable fires.
     *
     * This method invokes the API method ClientIfc::ProcessEvents
     * which in turn causes all pending events (NoticeCB,
     * UserPromptCB, etc.) to be delivered.
     */
    LRESULT OnEventAvailable(WPARAM wparam, LPARAM lparam);

	DECLARE_MESSAGE_MAP()
};
