/*
 * Decompiled with CFR 0.152.
 */
package InstallerJava;

import InstallerJava.Examiner;
import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import netscape.javascript.JSObject;

public class InstallerJava
extends Applet {
    private static int STATUS_STUB_FAILURE = -1;
    private static int STATUS_INITIAL_VALUE = 0;
    private static int STATUS_STARTED = 1;
    private static int STATUS_STUB_IN_PROGRESS = 2;
    private static int STATUS_STUB_SUCCESS = 3;
    private static int STUB_EXIT_CODE_MAX = 65535;
    private static int STUB_ERROR_UNKNOWN = 0;
    private static int STUB_ERROR_DLL_LOAD_FAILED = -40;
    private static int STUB_ERROR_VERIFICATION_FAILED = -41;
    private static int STUB_NATIVE_LAUNCH_FAILED = -42;
    private static int STUB_ERROR_BEGIN_THREAD_FAILED = -43;
    private static int STUB_ERROR_CREATE_PROCESS_FAILED = -44;
    private static int STUB_CHANGE_PERMISSION_FAILED = -45;
    private static int STUB_UNKNOWN_PLATFORM = -46;
    public static volatile int status = STATUS_INITIAL_VALUE;
    public static volatile int errorcode = STUB_ERROR_UNKNOWN;
    public String url = "";
    public String ticket = "";
    public String stub = "";
    public String group = "";
    public String certhash = "";
    public String langsel = "";
    public String version = "";
    private static String manifest = null;
    private Thread t;
    public static boolean OsIsWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    public static boolean OsIsLinux = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
    public static boolean OsIsLinuxI386 = OsIsLinux && System.getProperty("os.arch").toLowerCase().indexOf("i386") != -1;
    public static boolean OsIsLinuxX64 = OsIsLinux && System.getProperty("os.arch").toLowerCase().indexOf("amd64") != -1;
    public static boolean OsIsMac = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    public static boolean OsIsIntelMac32 = OsIsMac && (System.getProperty("os.arch").toLowerCase().indexOf("i386") != -1 || System.getProperty("os.arch").toLowerCase().indexOf("i686") != -1);
    public static boolean OsIsIntelMac64 = OsIsMac && System.getProperty("os.arch").toLowerCase().indexOf("x86_64") != -1;
    public static boolean OsIsIntelMac = OsIsIntelMac32 || OsIsIntelMac64;
    public static String MacOsVersion = System.getProperty("os.version").toLowerCase();
    public static String[] splitSubVersions = OsIsIntelMac ? MacOsVersion.split("\\.") : null;
    public static String MacOsSubVersion;
    public static boolean OsIsMacMavericksAndAbove;
    public static String hsLibPath;
    public static String hsBinPath;
    public static String hs64MacLibPath;
    public static String hs64MacBinPath;
    public static int MAX_ZIP_SIZE;
    private File tempFolder;
    private String fileSep = System.getProperty("file.separator");
    public static String HS_JS_VARIABLE_NAME_STATUS;
    public static String HS_JS_VARIABLE_NAME_ERRORCODE;

    public static void log(String string) {
        System.out.println(new Date().toString() + " " + string);
    }

    public static void log_unsupported_platform(String string) {
        System.out.println(new Date().toString() + " " + string);
        System.out.println(new Date().toString() + "  Platform Details:  os_name :" + System.getProperty("os.name") + " os_version :" + System.getProperty("os.version") + " os_arch :" + System.getProperty("os.arch"));
    }

    protected void debugLog(String string) {
    }

    protected void setStatus(int n) {
        this.debugLog("status update : " + status + " -> " + n);
        status = n;
        this.update_javascript_variable(HS_JS_VARIABLE_NAME_STATUS, status);
    }

    protected void setErrorCode(int n) {
        this.debugLog("errorcode update : " + errorcode + " -> " + n);
        errorcode = n;
        this.update_javascript_variable(HS_JS_VARIABLE_NAME_ERRORCODE, errorcode);
    }

    private void update_javascript_variable(String string, int n) {
        if (null == string || string.length() <= 0) {
            return;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this);
            jSObject.setMember(string, Integer.toString(n));
        }
        catch (Exception exception) {
            InstallerJava.log("Exception occured: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private boolean deleteFile(String string) {
        boolean bl = false;
        if (string == null) {
            InstallerJava.log("Improper inputs");
            return false;
        }
        try {
            File file = new File(string);
            if (file.exists()) {
                bl = file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    protected String createFileFromStream(InputStream inputStream, File file) {
        String string = file.getAbsolutePath();
        try {
            file.delete();
        }
        catch (SecurityException securityException) {
            InstallerJava.log("Exception while trying to delete previous copy of file. continuing...");
        }
        try {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray, 0, 8192)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            InstallerJava.log("Exception while creating file" + string + ". continuing...");
        }
        return string;
    }

    public Examiner getExaminer() {
        Object object;
        if (OsIsWindows || OsIsIntelMac) {
            String string = OsIsWindows ? "CSDJavaInstaller.dll" : "CSDJavaInstaller.dylib";
            object = this.getClass().getResourceAsStream("/InstallerJava/" + string);
            if (object == null) {
                InstallerJava.log("CSDJavaInstaller library not found");
                return null;
            }
            String string2 = System.getProperty("java.io.tmpdir");
            if (!string2.endsWith(this.fileSep)) {
                string2 = string2.concat(this.fileSep);
            }
            File file = new File((string2 == null ? "" : string2) + string);
            String string3 = this.createFileFromStream((InputStream)object, file);
            try {
                System.load(string3);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                InstallerJava.log("Error when trying to load " + string + ". continuing...");
                return null;
            }
        }
        object = new Examiner();
        return object;
    }

    public String replaceex(String string, String string2, String string3) {
        String string4 = string;
        int n = 0;
        n = string4.indexOf(string2, n);
        while (n != -1) {
            string4 = string4.substring(0, n) + string3 + string4.substring(n + string2.length());
            n = string4.indexOf(string2, n);
        }
        return string4;
    }

    private boolean create_dir(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        try {
            File file = new File(string);
            if (file.exists()) {
                InstallerJava.log(string + " already exists");
                return true;
            }
            if (!file.mkdirs()) {
                InstallerJava.log("Failed to create " + string);
                return false;
            }
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private String create_hs_libs_dir() {
        if (OsIsWindows) {
            return null;
        }
        String string = this.get_hs_libs_path();
        if (this.create_dir(string)) {
            return string;
        }
        return null;
    }

    private boolean downloadInMemory(String string, StringBuffer stringBuffer) {
        boolean bl = false;
        String string2 = "";
        if (string == null || stringBuffer == null) {
            InstallerJava.log("Improper inputs");
            return false;
        }
        try {
            int n;
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray, 0, 4096)) != -1) {
                string2 = string2 + new String(byArray, 0, n);
            }
            inputStream.close();
            InstallerJava.log("Downloaded " + string);
            stringBuffer.append(string2);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            InstallerJava.log("Error while downloading " + string);
        }
        return bl;
    }

    private boolean downloadFile(String string, String string2) {
        boolean bl = false;
        String string3 = "";
        if (string == null || string2 == null) {
            InstallerJava.log("Improper inputs");
            return false;
        }
        InstallerJava.log("Download url : " + string);
        InstallerJava.log("Download path : " + string2);
        String string4 = string2.substring(0, string2.lastIndexOf(this.fileSep));
        if (string4 == null) {
            return false;
        }
        if (!this.doesPathExist(string4) && !this.create_dir(string4)) {
            InstallerJava.log("'" + string4 + "' does not exist and could not be created");
            return false;
        }
        try {
            int n;
            File file = new File(string2);
            string3 = file.getAbsolutePath();
            file.delete();
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            if (string.substring(0, 5).compareTo("file:") == 0) {
                string = string.substring(5);
                while (string.substring(0, 1).compareTo("/") == 0) {
                    string = string.substring(1);
                }
                string = "file:" + string;
                string = string.replace('/', '\\');
                string = this.replaceex(string, "%20", " ");
            }
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray, 0, 4096)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            inputStream.close();
            InstallerJava.log("Downloaded " + string + " to " + string3);
            bl = true;
        }
        catch (Exception exception) {
            InstallerJava.log("Error while downloading file" + string3 + ". continuing...");
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private boolean unzip(String string, String string2, String string3) {
        boolean bl = false;
        if (string == null || string2 == null || string3 == null) {
            InstallerJava.log("Improper inputs");
            return false;
        }
        InstallerJava.log("zipFilePath : " + string);
        InstallerJava.log("unzipPath : " + string2);
        InstallerJava.log("unzipFileName : " + string3);
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(string2 + this.fileSep + string3);
            int n = 0;
            byte[] byArray = new byte[1024];
            int n2 = 0;
            while ((n = gZIPInputStream.read(byArray, 0, 1024)) != -1) {
                if ((n2 += n) >= MAX_ZIP_SIZE) {
                    InstallerJava.log("unzip size bigger than max allowed");
                    fileInputStream.close();
                    gZIPInputStream.close();
                    fileOutputStream.close();
                    return false;
                }
                fileOutputStream.write(byArray, 0, n);
            }
            InstallerJava.log("Length read : " + n2);
            bl = true;
            fileInputStream.close();
            gZIPInputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            bl = false;
            InstallerJava.log("Exception " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    private boolean download_and_unzip(String string, String string2, String string3) {
        String string4;
        boolean bl = false;
        if (string == null || string2 == null || string3 == null) {
            InstallerJava.log("Improper inputs");
            return false;
        }
        if (this.verifyFileAgainstManifest(string2, string3)) {
            InstallerJava.log("Not downloading " + string3);
            return true;
        }
        if (!this.downloadFile(string = string + "/" + string3 + ".gz", string4 = string2 + this.fileSep + string3 + ".gz")) {
            InstallerJava.log("failed to download" + string);
            return false;
        }
        bl = this.unzip(string4, string2, string3);
        if (!bl) {
            InstallerJava.log("failed to unzip" + string4);
        }
        InstallerJava.log("Deleting file " + string4);
        if (!this.deleteFile(string4)) {
            InstallerJava.log("Could not delete " + string4);
        }
        return bl;
    }

    private boolean downloadManifest(String string) {
        String string2 = string;
        String string3 = "manifest";
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (manifest != null) {
            return true;
        }
        if (string == null) {
            InstallerJava.log("Improper inputs");
            return false;
        }
        if (OsIsWindows) {
            string2 = string2 + "/windows_i386/manifest";
        } else if (OsIsLinuxI386) {
            string2 = string2 + "/linux_i386/manifest";
        } else if (OsIsLinuxX64) {
            string2 = string2 + "/linux_x64/manifest";
        } else if (OsIsIntelMac64) {
            string2 = string2 + "/darwin_x64/manifest";
        } else {
            InstallerJava.log_unsupported_platform("Unsupported platform");
            return false;
        }
        InstallerJava.log("Manifest download url : " + string2);
        bl = this.downloadInMemory(string2, stringBuffer);
        manifest = stringBuffer.toString();
        return bl;
    }

    private boolean doesPathExist(String string) {
        boolean bl = false;
        if (string == null) {
            InstallerJava.log("Improper inputs");
            return false;
        }
        try {
            File file = new File(string);
            bl = file.exists();
            if (!bl) {
                InstallerJava.log("'" + string + "' does not exist");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private boolean doesFileExist(String string, String string2) {
        if (string == null || string2 == null) {
            InstallerJava.log("Improper inputs");
            return false;
        }
        return this.doesPathExist(string + this.fileSep + string2);
    }

    private static String bytes_to_hex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            if ((byArray[i] & 0xFF) < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Long.toString(byArray[i] & 0xFF, 16));
        }
        return stringBuffer.toString();
    }

    private boolean verifyFileAgainstManifest(String string, String string2) {
        boolean bl = false;
        String string3 = "";
        if (string == null || string2 == null) {
            return false;
        }
        if (manifest == null) {
            return false;
        }
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            File file = new File(string + this.fileSep + string2);
            if (!file.exists()) {
                InstallerJava.log(string2 + " does not exist");
                return false;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            if (fileInputStream == null) {
                InstallerJava.log("Could not open stream");
                return false;
            }
            int n = 0;
            while ((n = fileInputStream.read(byArray, 0, 1024)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            if (messageDigest == null) {
                InstallerJava.log("Cannot create Message Digest");
                return false;
            }
            byte[] byArray2 = messageDigest.digest(byteArrayOutputStream.toByteArray());
            String string4 = InstallerJava.bytes_to_hex(byArray2);
            if (manifest.indexOf(string4) < 0) {
                InstallerJava.log("No match in manifest for " + string2);
                bl = false;
            } else {
                InstallerJava.log("Found match in manifest for " + string2);
                bl = true;
            }
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private String get_hs_bin_path() {
        String string = null;
        try {
            if (!OsIsWindows) {
                String string2 = System.getProperty("user.home");
                string2 = OsIsMac ? string2 + hs64MacBinPath : string2 + hsBinPath;
                File file = new File(string2);
                string = file.getAbsolutePath();
            } else {
                string = System.getProperty("java.io.tmpdir");
                if (!string.endsWith(this.fileSep)) {
                    string = string.concat(this.fileSep);
                }
            }
        }
        catch (Exception exception) {
            string = null;
            exception.printStackTrace();
        }
        return string;
    }

    private String get_hs_libs_path() {
        String string = null;
        if (OsIsWindows) {
            return null;
        }
        try {
            String string2 = System.getProperty("user.home");
            string2 = OsIsMac ? string2 + hs64MacLibPath : string2 + hsLibPath;
            File file = new File(string2);
            string = file.getAbsolutePath();
        }
        catch (Exception exception) {
            string = null;
            exception.printStackTrace();
        }
        return string;
    }

    private String get_cstub_name() {
        if (OsIsWindows) {
            return "cstub.exe";
        }
        return "cstub";
    }

    public void SetCookie() {
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this);
            JSObject jSObject2 = (JSObject)jSObject.getMember("document");
            String string = "61560";
            String string2 = "hsJavaApplet";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z");
            Date date = new Date();
            Date date2 = new Date(date.getTime() + 300000L);
            String string3 = simpleDateFormat.format(date2);
            String string4 = string2 + "=" + string + "; path=/; expires=" + string3;
            jSObject2.setMember("cookie", string4);
        }
        catch (Exception exception) {
            InstallerJava.log("Exception occured: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    @Override
    public void start() {
        this.t = new Thread(new Runnable(){

            @Override
            public void run() {
                InstallerJava.this.start2();
            }
        });
        this.t.start();
    }

    public void start2() {
        this.setStatus(STATUS_STARTED);
        int n = STATUS_STUB_FAILURE;
        this.SetCookie();
        this.url = this.getParameter("url");
        this.ticket = this.getParameter("ticket");
        this.stub = this.getParameter("stub");
        this.group = this.getParameter("group");
        this.certhash = this.getParameter("certhash");
        this.version = this.getParameter("version");
        String string = this.url;
        try {
            CharSequence charSequence;
            Object object;
            Object[] objectArray;
            Object object2;
            String string2 = "";
            boolean bl = true;
            Examiner examiner = null;
            String string3 = this.url.substring(0, this.url.lastIndexOf("/"));
            String string4 = string3.substring(0, string3.lastIndexOf("/")) + "/hostscan";
            String string5 = this.get_hs_bin_path();
            String string6 = this.get_cstub_name();
            string2 = string5 + this.fileSep + string6;
            examiner = this.getExaminer();
            if (examiner == null) {
                this.setStatus(STATUS_STUB_FAILURE);
                this.setErrorCode(STUB_ERROR_DLL_LOAD_FAILED);
                return;
            }
            try {
                if (!OsIsWindows && this.downloadManifest(string4) && this.verifyFileAgainstManifest(string5, string6)) {
                    bl = false;
                }
                if (OsIsWindows) {
                    string2 = examiner.getCachedInstPath();
                    InstallerJava.log("Retrieved CSD stub path: " + string2);
                    if (!this.version.equals("") && examiner.instUpToDate(string2, this.version)) {
                        InstallerJava.log("Cached CSD stub version: " + this.version + " matches version on headend");
                        InstallerJava.log("Skipping CSD stub download");
                        bl = false;
                    } else {
                        InstallerJava.log("CSD stub will be downloaded");
                    }
                }
            }
            catch (Exception exception) {
                InstallerJava.log("Non-fatal exception when trying to check for a cached version. continuing...");
            }
            if (bl) {
                boolean bl2 = false;
                if (OsIsWindows) {
                    object2 = string4 + "/windows_i386/cstub.exe";
                    bl2 = this.downloadFile((String)object2, string2);
                    if (examiner == null) {
                        InstallerJava.log("Error instantiating examiner");
                        this.setStatus(STATUS_STUB_FAILURE);
                        this.setErrorCode(STUB_ERROR_DLL_LOAD_FAILED);
                        return;
                    }
                    if (!examiner.verifyFile(string2)) {
                        InstallerJava.log("untrusted download");
                        this.setStatus(STATUS_STUB_FAILURE);
                        this.setErrorCode(STUB_ERROR_VERIFICATION_FAILED);
                        return;
                    }
                    try {
                        objectArray = examiner.getCachedInstPath();
                        if (!objectArray.equals(string2)) {
                            object = new File((String)objectArray);
                            charSequence = ((File)object).getParent();
                            if (charSequence != null) {
                                new File((String)charSequence).mkdirs();
                            }
                            this.createFileFromStream(new FileInputStream(string2), (File)object);
                        }
                    }
                    catch (Exception exception) {
                        InstallerJava.log("Non-fatal exception when trying to store a cached copy. continuing...");
                    }
                } else if (OsIsLinuxI386) {
                    object2 = string4 + "/linux_i386/cstub";
                    bl2 = this.downloadFile((String)object2, string2);
                } else if (OsIsLinuxX64) {
                    object2 = string4 + "/linux_x64/cstub";
                    bl2 = this.downloadFile((String)object2, string2);
                } else if (OsIsIntelMac64) {
                    object2 = string4 + "/darwin_x64/cstub";
                    bl2 = this.downloadFile((String)object2, string2);
                } else {
                    InstallerJava.log_unsupported_platform("Unknown platform. Cannot download stub launcher.");
                    this.setStatus(STATUS_STUB_FAILURE);
                    this.setErrorCode(STUB_UNKNOWN_PLATFORM);
                    return;
                }
                if (!bl2) {
                    InstallerJava.log("Failed to download cstub");
                    return;
                }
            }
            if (!examiner.verifyFile(string2)) {
                InstallerJava.log("untrusted download");
                this.setStatus(STATUS_STUB_FAILURE);
                this.setErrorCode(STUB_ERROR_VERIFICATION_FAILED);
                return;
            }
            Runtime runtime = Runtime.getRuntime();
            object2 = new Vector();
            if (!OsIsWindows) {
                try {
                    objectArray = "/bin/chmod u+x " + string2;
                    object = runtime.exec((String)objectArray);
                    int n2 = ((Process)object).waitFor();
                    if (n2 != 0) {
                        InstallerJava.log("chmod returned: " + n2);
                        this.setStatus(STATUS_STUB_FAILURE);
                        this.setErrorCode(STUB_CHANGE_PERMISSION_FAILED);
                        return;
                    }
                }
                catch (Exception exception) {
                    InstallerJava.log("Exception while giving executable permissions to stub");
                    this.setStatus(STATUS_STUB_FAILURE);
                    this.setErrorCode(STUB_CHANGE_PERMISSION_FAILED);
                    InstallerJava.log("Exception occured: " + exception.getMessage());
                    exception.printStackTrace();
                    return;
                }
            }
            ((Vector)object2).addElement(string2);
            if (this.ticket.length() > 0 && this.stub.length() > 0) {
                ((Vector)object2).addElement("-ticket");
                ((Vector)object2).addElement(this.ticket);
                ((Vector)object2).addElement("-stub");
                ((Vector)object2).addElement(this.stub);
            }
            if (this.certhash.length() > 0) {
                ((Vector)object2).addElement("-certhash");
                ((Vector)object2).addElement(this.certhash);
            }
            if (this.group.length() > 0) {
                ((Vector)object2).addElement("-group");
                ((Vector)object2).addElement(this.group);
            }
            ((Vector)object2).addElement("-url");
            ((Vector)object2).addElement(string);
            if (this.langsel.length() > 0) {
                ((Vector)object2).addElement("-langsel" + this.langsel);
            }
            objectArray = new String[((Vector)object2).size()];
            ((Vector)object2).copyInto(objectArray);
            try {
                object = runtime.exec((String[])objectArray, null);
                InstallerJava.log("Spawned CSD stub.");
                this.setStatus(STATUS_STUB_IN_PROGRESS);
                n = ((Process)object).waitFor();
            }
            catch (Exception exception) {
                if (examiner != null && OsIsWindows) {
                    InstallerJava.log("Trying native launching");
                    charSequence = new StringBuffer("");
                    for (int i = 1; i < objectArray.length; ++i) {
                        ((StringBuffer)charSequence).append(" ");
                        ((StringBuffer)charSequence).append((String)objectArray[i]);
                    }
                    if (examiner.exec((String)objectArray[0], ((StringBuffer)charSequence).toString())) {
                        try {
                            this.setStatus(STATUS_STUB_IN_PROGRESS);
                            Thread.currentThread();
                            Thread.sleep(30000L);
                            InstallerJava.log("Launch successful");
                            this.setStatus(STATUS_STUB_SUCCESS);
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    InstallerJava.log("Native Launch failed");
                    this.setStatus(STATUS_STUB_FAILURE);
                    this.setErrorCode(STUB_NATIVE_LAUNCH_FAILED);
                    return;
                }
                throw exception;
            }
            if (n != 0) {
                this.setStatus(STATUS_STUB_FAILURE);
                if (n != STUB_EXIT_CODE_MAX) {
                    if (OsIsWindows) {
                        this.setErrorCode(n);
                    } else {
                        this.setErrorCode((byte)n);
                    }
                } else {
                    this.setErrorCode(STUB_ERROR_UNKNOWN);
                }
            } else {
                this.setStatus(STATUS_STUB_SUCCESS);
            }
        }
        catch (Exception exception) {
            InstallerJava.log("Exception occured: " + exception.getMessage());
            exception.printStackTrace();
            this.setStatus(STATUS_STUB_FAILURE);
            this.setErrorCode(STUB_ERROR_UNKNOWN);
        }
    }

    static {
        String string = MacOsSubVersion = OsIsIntelMac ? splitSubVersions[1] : "";
        OsIsMacMavericksAndAbove = OsIsIntelMac ? Integer.parseInt(MacOsSubVersion) > 8 : false;
        hsLibPath = "/.cisco/hostscan/lib";
        hsBinPath = "/.cisco/hostscan/bin";
        hs64MacLibPath = "/.cisco/hostscan/lib64";
        hs64MacBinPath = "/.cisco/hostscan/bin64";
        MAX_ZIP_SIZE = 0x3200000;
        HS_JS_VARIABLE_NAME_STATUS = "hs_js_var_status";
        HS_JS_VARIABLE_NAME_ERRORCODE = "hs_js_var_errorcode";
    }
}

