'''
Created on Aug 15, 2016

@author: Akshay Ahluwalia
Copyright (c) 2016 by Cisco Systems

'''
from devpkg.base.dmobject import DMObject
from devpkg.base.dmlist import DMList

class Features(object):
    vnsNone       = 0x0
    vnsClusterCfg = 0x1   # Flag to indicate if the stuff under vnsClusterCfg should be modified
    vnsDevCfg     = 0x2   # Flag to indicate if the configuration under vnsDevCfg folder should be modified
    vnsMFunc      = 0x4   # Flag to indicate if the function configuration should be modified
    vnsAll        = vnsClusterCfg | vnsDevCfg | vnsMFunc
    deleteAll     = 0x8    # Flag used in tests to clean the device

class InterfaceLabel(object):
    'The enumeration of the interface labels defined in device_specifciation.xml'
    External = "ext"
    Internal = "int"
    Mgmt     = "mgmt"
    Utility  = "util"
    FailoverLan  = "lan"   # The LAN based failover connection between the two failover devices
    FailoverLink = "link"  # The link(stateful) failover connection between the two failover devices
    ClusterControLink = "ccl"

class DeviceModel(DMObject):
    '''
    This is the representation of the device configuration in IFC model. The structure should be the same as
    device_specification.xml. Namely, at the top level, we have the
        - MFunc: the function configuration. In our case, it can be "NGIPS/Firewall".
        - MGrpCfg: the configuration shared by different functions.
        - MDevCfg: the configuration shared by all groups.
    The order to register the components is important, that is the order to translate configuration
    from IFC format to device format.

    NOTE:
    The configuration structure of the device_specification.xml is based on "Insieme Service Management Integration"
    version 0.2. It is not quite in the final state yet, and is very likely to change.
    '''

    def __init__(self, device = None, interfaces = None, features = Features.vnsAll, is_audit = False):
        '''
        @param device: dict
            to identify the device, passed in from device_script APIs
        @param interfaces: dict
            physical interfaces names passed in from device_script APIs
        @param features: bit-mask from Features
            to indicate what part of configurations to generate
        @param is_audit: boolean
            to indicate if this is used in a xxxxAudit device script API
        '''
        DMObject.__init__(self, ifc_key = DeviceModel.__name__)
        self.device = device
        self.interfaces = interfaces
        self.is_audit = is_audit
        """
        override to add children that will be part of the device model
        """
        

    'ToDo: CSCvd20931 - Comment out the code block for now to improve the coder coverage. The code is not executed for current implementation.'
#     def get_device(self):
#         '@return the device parameter from device script API'
#         return self.device
# 
#     def get_interfaces(self):
#         """
#         @attention:  It is recommended to use get_nameif instead of calling get_interfaces by applications.
#         @return the interfaces parameter from device script API'
#         """
#         return self.interfaces
    
    def get_device_dn(self):
        """
        Get the new dn information. Not backwards compatible with APIC that does not have the dn.
        """
        return self.device['dn']

    def is_virtual(self):
        '@return True if this device is IPSv, otherwise false'
        return self.device.get('virtual', False) if self.device else False

    def is_vlan_supported(self):
        """
        @return True if VLAN Trunking is supported, otherwise false.
        By default, APIC does not support VLAN for virtual FTD/NGIPS: Trunking Port
        option is not available when creating a L4-L7 device. Admin can turn it
        on by checking the checkbox after a device is created.
        If the flag 'tagPackets' is True in config parameter then we support it.
        """
        return not self.is_virtual() or self.delta_ifc_cfg_value.get('tagPackets', False)

    'ToDo: CSCvd20931 - Comment out the code block for now to improve the coder coverage. The code is not executed for current implementation.'
#     def is_audit(self):
#         return self.is_audit
#     
#     def iter_groups(self):
#         groups = self.get_child('SharedConfig')
#         if groups:
#             for group in groups.children.itervalues():
#                 yield group
