'''
Created on Feb 17, 2015

@author: pgarg

Debug class for device package
'''

import os

STATUS_DEPLOYABLE = "found_deployable_device"
DEPLOYMENT_VERSION = "deployment_version"
DEPLOYMENT_ID_LIST = "deployment_id_list"
OPERATION_IN_PROGRESS = "operation_in_progress"
ERROR_429_COUNTER = "error_429_counter"
UNDEFINED = "undefined"

def debug(message, severity=1):
    '''
    Display a debug message.

    Args:
        message: Message to display
        severity: Severity of the message
    '''
    try:
        import Insieme.Logger as Logger
        Logger.log(Logger.INFO, message)
    except Exception as e:
        print message

def set_variable(variable_name, variable_value):
    '''
    Expose a variable.

    @variable_name - the name of the variable to be exposed
    @variable_value - the value of the variable to be exposed
    '''

    os.environ[variable_name] = variable_value

def get_variable(variable_name):
    '''
    Get the exposed variable.

    @return - exposed variable value
    '''

    return os.environ[variable_name] if os.environ.has_key(variable_name) else UNDEFINED

