'''
Created on Aug 3, 2016

@author: Akshay Ahluwalia

Copyright (c) 2016 by Cisco Systems, Inc.
All rights reserved.

Classes used for Access Policy.
'''
from devpkg.base.dmobject import DMObject
from devpkg.utils.state_type import State


from fmc.parsers import device_object_executor,acpolicy_update_default_action, acpolicy_update_description, delete_acpolicy_executor, parse_response_for_target, access_policy_assignment_executor
from devpkg.base.command_interaction import CommandInteraction
from acrule import AccessRules

class AccessPolicy(DMObject):
    """
    The Access Policy Cli maker 
    """
    GENERAL_AC_POLICY = """
    {
      "type": "AccessPolicy",
      "name": "ACI-FTD",
      "defaultAction": {
        "action" : "BLOCK"
      }
    }
    """
    
    def __init__(self, probe):
        DMObject.__init__(self, AccessPolicy.__name__)
        self.dm_key_command='createAccessPolicy'
        self.dm_key = "AccessPolicy"
        self.command_executor=device_object_executor
        self.register_child(AccessRules(probe=probe))
        self.probe = probe
        
    def ifc2dm(self, no_dm_cfg_stack, dm_cfg_list):
        self.recursive_state = self.get_state_recursive()
                
        clii = None
        if not self.has_ifc_delta_cfg():
            return
        num, pol, name = self.delta_ifc_key
        clii = CommandInteraction(self.dm_key, model_key=self.get_config_path(), probe=self.probe)
        self.cli = clii
        if self.get_state() == State.CREATE or self.get_state() == State.MODIFY:
            clii.add_basic_interaction('fmc_config/v1/domain/<domainUUID>/policy/accesspolicies', name, device_object_executor, AccessPolicy.GENERAL_AC_POLICY)
            clii.add_param("defaultAction", "", acpolicy_update_default_action, "fmc_config/v1/domain/<domainUUID>/policy/accesspolicies/<AccessPolicyUUID>/defaultactions/", "defaultAction", response_parser = parse_response_for_target, response_parser_arg={"target":"action"})
            if self.get_state() == State.CREATE:
                clii.add_param("description", self.get_top_uuid(), acpolicy_update_description, "", "description")
            clii.add_data_param(name, 'name')
            self.set_state(State.DESTROY) # marking as destroyed so that cli gets fired before the add commands
            

            self.get_child('AccessRule').ifc2dm(no_dm_cfg_stack, dm_cfg_list) #set up accessrule
            self.register_child(ACPolicyAssignment(clii.idParam, clii.get_name()))
            self.get_child('ACPolicyAssignment').ifc2dm(no_dm_cfg_stack, dm_cfg_list) #set up access policy assignment
            
        elif self.get_state() == State.DESTROY:
            clii.add_basic_interaction('fmc_config/v1/domain/<domainUUID>/policy/accesspolicies', name, delete_acpolicy_executor, AccessPolicy.GENERAL_AC_POLICY)
            clii.add_param("defaultAction", "", acpolicy_update_default_action, "fmc_config/v1/domain/<domainUUID>/policy/accesspolicies/<AccessPolicyUUID>/defaultactions/", "defaultAction", response_parser = parse_response_for_target, response_parser_arg={"target":"action"})
            clii.add_data_param(self.get_top_uuid(), "top_id", False)
            
            self.get_child('AccessRule').ifc2dm(no_dm_cfg_stack, dm_cfg_list)
            
        else: #we always run a get request just to get the uuid
            clii.add_basic_interaction('fmc_config/v1/domain/<domainUUID>/policy/accesspolicies', name, None, AccessPolicy.GENERAL_AC_POLICY)
            self.get_child('AccessRule').ifc2dm(no_dm_cfg_stack,  dm_cfg_list)
            self.set_state(State.DESTROY) #marking as destroyed so that cli gets fired before the add commands
        dm_cfg_list.insert(0, clii)
            
class ACPolicyAssignment(DMObject):
    GENERAL_ACPOLICY = """
    { 
         "type": "PolicyAssignment",
         "policy": { "type": "AccessPolicy", "name": "PG Policy", "id": "0050569E-47E6-0ed3-0000-012884902396" },
        "name" :"PG Policy",
        "id" : "0d884ce4-1efc-11e5-9b76-fecb288e03ec"
    }
    """
    def __init__(self, ac_id, ac_name):
        DMObject.__init__(self, ACPolicyAssignment.__name__)
        self.dm_key = "ACPolicyAssignment"
        self.dm_key_command = "fmc_config/v1/domain/<domainUUID>/assignment/policyassignments/<acUUID>"
        self.ac_id = ac_id
        self.ac_name = ac_name
        
    def ifc2dm(self, no_dm_cfg_stack, dm_cfg_list):
        'Populate current instance recursive state based on children and dependent objects.'
        
        local_dm_cfg_list = []
        # Process for commands if state modified.
        clii = CommandInteraction(self.dm_key, model_key=self.get_config_path())
        clii.set_param_device_name()
        clii.set_param_device_uuid()
        clii.add_data_param([{"id":clii.get_param_device_uuid(), "type":"Device", "name":clii.get_param_device_name(), "keepLocalEvents": "false", "prohibitPacketTransfer": "false"}], "targets")
        clii.state = State.MODIFY
        local_dm_cfg_list.append(clii)

        # Process instance children for command generation.        
            
        clii.add_basic_interaction("fmc_config/v1/domain/<domainUUID>/assignment/policyassignments", self.ac_name, access_policy_assignment_executor, ACPolicyAssignment.GENERAL_ACPOLICY)
        clii.add_data_param({"type":"AccessPolicy", "name": self.ac_name, "id":self.ac_id}, "policy")
        clii.add_data_param(self.ac_name, "name")
            
        # Add command for later execution.    
        if local_dm_cfg_list.__len__() > 0 and local_dm_cfg_list[0].params.__len__() > 0:
            dm_cfg_list.append(local_dm_cfg_list[0])
     