'''
Created on Mar. 3, 2018

@author: Feng (Edward) Liu (feliu@cisco.com), Linlin Liang (linlilia@cisco.com)

Copyright (c) 2018 by Cisco Systems, Inc.
All rights reserved.

Classes used for Static Routes.
'''
from devpkg.base.command_interaction import CommandInteraction
from devpkg.base.dmobject import DMObject
from devpkg.utils.state_type import State
import fmc.parsers
import devpkg.base.command_service
from devpkg.utils.errors import FMC429Error

class Networks(DMObject):

    def __init__(self, name, value, state, probe):
        DMObject.__init__(self, Networks.__name__)
        self.name = name
        self.value = value
        self.state = state
        self.probe = probe

    def push_config(self, device, dispatch_executor):
        clii = CommandInteraction(self.dm_key, model_key=self.get_config_path(), probe=self.probe)
        self.cli = clii
        if self.state == State.CREATE or self.state == State.MODIFY:
            clii.add_basic_interaction("fmc_config/v1/domain/<domainUUID>/object/networks", None, fmc.parsers.ipv4_network_executor, None)
            clii.add_data_param(self.value, "network")
        else: #we always run a get request just to get the uuid
            clii.add_basic_interaction("fmc_config/v1/domain/<domainUUID>/object/networks", self.name, None)
            self.set_state(State.DESTROY) #marking as destroyed so that cli gets fired before the add commands
        try:
            # There are changes, commit
            executor = devpkg.base.command_service.CommandService(device, [clii], dispatch_executor)
            executor.execute(False, False)
        except FMC429Error as fmc429error:
            raise FMC429Error(fmc429error.message)
         
        

