'''
Created on Apr 12, 2015

@author: Puneet Garg

Copyright (c) 2013 by Cisco Systems
'''
from devpkg.base.dmobject import DMObject

class DMList(DMObject):
    '''A list of the same type of DMObject's.
    '''
    def __init__(self, name, child_class, dm_key='', probe=None):
        '''
        @param self: DMList instance
            this class instance
        @param name: str
            the key for this configuration from the device specification file.
        @param child_class: class
            the type of elements in the list
        '''
        DMObject.__init__(self, name, dm_key)
        self.name = name
        self.child_class = child_class
        self.dependent_on = [] #list of DMObjects that are this instance is dependant on
        self.probe = probe

    def register_child(self, dmobj):
        '''Override the default implementation to prevent add child of the wrong type
        '''
        if isinstance(dmobj, self.child_class):
            DMObject.register_child(self, dmobj)
            self.dependent_on.append(dmobj.ifc_key)#add the name of the child class to the dependant on information
        else:
            raise Exception("Child has wrong type")

    'ToDo: CSCvd20931 - Comment out the code block for now to improve the coder coverage. The code is not executed for current implementation.'
#     def add(self, child):
#         '''Add an element from the list
#         @param self: DMList instance
#             this class instance
#         @param child: child_class
#         '''
#         self.register_child(child)
# 
#     def remove(self, child):
#         '''Remove an element from the list
#         @param self: DMList instance
#             this class instance
#         @param child: child_class
#             element to add
#         '''
#         if isinstance(child, self.child_class):
#             self.remove_by_key(child.get_key())
# 
#     def remove_by_key(self, child_key):
#         '''Remove an element from the list
#         @param self: DMList instance
#             this class instance
#         @param child_key: key
#            the key of the child in the list
#         '''
#         if child_key in self.children:
#             del(self.children[child_key])


    def populate_model(self, delta_ifc_key, delta_ifc_cfg_value):
        '''Override the default implementation to dynamically generate
        child instance from the "instance" value in the delta_ifc_key
        @attention:
            Assuming the child class initializer takes one argument.
            Override this method if this assumption is not right for your particular class.
        '''
        kind, key, instance = delta_ifc_key
        #create a instance of child_class
        if self.name in ('Interface', 'InterfaceConfig', 'SecurityZone', 'AccessPolicy', 'AccessRule', 'InlineSet', 'NetworkObjectGroup', 'BridgeGroupInterface'):
            child = self.child_class(instance, self.probe) 
        else:
            child = self.child_class(instance)
        self.register_child(child)
        child.populate_model(delta_ifc_key, delta_ifc_cfg_value)

    'ToDo: CSCvd20931 - Comment out the code block for now to improve the coder coverage. The code is not executed for current implementation.'
#     def create_missing_ifc_delta_cfg(self):
#         '''Override the default implementation, because in most use cases,
#         DMList is 'transparent' with respect to ifc_delta_cfg
#         '''
#         if not self.children or self.has_ifc_delta_cfg():
#             return
# 
#         for child in self.children.values():
#             child.create_missing_ifc_delta_cfg()
