'''
Created on April 22, 2016

@author: Akshay Ahluwalia

Copyright (c) 2016 by Cisco Systems, Inc.
All rights reserved.

Classes used for testing ParamCommand.
'''
from devpkg.utils.util import asciistr
from devpkg.base.command_interaction import CommandParam

class CommandParamAppend(CommandParam):
    """
    A Specialized CommandParam Object that takes an append that can be added to the end of the param_value while
    being instantiated. 
    """
    def __init__(self, append="", *args, **kwargs):
        """
        @param append: the string that is to be applied. if param_value is a dict it will 
            be applied to all valued in the dict.
        """
        CommandParam.__init__(self, *args, **kwargs)
        if isinstance(self.param_value, dict):
            for k,v in self.param_value.iteritems():
                self.param_value[k] = asciistr(v) + asciistr(append)
        else:
            self.param_value += append
            
    def get_value(self):
        return self.param_value
