'''
Created on Apr 12, 2015

@author: Puneet Garg

Copyright (c) 2015 by Cisco Systems, Inc.
All rights reserved.

Classes used for NGIPS function.
'''

from devpkg.base.dmlist import DMList
from devpkg.base.dmobject import DMObject
from devpkg.connector import ExIntfConfigRelFolder, InIntfConfigRelFolder, Connector
from devpkg.utils.state_type import State, Type

class FTD(DMObject):
    '''
    This is the function configuration of NGIPS, assuming the name of "MFunc" element in the device_specifcation is "NGIPS".
    Add NGIPS related configuration objects by call self.register_child(dmobj) in
    the constructor as it is done in DeviceModel.__init(self)__.
    '''
    def __init__(self):
        DMObject.__init__(self, FTD.__name__)
        self.register_child(ExIntfConfigRelFolder())
        self.register_child(InIntfConfigRelFolder())
        self.register_child(DMList('CONN', Connector))

    'ToDo: CSCvd20931 - Comment out the code block for now to improve the coder coverage. The code is not executed for current implementation.'
#    'TODO: Check if not used remove me!!'    
#     def build_cli2dmobject(self):
#         'Return a dictionary of CLI prefix to the DMObject that can translate that CLI'
#         result = {}
#         for child in self.children.values():
#             cli_prefixes = child.get_cli_prefixes()
#             for cli_prefix in cli_prefixes:
#                 if result.has_key(cli_prefix):
#                     result[cli_prefix].append(child)
#                 else:
#                     result[cli_prefix] = [child]
#         return result
# 
#     def get_interface(self, connector_name):
#         conn = self.get_connector(connector_name)
#         if conn:
#             return conn.interface
# 
#     def get_interfaces(self):
#         'Returns a tuple of the external,internal interfaces'
# 
#         external = None
#         internal = None
# 
#         rel = self.get_child('ExIntfConfigRelFolder').get_child('ExIntfConfigRel')
#         if hasattr(rel, 'value'):
#             external = rel.value
#         rel = self.get_child('InIntfConfigRelFolder').get_child('InIntfConfigRel')
#         if hasattr(rel, 'value'):
#             internal = rel.value
#         if external and internal:
#             return external,internal
# 
#     'TODO: Check if my implementation is required and correct??'
#     def get_translator(self, cli):
#         'Override the default to fast-track the lookup'
#         cli_prefix = cli.split()[0] if isinstance(cli, basestring) else cli.command.split()[0]
#         dmobjects = self.cli2dmobject.get(cli_prefix, None)
#         if not dmobjects:
#             return None
#         for dmobj in dmobjects:
#             #look into its children
#             result = dmobj.get_translator(cli)
#             if result:
#                 return result
# 
#     def get_connector(self, connector_name):
#         for conn in self.iter_connectors():
#             if hasattr(conn, 'conn_type') and conn.conn_type == connector_name:
#                 return conn
# 
#     def iter_connectors(self):
#         for connector in self.get_child('CONN').children.itervalues():
#             yield connector
# 
#     def create_missing_ifc_delta_cfg(self):
#         '''Override the default to take care of the way self.delta_ifc_key is created
#         '''
#         if  not self.has_ifc_delta_cfg():
#             '@todo isolate changes to key creation'
#             self.delta_ifc_key = Type.FUNC, FTD.__name__, self.ifc_key,
#             self.delta_ifc_cfg_value = {'state': State.NOCHANGE, 'value': {}}
#             ancestor = self.get_ifc_delta_cfg_ancestor()
#             if ancestor:
#                 ancestor.delta_ifc_cfg_value['value'][self.delta_ifc_key] =  self.delta_ifc_cfg_value
#         for child in self.children.values():
#             child.create_missing_ifc_delta_cfg()
