'''
Created on Mar. 3, 2018

@author: Feng (Edward) Liu (feliu@cisco.com)

Copyright (c) 2018 by Cisco Systems, Inc.
All rights reserved.

Classes used for Static Routes.
'''
from devpkg.base.command_interaction import CommandInteraction
from devpkg.base.dmboolean import DMBoolean
from devpkg.base.dmlist import DMList
from devpkg.base.dmobject import DMObject
from devpkg.base.simpletype import SimpleType
from devpkg.utils.state_type import State
from fmc.parsers import device_object_executor, delete_device_object_executor, ipv4_static_route_executor
import fmc.config_keeper

class IPv4StaticRoute(DMObject):
    GENERAL_STATIC_ROUTE = """
    {
                "type": "IPv4StaticRoute",
                "network": "0.0.0.0/0",
                "gateway": "192.168.0.1",
                "metric": "1",
                "isTunneled" : "false"
    }    
    """

    METRIC_DEFAULT_VALUE = '1'

    'IPv4 Static Route object.'
    def __init__(self, instance):
        super(IPv4StaticRoute, self).__init__(instance, dm_key='IPv4StaticRoute')
        self.dm_key_command='createIPv4StaticRoute'
        self.dm_key = 'IPv4StaticRoute'
        self.command_executor=device_object_executor
        self.register_child(SimpleType('network', 'network', '0.0.0.0/0'))
        self.register_child(SimpleType('gateway', 'gateway', '192.168.0.1'))
        self.register_child(SimpleType('metric', 'metric', defaults=IPv4StaticRoute.METRIC_DEFAULT_VALUE))
        self.register_child(DMBoolean('isTunneled', 'isTunneled', 'enable', defaults = False))

    def ifc2dm(self, no_dm_cfg_stack, dm_cfg_list):
        """
        construct the cli
        """
        self.recursive_state = self.get_state_recursive()
        local_dm_cfg_list = []
        if not self.has_ifc_delta_cfg():
            return
        super(IPv4StaticRoute, self).ifc2dm(no_dm_cfg_stack, local_dm_cfg_list)
        clii = None      
        if self.get_state() != State.DESTROY:
            clii = CommandInteraction(self.dm_key, model_key=self.get_config_path())
            clii.add_basic_interaction("fmc_config/v1/domain/<domainUUID>/devices/devicerecords/<deviceUUID>/routing/ipv4staticroutes", None, ipv4_static_route_executor, IPv4StaticRoute.GENERAL_STATIC_ROUTE)
            clii.add_data_param(self.children['network'].delta_ifc_cfg_value['value'], 'network')
            if self.parent.parent.parent.delta_ifc_cfg_value['value'].has_key((5, 'bridge_group_id', 'BridgeGroupId')):
                # In the case of IPv4 route on BVI interface, we derive interfaceName from BridgeGroupId
                clii.add_data_param('BVI' + self.parent.parent.parent.delta_ifc_cfg_value['value'][(5, 'bridge_group_id', 'BridgeGroupId')]['value'], 'interfaceName')
            else:
                clii.add_data_param(self.parent.parent.parent.delta_ifc_cfg_value['value'][(5, 'ifname', 'ifname')]['value'], 'interfaceName')
            clii.add_data_param(self.children['gateway'].delta_ifc_cfg_value['value'], 'gateway')
            if self.children['metric'].has_ifc_delta_cfg():
                clii.add_data_param(self.children['metric'].delta_ifc_cfg_value['value'], 'metric')
            if self.children['isTunneled'].has_ifc_delta_cfg():
                clii.add_data_param(self.children['isTunneled'].delta_ifc_cfg_value['value'], 'isTunneled')
                    
        if clii is not None:
            self.add_cli_to_array(clii, dm_cfg_list)

    def add_cli_to_array(self, clii, array):
        '''
        adds the cli to the array and sets the cli to its own cli
        @param clii: the clii
        @param array: an array
        @param always_append: if set to True will always append regardless of state
        '''
        self.cli = clii
        self.cli.state = self.get_state()
        #we need to make sure that all the modify calls happen first
        if self.get_state() == State.DESTROY:
            array.insert(0, self.cli)
        else:
            array.append(self.cli)
        
class IPv4StaticRoutes(DMList):
    'A list of Static Routes'

    def __init__(self, name = IPv4StaticRoute.__name__, child_class = IPv4StaticRoute, probe = None):
        super(IPv4StaticRoutes, self).__init__(name, child_class, probe=probe)

    def ifc2dm(self, no_dm_cfg_stack,  dm_cfg_list):
        super(IPv4StaticRoutes, self).ifc2dm(no_dm_cfg_stack,  dm_cfg_list)