
'''
Created on Apr 12, 2015

@author: Puneet Garg

Copyright (c) 2015 by Cisco Systems, Inc.
All rights reserved.

Classes used for device command executor invocation.
'''
import inspect
class CommandExecutor:
    """
    CommandExecutor performs all execution of the cli
    """
    def __init__(self, dispatch, command, probe, executor = None):
        self.dispatch = dispatch
        self.command_holder = command
        self.executor = executor
        self.probe = probe
        
    def preexecute(self):
        return [None]    
    
    def execute(self):
        errors = self.preexecute()
        if errors != None and errors.__len__() > 0 and errors[0] is not None:
            return errors
        'Bring all dependent parameters uuid.'
        if hasattr(self.command_holder, 'params'):
            for paramValue in self.command_holder.params.values(): #for each child in the parent
                if paramValue.command_executor: #can execute
                    if inspect.isclass(paramValue.command_executor): #is a function
                        executor = paramValue.command_executor(self.dispatch, paramValue)
                    else:
                        executor = CommandExecutor(self.dispatch, paramValue, self.probe, paramValue.command_executor)
                    errors = executor.execute()
                    
                    'In case errors throw back.'
                    if paramValue.throw_error and errors and errors.__len__() > 0 and errors[0] is not None:
                        return errors
                else:
                    paramValue.param_uuid = paramValue.param_value
                    
        if self.executor:
            errors = self.executor(self)
        else:
            return [None]
            
        if errors != None and errors.__len__() > 0 and errors[0] is not None:
            return errors
        errors = self.postexecute()    
        return errors
    
    def postexecute(self):
        if self.command_holder.postexecute == None:
            return [None]
        else:
            return self.command_holder.postexecute(self)
           
