'''
Created on Apr 12, 2015

@author: Puneet Garg

Copyright (c) 2015 by Cisco Systems
'''
from devpkg.base.simpletype import SimpleType

class DMBoolean(SimpleType):
    ''' DMBoolean is translator for the type of value that turns on/off a particular parameter, such as "Interface enabled'
    '''
    def __init__(self, ifc_key, dm_key, on_value, defaults = None, response_parser=None):
        '''
        @param on_value: str
            The value in the dictionary to turn on the feature, e.g. 'enable'
        '''
        SimpleType.__init__(self, ifc_key, dm_key, is_removable = True)
        self.on_value = on_value
        self.response_parser = response_parser
        self.defaults = defaults
