'''
Created on Feb 17, 2015

@author: pgarg

Exception classes for device package

'''
class ConnectionError(Exception):
    def __init__(self, message):
        Exception.__init__(self, message)

class ConfigurationError(Exception):
    def __init__(self, fault_list):
        self.fault_list = fault_list

class IFCConfigError(ConfigurationError):
    def __init__(self, fault_list):
        ConfigurationError.__init__(self, fault_list)

class DeviceConfigError(ConfigurationError):
    def __init__(self, fault_list):
        ConfigurationError.__init__(self, fault_list)

class DeviceBusyError(Exception):
    def __init__(self, message):
        Exception.__init__(self, message)

class FMC429Error(Exception):
    def __init__(self, message):
        Exception.__init__(self, message)

class FaultCode(object):
    CONFIGURATION_ERROR=10
    CONNECTION_ERROR=20
    UNEXPECTED_ERROR=30
    UNSUPPORTED_DEVICE=40
    BUSY_ERROR=50
    LINE_STATUS_ERROR=60
    FMC_429_ERROR=70
