'''
Created on Nov 3, 2016

Copyright (c) 2016 by Cisco Systems, Inc.
All rights reserved.

@author: aahluwalia
'''
from devpkg.utils.util import asciistr
import copy
class Config_Maker(object):
    """
    Makes custom configs for the device calls
    """
    AC_POLICY_TEMPLATE = {(13, "AccessPolicy", "<name>") : {"state": 0, "value":{}}}
    AC_RULES_TEMPLATE = {(13, "AccessRule", "<name>"):{"state":0, "value":{(13,  "AccSourceZones", "AccSourceZones"):{"state":0, "value":{(13, "SourceZones", "SourceZones") : {"state" : 0, "target":"<target1>"}}}, (13, "AccDestinationZones", "AccDestinationZones"): {"state":0, "value":{(13, "DestinationZones", "DestinationZones") : {"state" : 0, "target":"<target2>"}}}}}}
    SZ_TEMPLATE = {(13, "SecurityZone", "<name>"):{"state":0, "value":{(13, "type", "type") : {"state":0, "value":"<sz_value>"}}}}
    IS_TEMPLATE = {(13, "InlineSet", "<name>"):{"state":0, "value":{(13, "failsafe", "failsafe"):{"state":0, "value":"<fs_value>"}, (13, "MTU", "MTU"): {"state":0, "value":"<mtu_value>"}}}}
    INTERFACE_TEMPLATE = {(13, "InterfaceConfig", "<name>"):{"state":0, "value":{(13, "enabled", "enabled"):{"state":0, "value":"<en_value>"}, (13, "ifname", "ifname"):{"state":0, "value":"<if_value>"}, (13, "int_security_zone", "int_security_zone"):{"state":0, "value":{(13, "security_zone", "security_zone"):{"state":0, "target":"<sz_target>"}}}}}}
    ETHERCHANNEL_TEMPLATE = {(13, "InterfaceConfig", "<name>"):{"state":0, "value":{(13, "enabled", "enabled"):{"state":0, "value":"<en_value>"}, (13, "ifname", "ifname"):{"state":0, "value":"<if_value>"}, (13, "int_security_zone", "int_security_zone"):{"state":0, "value":{(13, "security_zone", "security_zone"):{"state":0, "target":"<sz_target>"}}}}}}
    STATICROUTE_TEMPLATE = {(4, "StaticRoute", "StaticRoute"):{"state":0, "value":{(4, "ipv4route", "<name>"):{"state":0, "value":{(5, 'isTunneled', 'isTunneled'):{'state': 0, 'value': '<isTunneled_value>'}, (5, 'metric', 'metric'): {'state': 0, 'value': "<metric_value>"}, (5, 'network', 'network'): {'state': 0, 'value': "<network_value>"}, (5, 'gateway', 'gateway'): {'state': 0, 'value': "<gateway_value>"}}}}}}
    SUB_INTERFACE_TEMPLATE = {(13, "InterfaceConfig", "<name>"):{"state":0, "value":{(13, "enabled", "enabled"):{"state":0, "value":"<en_value>"}, (13, "ifname", "ifname"):{"state":0, "value":"<if_value>"}, (13, "vlanId", "vlanId"):{"state" :0, "value":"<vlan_id>"}, (13, "subIntfId", "subIntfId"):{"state" :0, "value":"<sub_intf_id>"}, (13, "int_security_zone", "int_security_zone"):{"state":0, "value":{(13, "security_zone", "security_zone"):{"state":0, "target":"<sz_target>"}}}}}}
    BGI_TEMPLATE = {(13, "BridgeGroupInterface", "<name>") : {"state":0, "value":{}}}
    INT_INLINE_SET = {(4, 'int_inline_set', 'int_inline_set'): {'state': 1, 'transaction': 0, 'ackedstate': 0, 'value': {(6, 'inline_set', 'InlineSetRel'): {'state': 1, 'transaction': 0, 'target': "IPSSet", 'ackedstate': 0}}}}

    def __init__(self, probe, ldev):
        """
        created a basic config
        """
        self.probe = probe
        self.config_created = False
        self.ldev = ldev.replace('+', '\+')
        self.config = {(0, '', ldev) : {"state" : 0, "value": {}}}
        self.config_value = self.config.values()[0]["value"]
    def create_config(self):
        """
        We create the configs
        @todo: we need to do complete graph creation. Currently It doesnt matter for delete since delete is pretty good at knowning what to delete
        """
        if self.config_created:
            return self.config
        self.config_created = True
        ac_policy = self.probe.find_all_with_params_regex(description = "_GENERATED.+%s" % self.ldev, type = "AccessPolicy")
        all_ac_rules = self.probe.find_all_with_param_regex("commentHistoryList", ".+%s" % self.ldev)
        name_regex = ".+%s" % self.ldev
        all_sz = self.probe.find_all_with_params_regex(name = name_regex, type = "SecurityZone")
        all_is = self.probe.find_all_with_params_regex(name = name_regex, type = "InlineSet")
        all_interface = self.probe.find_all_with_params_regex(ifname = name_regex, type = "PhysicalInterface")
        all_sub_interface = self.probe.find_all_with_params_regex(ifname = name_regex, type = "SubInterface")
        all_etherchannel = self.probe.find_all_with_params_regex(ifname = name_regex, type = "EtherChannelInterface")
        all_bgi = self.probe.find_all_with_params_regex(description = "ACI_GENERATED.+%s" % self.ldev, type = "BridgeGroupInterface")
        #these are all arrays of jsons
        if len(ac_policy) > 0:
            ac_policy = ac_policy[0]
            key = Config_Helper.return_new_key_name(Config_Maker.AC_POLICY_TEMPLATE, ac_policy['name'])
            value = Config_Maker.AC_POLICY_TEMPLATE.values()[0]
            
            if len(all_ac_rules) > 0:
                for x in all_ac_rules:
                    ar_key = Config_Helper.return_new_key_name(Config_Maker.AC_RULES_TEMPLATE, x['name'])
                    ar_value = Config_Maker.AC_RULES_TEMPLATE.values()[0]
                    value['value'].update({ar_key:ar_value})
            self.config_value.update({key:value})
        
        
        self.add_array_of_configs(Config_Maker.SZ_TEMPLATE, all_sz)
        self.add_array_of_configs(Config_Maker.IS_TEMPLATE, all_is)
        self.add_array_of_configs(Config_Maker.SUB_INTERFACE_TEMPLATE, all_sub_interface, if_value="ifname", vlan_id="vlanId", sub_intf_id="subIntfId")
        self.add_array_of_configs(Config_Maker.INTERFACE_TEMPLATE, all_interface, if_value="ifname", mode='mode')
        self.add_array_of_configs(Config_Maker.ETHERCHANNEL_TEMPLATE, all_etherchannel, if_value="ifname", mode='mode')
        self.add_array_of_configs(Config_Maker.BGI_TEMPLATE, all_bgi)
        
        return self.config
                    
    def add_array_of_configs(self, config, arr, **kwargs):
        """
        Adds an array of predetermined configs to the config
        @param config: the generic config
        @param arr: the array of jsons that has the data
        @param kwargs: the list of specilized params that compares to the arr and the config
        Example:kwarg = {"if_value" : "ifname"} will find the ifname in the json and apply it to the <if_value> in the config
        """
        if len(arr) > 0:
            cli_type, cli_key, cli_instance = config.keys()[0]
            for x in arr:
                vlan = ""
                value = copy.deepcopy(config.values()[0])
                try:
                    if "vlanId" in kwargs.itervalues():
                        vlan = x['vlanId']
                        key = Config_Helper.return_new_key_name(config, x['name']+"_SPEC_ID"+asciistr(vlan))
                    else:
                        key = Config_Helper.return_new_key_name(config, x['name'])
                    if "mode" in kwargs.itervalues():
                        if x['mode'] == 'INLINE': #inline mode must treat as inline for physical FTD. CSCvd88725
                            value['value'].update(Config_Maker.INT_INLINE_SET)
                except:
                    pass
                if len(kwargs) > 0:
                    for i in Config_Helper.config_crawl(value):
                        for k, v in kwargs.iteritems():
                            if not x.has_key(v):
                                continue
                            if i.has_key("value"):
                                if i['value'] == "<%s>" % k:
                                    i['value'] = x[v]
                if cli_key == 'InterfaceConfig':
                    # For InterfaceConfig we may need to add IPv4 static route config
                    if value.has_key('value') and value['value'].has_key((13, 'ifname', 'ifname')) and value['value'][(13, 'ifname', 'ifname')].has_key('value'):
                        ifname = asciistr(value['value'][(13, 'ifname', 'ifname')]['value'])
                        sr_key = Config_Helper.return_new_key_name(Config_Maker.STATICROUTE_TEMPLATE, ifname)
                        sr_value = Config_Maker.STATICROUTE_TEMPLATE.values()[0]
                        v = value['value']
                        v[sr_key] = sr_value
                        value['value'] = v
                self.config_value.update({key:value})
    
class Config_Helper(object):
    """
    Bunch of functions that help with config manipulation
    """
    @staticmethod
    def edit_all_config_state(config, state):
        """
        for the config make all states into the given state
        """
        for point in Config_Helper.config_crawl(config):
            if point.has_key('state'):
                point['state'] = state
        return config
        
    @staticmethod
    def config_crawl(config):
        """
        @return an array of all of the point in the config so that it can be looped over
        """
        ret_arr = []
        itr = None
        bft = []
        if config.has_key("value"):
            bft = [config]
        else:
            for itr in config.values():
                bft.append(itr)
        while len(bft) > 0:
            itr = bft.pop()
            if not isinstance(itr, dict):
                continue
            ret_arr.append(itr)
            if itr.has_key("value"):
                if isinstance(itr['value'], dict):
                    for i in itr['value'].itervalues():
                        bft.append(i)
            if itr.has_key("target"):
                if isinstance(itr['target'], dict):
                    for i in itr['target'].itervalues():
                        bft.append(i)
            
        return ret_arr
    
    @staticmethod
    def return_new_key_name(config_partial, name):
        """
        return the key name for the config given
        """
        keys = config_partial.keys()[0]
        one, two, three = keys
        three = name
        return (one, two, three)
        
