'''
Created on Mar 30, 2016

@author: Akshay Ahluwalia

Copyright (c) 2016 by Cisco Systems, Inc.
All rights reserved.

Classes used for SecurityZone.
'''
from devpkg.base.command_interaction import CommandInteraction
from fmc.parsers import device_object_executor, delete_device_object_executor
from devpkg.base.dmobject import DMObject
from devpkg.base.validators import Validator
from devpkg.base.simpletype import SimpleType
from devpkg.utils.state_type import State
from devpkg.base.dmlist import DMList
from devpkg.base.command_interaction import CommandResult



class SecurityZone(DMObject, Validator):
    """
    Security Zone Object
    """
    GENERAL_SECURITY_ZONE = """
    {
      "name": "External",
      "type": "SecurityZone",
      "interfaceMode": "INLINE"
    }"""
    def __init__(self, instance, probe):
        super(SecurityZone, self).__init__(instance, dm_key="SecurityZone", probe=probe)
        self.dm_key_command = "createSecurityZone"
        self.command_executor=device_object_executor
        self.register_child(SimpleType('type', 'type', defaults="INLINE"))
        self.probe = probe
    
    def ifc2dm(self, no_dm_cfg_stack, dm_cfg_list):
        self.recursive_state = self.get_state_recursive()
        k, t, n = self.delta_ifc_key
        if k != 13:
            self.ifc_key += self.get_unique_graph_string_append() #add Tenant + Ldev to the name

        if not self.has_ifc_delta_cfg():
            return
        
        if self.get_state() == State.CREATE or self.get_state() == State.MODIFY:
            clii = CommandInteraction(self.dm_key, model_key=self.get_config_path(), probe=self.probe)
            clii.add_basic_interaction("fmc_config/v1/domain/<domainUUID>/object/securityzones", self.ifc_key, self.command_executor, SecurityZone.GENERAL_SECURITY_ZONE)
            clii.add_data_param(self.ifc_key, "name")
            try:
                clii.add_data_param(self.get_child("type").get_value().upper(), "interfaceMode")
            except:
                pass
            self.add_cli_to_array(clii, dm_cfg_list)
            
            
        elif self.get_state() == State.DESTROY:
            clii = CommandInteraction(self.dm_key, model_key=self.get_config_path(), probe=self.probe)
            clii.add_basic_interaction("fmc_config/v1/domain/<domainUUID>/object/securityzones", self.ifc_key, delete_device_object_executor, SecurityZone.GENERAL_SECURITY_ZONE)
            self.add_cli_to_array(clii, dm_cfg_list)
        
        else: #we have to get the uuid as a minimum
            clii = CommandInteraction(self.dm_key, model_key=self.get_config_path(), probe=self.probe)
            clii.add_basic_interaction("fmc_config/v1/domain/<domainUUID>/object/securityzones", self.ifc_key, None, SecurityZone.GENERAL_SECURITY_ZONE)
            self.add_cli_to_array(clii, dm_cfg_list)

class SecurityZoneInterfaceBridgeGroup(CommandInteraction):
    """
    Interface Cli used to add the security zone into it. Used by the Inline Interface.
    """
    def __init__(self, interface_config, interface_clii, probe=None):
        super(SecurityZoneInterfaceBridgeGroup, self).__init__("SecurityZoneInterfaceBridgeGroup", interface_clii.model_key, probe=probe)
        self.state = State.MODIFY
        try:
            if interface_config.find('int_security_zone').get_state() != State.DESTROY:
                sz_cli = interface_config.find("/SecurityZone/%s" % interface_clii.params['int_security_zone'].param_value['security_zone']).cli
                sz_id = sz_cli.idParam
                self.add_data_param([{"id":interface_clii.idParam}], "interfaces")
            else:
                self.add_data_param([], "interfaces")
        except:
            pass
        self.add_basic_interaction("fmc_config/v1/domain/<domainUUID>/object/securityzones", sz_cli.get_name(), device_object_executor, SecurityZone.GENERAL_SECURITY_ZONE)
        self.probe = probe
                     

class SecurityZones(DMList):
    'A list of Interfaces'

    def __init__(self, name = SecurityZone.__name__, child_class = SecurityZone, probe=None):
        super(SecurityZones, self).__init__(name, child_class, probe=probe)
        self.probe = probe

    def ifc2dm(self, no_dm_cfg_stack,  dm_cfg_list):
        super(SecurityZones, self).ifc2dm(no_dm_cfg_stack,  dm_cfg_list)
