#!/usr/bin/python3

# Task 8
# - low level disassembly
# - manual processing of a binary
# - reconstructing a hashing function
# - reverting API name hashes

import api_names, sys, struct

def calc_api_hash(name):
    # 3. Implement the API name hashing routine
    result = REPLACE_WITH_THE_SOLUTION
    return result

api_hashes = {}

# Calculate the inverse search dictionary
for name in api_names.api_names:
    api_hashes[calc_api_hash(name)] = name

num_found_hashes = 0

def check_hash(hash_value):
    global num_found_hashes

    if hash_value in api_hashes:
        num_found_hashes = num_found_hashes + 1
        api_name = api_hashes[hash_value]
        idc.write("MakeRptCmt(0x%08X, \"%s\");\n" % (i, api_name))
        print("%08X %s" % (i, api_name))

with open(sys.argv[1], 'rb') as inf:
    data = bytearray(inf.read())
    with open(sys.argv[1] + '.idc', 'w+t') as idc:
        idc.write("#include <idc.idc>\nstatic main(void) {\nauto f;\n")
        for i in range(0,len(data)-20):
            if data[i] == None: # 1. Replace None with the byte corresponding to the opcode
                                # look for mov ecx, imm32
                hash_value = struct.unpack("<L", data[0])[0] # 2. Replace data[0] with a dynamic expression, to correctly extract
                                     # the 32-bit operand of the current opcode
                check_hash(hash_value)

				
        idc.write("}\n")

if num_found_hashes < 137:
    print(f'You have found {num_found_hashes}, but there are more. Try again')
else:
    print(f'Perfect! API for hash 0x1BF5EAA0 is {api_hashes[0x1BF5EAA0]}')
