#!/usr/bin/env python3

from decoder_core import *
import re, struct

class Decoder(DecoderBase):
    def decode(self):
        print(f"data: {len(self.data)}")
        start_func = b"\x64\x8B\x0D\x14\x00\x00\x00" # mov     ecx, large fs:14h
        
        # 1. Fill in the regular expression that will match both calls to runtime.stringtoslicebyte, 
        #       and it must match the following sequence of operands for m.start(n)+m expressions to work,
        #       otherwise update these expressions, too
        # lea     reg, va_of_string
        # mov     [esp+4], reg
        # mov     dword ptr [esp+8], len_of_string
        # call 
        slice_string = b"(" + b"REPLACE_WITH_THE_SOLUTION" + b")" 
        
        xor_loop = b"\x0F\xB6<\)1\xFE\x83\xFD" # movzx   edi, byte ptr [ecx+ebp]
                                            # xor     esi, edi
                                            # cmp     ebp,
        pattern = start_func + b".{10,100}" + slice_string + b".{10,100}" + slice_string + b".{10,100}" + xor_loop
        pat = re.compile(pattern, re.DOTALL|re.MULTILINE)
        matches = pat.finditer(bytes(self.data))

        with open(self.fileName + '.idc', 'w+t') as idc:
            idc.write("#include <idc.idc>\nstatic main(void) {\nauto f;\n")

            for m in matches:
                va = self.format.RawToVA(m.start())
                # Now, let's extract the parameters. 
                # m[0] is the whole matches
                # m[1] is the first group in parentheses (each group is searching for stringtoslicebyte calls)
                string1_va = struct.unpack("<L", self.data[m.start(1) + 2 : m.start(1) + 2 + 4])[0]
                string_len = struct.unpack("<L", self.data[m.start(1) + 0xE : m.start(1) + 0xE + 4])[0]
                string2_va = struct.unpack("<L", self.data[m.start(2) + 2 : m.start(2) + 2 + 4])[0]
                func_va = self.format.RawToVA(m.start())

                print(f"// Found a decryption loop, {hex(string1_va)} ^ {hex(string2_va)} len {hex(string_len)}")

                # Get the file offsets of the strings, so we can address them with self.data[offset_raw:]
                string1_raw = self.format.VAToRaw(string1_va) 
                string2_raw = self.format.VAToRaw(string2_va)
                # Buffer for the resulting string
                str_decrypted = ""
                for i in range(string_len):
                    # 2. Replace None with a valid expression to decrypt every character of the string
                    str_decrypted += None 
                print(f"// Decrypted string: {str_decrypted}, func: {hex(func_va)}")

                self.data[string1_raw:string1_raw+string_len] = str_decrypted.encode('ascii')
                self.data[string2_raw:string2_raw+string_len] = b"\x20"*string_len

                # Force IDA to mark a string
                idc.write(f"del_items({hex(string1_va)},0,{hex(string_len)});\n")
                idc.write(f"create_strlit({hex(string1_va)},{hex(string_len)});\n")

            idc.write("}\n")

Decoder()

