/*
 * Decompiled with CFR 0.152.
 */
package wlanbulk.view;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.util.encoders.Base64;
import sun.misc.BASE64Decoder;
import wlanbulk.Main;

public class SecurityUtil {
    public void encrypt(String publicKeyFilename, String inputFilename, String encryptedFilename) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            if (Security.getProvider("BC") == null) {
                System.out.println("Bouncy Castle provider is NOT available");
            }
            String key = SecurityUtil.readFileContent(publicKeyFilename);
            AsymmetricKeyParameter publicKey = PublicKeyFactory.createKey((byte[])Base64.encode((byte[])key.getBytes()));
            RSAEngine e = new RSAEngine();
            e = new PKCS1Encoding((AsymmetricBlockCipher)e);
            e.init(true, (CipherParameters)publicKey);
            String inputdata = SecurityUtil.readFileContent(inputFilename);
            byte[] messageBytes = inputdata.getBytes();
            byte[] hexEncodedCipher = e.processBlock(messageBytes, 0, messageBytes.length);
            BufferedWriter out = new BufferedWriter(new FileWriter(encryptedFilename));
            out.write(SecurityUtil.getHexString(hexEncodedCipher));
            out.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public String encrypt(String publicKeyFilename, String inputData) {
        String value;
        block5: {
            value = "";
            Security.addProvider((Provider)new BouncyCastleProvider());
            if (Security.getProvider("BC") != null) break block5;
            System.out.println("Bouncy Castle provider is NOT available");
            return null;
        }
        try {
            BASE64Decoder b64 = new BASE64Decoder();
            String key = SecurityUtil.readFileContent(publicKeyFilename);
            String publicKeyPEM = key.replace("-----BEGIN PUBLIC KEY-----\n", "");
            publicKeyPEM = publicKeyPEM.replace("-----END PUBLIC KEY-----", "");
            AsymmetricKeyParameter publicKey = PublicKeyFactory.createKey((byte[])b64.decodeBuffer(publicKeyPEM));
            RSAEngine e = new RSAEngine();
            e = new PKCS1Encoding((AsymmetricBlockCipher)e);
            e.init(true, (CipherParameters)publicKey);
            byte[] messageBytes = inputData.getBytes();
            int i = 0;
            int len = e.getInputBlockSize();
            while (i < messageBytes.length) {
                if (i + len > messageBytes.length) {
                    len = messageBytes.length - i;
                }
                byte[] hexEncodedCipher = e.processBlock(messageBytes, i, len);
                value = String.valueOf(value) + SecurityUtil.getHexString(hexEncodedCipher);
                i += e.getInputBlockSize();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return value;
    }

    public static String getHexString(byte[] b) throws Exception {
        String result = "";
        int i = 0;
        while (i < b.length) {
            result = String.valueOf(result) + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            ++i;
        }
        return result;
    }

    private static String readFileContent(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new InputStreamReader(Main.class.getResourceAsStream(filePath)));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    public void decrypt(String privateKeyFilename, String encryptedFilename, String outputFilename) {
        String value = "";
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            FileReader privateKeyReader = new FileReader(new File(privateKeyFilename));
            PEMParser parser = new PEMParser((Reader)privateKeyReader);
            PEMKeyPair keyPair = (PEMKeyPair)parser.readObject();
            AsymmetricKeyParameter privateKey = PrivateKeyFactory.createKey((PrivateKeyInfo)keyPair.getPrivateKeyInfo());
            RSAEngine e = new RSAEngine();
            e = new PKCS1Encoding((AsymmetricBlockCipher)e);
            e.init(false, (CipherParameters)privateKey);
            String inputdata = SecurityUtil.readFileContent(encryptedFilename);
            byte[] messageBytes = SecurityUtil.hexStringToByteArray(inputdata);
            int i = 0;
            int len = e.getInputBlockSize();
            while (i < messageBytes.length) {
                if (i + len > messageBytes.length) {
                    len = messageBytes.length - i;
                }
                byte[] hexEncodedCipher = e.processBlock(messageBytes, i, len);
                value = String.valueOf(value) + new String(hexEncodedCipher);
                i += e.getInputBlockSize();
            }
            System.out.println(value);
            BufferedWriter out = new BufferedWriter(new FileWriter(outputFilename));
            out.write(value);
            out.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public String decrypt(String privateKeyFilename, String encryptedData) {
        String outputData = null;
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            String key = SecurityUtil.readFileContent(privateKeyFilename);
            BASE64Decoder b64 = new BASE64Decoder();
            AsymmetricKeyParameter privateKey = PrivateKeyFactory.createKey((byte[])b64.decodeBuffer(key));
            RSAEngine e = new RSAEngine();
            e = new PKCS1Encoding((AsymmetricBlockCipher)e);
            e.init(false, (CipherParameters)privateKey);
            byte[] messageBytes = SecurityUtil.hexStringToByteArray(encryptedData);
            byte[] hexEncodedCipher = e.processBlock(messageBytes, 0, messageBytes.length);
            outputData = new String(hexEncodedCipher);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return outputData;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }
}

