#!/system/bin/sh
PATH=/system/bin:/system/xbin:$PATH
PART_ALIAS=dm-userdata
CRYPTO_BLOCK_DEVICE=/dev/block/dm-userdata
MOUNT_POINT=/dataRoot

MOUNT_FLAGS="nosuid,nodev,noatime,nomblk_io_submit,"
BLOCK_OPT=""
 
active_part=`/bin/cat /proc/cisco/activePartition`
ACTIVE_BLOCK_DEVICE=/dev/userdata-$active_part


# No encryption for Data partition on SD Cards
if [ $active_part = 0 ]
then
	# Kill tf_daemon, let it be started as service later as security user
	TF_DAEMON_PID=`/system/bin/ps | /system/xbin/grep tf_daemon | /system/xbin/cut -d" " -f7`
	kill -9 ${TF_DAEMON_PID}
	exit 0
fi

silent_crypt $PART_ALIAS $ACTIVE_BLOCK_DEVICE $CRYPTO_BLOCK_DEVICE
ret=$?
if [ $ret -ne 0 ]; then
	#Can't get key, Catastrophic Failure - reboot
	/system/bin/reboot
exit 0
fi

# Wait for device to exist
for i in 1 2 3 4 5 6 7 8 9 10
do
    if [ -e ${ACTIVE_BLOCK_DEVICE} ]; then
        break;
    else
        echo "Waiting for ${ACTIVE_BLOCK_DEVICE}"
        sleep 1
    fi
done

echo "DMCRYPT: Atempting to mount crypto device ${CRYPTO_BLOCK_DEVICE}"  >> /tmp/cryptfs.log

if [ -e ${ACTIVE_BLOCK_DEVICE} ]; then
	/system/bin/mount -t ext4 -o ${MOUNT_FLAGS} ${CRYPTO_BLOCK_DEVICE} ${MOUNT_POINT}
	ret=$?
	if [ $ret -ne 0 ]; then
		echo "DMCRYPT: Problem mounting, formatting device.  make_ext4fs ${BLOCK_OPT} ${CRYPTO_BLOCK_DEVICE}"  >> /tmp/cryptfs.log
		make_ext4fs ${BLOCK_OPT} ${CRYPTO_BLOCK_DEVICE}
		ret=$?
		if [ $ret -eq 0 ]; then
			echo "DMCRYPT: ${PART_ALIAS} partition formatted"  >> /tmp/cryptfs.log
		else
			echo "DMCRYPT: ${PART_ALIAS} partition format failed"  >> /tmp/cryptfs.log
		fi
		/system/bin/mount -t ext4 -o ${MOUNT_FLAGS} ${CRYPTO_BLOCK_DEVICE} ${MOUNT_POINT}
		ret=$?
		if [ $ret -eq 0 ]; then
			echo "DMCRYPT: crypto device ${CRYPTO_BLOCK_DEVICE} is mounted at ${MOUNT_POINT}"  >> /tmp/cryptfs.log
		else
			echo "DMCRYPT: crypto device ${CRYPTO_BLOCK_DEVICE} failed to mount at ${MOUNT_POINT}"  >> /tmp/cryptfs.log
		fi

	else
		echo "DMCRYPT: crypto device ${CRYPTO_BLOCK_DEVICE} is mounted at ${MOUNT_POINT}"  >> /tmp/cryptfs.log
	fi
fi

#
# Kill tf_daemon, let it be started as service later as security user
# "awk" not available on user debug / rel loads  use "cut"
#
TF_DAEMON_PID=`/system/bin/ps | /system/xbin/grep tf_daemon | /system/xbin/cut -d" " -f7`
kill -9 ${TF_DAEMON_PID}
